/*
 * Decompiled with CFR 0.152.
 */
package Users;

import Users.OnlineUser;
import Users.OnlineUsersManager;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.luckperms.api.model.group.Group;
import net.luckperms.api.model.user.User;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.types.InheritanceNode;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class OnlineUsersManagerLuckPerms
extends OnlineUsersManager {
    private BukkitTask schedule;
    private String configSound;
    private String configMessage;

    public OnlineUsersManagerLuckPerms() {
        this.restartSchedule();
    }

    public void restartSchedule() {
        if (this.schedule != null) {
            this.schedule.cancel();
        }
        this.schedule = new BukkitRunnable(){

            public void run() {
                Map groups;
                if (OnlineUsersManagerLuckPerms.this.plugin.getConfiguration().getLuckPermsCheckVerbose()) {
                    Bukkit.getConsoleSender().sendMessage("[\u00a76PlayTime\u00a7eManager\u00a7f]\u00a77 Luckperms check started, refresh rate is " + OnlineUsersManagerLuckPerms.this.convertTime(OnlineUsersManagerLuckPerms.this.plugin.getConfiguration().getLuckPermsCheckRate()) + ".\n If you find this message annoying you can deactivate it by changing \u00a76luckperms-check-verbose \u00a77in the config.yml");
                }
                if ((groups = OnlineUsersManagerLuckPerms.this.plugin.groups).isEmpty()) {
                    OnlineUsersManagerLuckPerms.this.schedule.cancel();
                    Bukkit.getConsoleSender().sendMessage("[\u00a76PlayTime\u00a7eManager\u00a7f]\u00a77 No group has been detected in the database, luckperms check canceled.");
                }
                for (OnlineUser onlineUser : OnlineUsersManagerLuckPerms.this.onlineUsers) {
                    for (String group : groups.keySet()) {
                        User userLuckPerms;
                        Group groupLuckPerms = OnlineUsersManagerLuckPerms.this.plugin.luckPermsApi.getGroupManager().getGroup(group);
                        if (groupLuckPerms == null || onlineUser.getPlaytime() < (Long)groups.get(group) || (userLuckPerms = OnlineUsersManagerLuckPerms.this.plugin.luckPermsApi.getUserManager().getUser(UUID.fromString(onlineUser.getUuid()))) == null) continue;
                        boolean hasGroup = false;
                        for (Node node : userLuckPerms.getNodes()) {
                            String groupName;
                            if (!node.getKey().startsWith("group.") || !(groupName = node.getKey().substring(6)).equals(group)) continue;
                            hasGroup = true;
                            break;
                        }
                        if (hasGroup) continue;
                        InheritanceNode node = (InheritanceNode)((InheritanceNode.Builder)InheritanceNode.builder((Group)groupLuckPerms).value(true)).build();
                        userLuckPerms.data().add((Node)node);
                        OnlineUsersManagerLuckPerms.this.plugin.luckPermsApi.getUserManager().saveUser(userLuckPerms);
                        Player p = Bukkit.getPlayerExact((String)onlineUser.getNickname());
                        if (p == null) continue;
                        try {
                            OnlineUsersManagerLuckPerms.this.configSound = OnlineUsersManagerLuckPerms.this.plugin.getConfiguration().getLuckPermsGoalSound();
                            Sound sound = Sound.valueOf((String)OnlineUsersManagerLuckPerms.this.configSound);
                            p.playSound(p.getLocation(), sound, 10.0f, 0.0f);
                        }
                        catch (IllegalArgumentException exception) {
                            OnlineUsersManagerLuckPerms.this.plugin.getLogger().severe(OnlineUsersManagerLuckPerms.this.configSound + " is not a valid argument for luckperms-time-goal-soundsetting in config.yaml");
                        }
                        OnlineUsersManagerLuckPerms.this.configMessage = OnlineUsersManagerLuckPerms.this.replacePlaceholders(OnlineUsersManagerLuckPerms.this.plugin.getConfiguration().getLuckPermsGoalMessage(), p, group);
                        p.sendMessage(OnlineUsersManagerLuckPerms.this.configMessage);
                        Bukkit.getServer().getConsoleSender().sendMessage("[\u00a76PlayTime\u00a7eManager\u00a7f]\u00a77 User \u00a7e" + onlineUser.getNickname() + " \u00a77has reached \u00a76" + OnlineUsersManagerLuckPerms.this.convertTime((Long)groups.get(group) / 20L) + " \u00a77so it is now part of \u00a7e" + group + " \u00a77group!");
                    }
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, this.plugin.getConfiguration().getLuckPermsCheckRate() * 20L);
    }

    private String convertTime(long secondsx) {
        int days = (int)TimeUnit.SECONDS.toDays(secondsx);
        int hours = (int)(TimeUnit.SECONDS.toHours(secondsx) - TimeUnit.DAYS.toHours(days));
        int minutes = (int)(TimeUnit.SECONDS.toMinutes(secondsx) - TimeUnit.HOURS.toMinutes(hours) - TimeUnit.DAYS.toMinutes(days));
        int seconds = (int)(TimeUnit.SECONDS.toSeconds(secondsx) - TimeUnit.MINUTES.toSeconds(minutes) - TimeUnit.HOURS.toSeconds(hours) - TimeUnit.DAYS.toSeconds(days));
        if (days != 0) {
            return days + "d, " + hours + "h, " + minutes + "m, " + seconds + "s";
        }
        if (hours != 0) {
            return hours + "h, " + minutes + "m, " + seconds + "s";
        }
        if (minutes != 0) {
            return minutes + "m, " + seconds + "s";
        }
        return seconds + "s";
    }

    public String replacePlaceholders(String input, Player p, String group) {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%PLAYER_NAME%", p.getName());
        placeholders.put("%GROUP_NAME%", group);
        String playTimeSeconds = this.convertTime((Long)this.plugin.groups.get(group) / 20L);
        placeholders.put("%TIME_REQUIRED%", playTimeSeconds);
        for (Map.Entry entry : placeholders.entrySet()) {
            input = input.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
        }
        return input;
    }
}

