/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.Commands.PlayTimeCommandManager;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import me.thegabro.playtimemanager.PlayTimeManager;
import me.thegabro.playtimemanager.Users.DBUser;
import me.thegabro.playtimemanager.Users.DBUsersManager;
import me.thegabro.playtimemanager.Users.OnlineUser;
import me.thegabro.playtimemanager.Users.OnlineUsersManager;
import me.thegabro.playtimemanager.Utils;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.Statistic;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PlayTimeResetTime {
    private final PlayTimeManager plugin = PlayTimeManager.getInstance();
    private final DBUsersManager dbUsersManager = DBUsersManager.getInstance();
    private final OnlineUsersManager onlineUsersManager = OnlineUsersManager.getInstance();
    private static final Map<UUID, PendingReset> pendingResets = new HashMap<UUID, PendingReset>();
    private static final long CONFIRMATION_TIMEOUT_SECONDS = 60L;

    public PlayTimeResetTime(CommandSender sender, String[] args) {
        this.execute(sender, args);
    }

    public void execute(CommandSender sender, String[] args) {
        String resetType;
        String string = resetType = args.length >= 3 ? args[2].toLowerCase() : "all";
        if (!(resetType.equals("db") || resetType.equals("stats") || resetType.equals("all"))) {
            sender.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getPluginPrefix() + " Invalid reset type. Use 'db', 'stats', or 'all'"));
            return;
        }
        if (args[0].equals("*")) {
            this.handleResetAllConfirmation(sender, resetType);
            return;
        }
        this.resetSinglePlayer(sender, args[0], resetType);
    }

    private void handleResetAllConfirmation(CommandSender sender, String resetType) {
        UUID senderUUID = sender instanceof Player ? ((Player)sender).getUniqueId() : UUID.fromString("00000000-0000-0000-0000-000000000000");
        if (pendingResets.containsKey(senderUUID)) {
            PendingReset pendingReset = pendingResets.get(senderUUID);
            if (pendingReset.isExpired()) {
                pendingResets.remove(senderUUID);
                sender.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getPluginPrefix() + " Your previous reset confirmation has expired. Please try again."));
                this.requestConfirmation(sender, senderUUID, resetType);
                return;
            }
            if (!pendingReset.resetType.equals(resetType)) {
                pendingResets.remove(senderUUID);
                sender.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getPluginPrefix() + " Reset type has changed. Please confirm again."));
                this.requestConfirmation(sender, senderUUID, resetType);
                return;
            }
            pendingResets.remove(senderUUID);
            this.resetAllPlayers(sender, resetType);
        } else {
            this.requestConfirmation(sender, senderUUID, resetType);
        }
    }

    private void requestConfirmation(CommandSender sender, UUID senderUUID, String resetType) {
        pendingResets.put(senderUUID, new PendingReset(resetType));
        sender.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getPluginPrefix() + " &c&lWARNING&r&7: You are about to reset " + this.getResetTypeDescription(resetType) + " for &e&lALL players&7!"));
        sender.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getPluginPrefix() + " &7This action cannot be undone. Run the command again within 60 seconds to confirm."));
    }

    private void resetAllPlayers(CommandSender sender, String resetType) {
        sender.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getPluginPrefix() + " Starting reset of all players' " + this.getResetTypeDescription(resetType) + ", this will take some time..."));
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            List<DBUser> users = this.dbUsersManager.getAllDBUsers();
            AtomicInteger totalPlayersReset = new AtomicInteger();
            AtomicLong totalPlaytimeReset = new AtomicLong();
            HashSet processedPlayerUUIDs = new HashSet();
            CompletionStage<Object> resetFuture = CompletableFuture.completedFuture(null);
            if (resetType.equals("stats") || resetType.equals("all")) {
                resetFuture = ((CompletableFuture)resetFuture).thenCompose(v -> {
                    CompletableFuture statsFuture = new CompletableFuture();
                    Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                        for (Player player : Bukkit.getOnlinePlayers()) {
                            UUID playerUUID = player.getUniqueId();
                            long currentPlaytime = player.getStatistic(Statistic.PLAY_ONE_MINUTE);
                            totalPlaytimeReset.addAndGet(currentPlaytime);
                            if (!processedPlayerUUIDs.contains(playerUUID)) {
                                totalPlayersReset.getAndIncrement();
                                processedPlayerUUIDs.add(playerUUID);
                            }
                            player.setStatistic(Statistic.PLAY_ONE_MINUTE, 0);
                            OnlineUser onlineUser = this.onlineUsersManager.getOnlineUserByUUID(playerUUID.toString());
                            if (onlineUser == null) continue;
                            onlineUser.refreshFromServerOnJoinPlayTime();
                        }
                        for (OfflinePlayer offlinePlayer : Bukkit.getOfflinePlayers()) {
                            if (!offlinePlayer.hasPlayedBefore()) continue;
                            UUID playerUUID = offlinePlayer.getUniqueId();
                            try {
                                if (!processedPlayerUUIDs.contains(playerUUID)) {
                                    totalPlayersReset.getAndIncrement();
                                    processedPlayerUUIDs.add(playerUUID);
                                }
                                long currentPlaytime = offlinePlayer.getStatistic(Statistic.PLAY_ONE_MINUTE);
                                totalPlaytimeReset.addAndGet(currentPlaytime);
                                offlinePlayer.setStatistic(Statistic.PLAY_ONE_MINUTE, 0);
                            }
                            catch (Exception e) {
                                this.plugin.getLogger().warning("Failed to reset statistics for offline player: " + offlinePlayer.getName());
                            }
                        }
                        statsFuture.complete(null);
                    });
                    return statsFuture;
                });
            }
            if (resetType.equals("db") || resetType.equals("all")) {
                resetFuture = ((CompletableFuture)resetFuture).thenCompose(v -> {
                    CompletableFuture dbFuture = new CompletableFuture();
                    Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                        for (DBUser u : users) {
                            UUID playerUUID = UUID.fromString(u.getUuid());
                            if (!processedPlayerUUIDs.contains(playerUUID)) {
                                totalPlayersReset.getAndIncrement();
                                processedPlayerUUIDs.add(playerUUID);
                            }
                            totalPlaytimeReset.addAndGet(u.getPlaytime());
                            u.reset();
                        }
                        dbFuture.complete(null);
                    });
                    return dbFuture;
                });
            }
            ((CompletableFuture)((CompletableFuture)resetFuture).thenCompose(v -> {
                CompletableFuture updateFuture = new CompletableFuture();
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                    for (OnlineUser user : this.onlineUsersManager.getOnlineUsersByUUID().values()) {
                        try {
                            user.updateDB();
                        }
                        catch (Exception e) {
                            this.plugin.getLogger().severe(String.format("Failed to update playtime for user %s: %s", user.getNickname(), e.getMessage()));
                        }
                    }
                    this.dbUsersManager.clearCache();
                    Map<String, String> dbTopPlayers = this.plugin.getDatabase().getTopPlayersByPlaytime(100);
                    Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                        List<DBUser> topPlayers;
                        List<DBUser> list = topPlayers = this.dbUsersManager.getTopPlayers();
                        synchronized (list) {
                            topPlayers.clear();
                            for (Map.Entry entry : dbTopPlayers.entrySet()) {
                                DBUser user = this.dbUsersManager.getUserFromUUID((String)entry.getKey());
                                if (user == null) continue;
                                topPlayers.add(user);
                            }
                        }
                        updateFuture.complete(null);
                    });
                });
                return updateFuture;
            })).thenRun(() -> {
                this.dbUsersManager.updateTopPlayersFromDB();
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> sender.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getPluginPrefix() + " All players' " + this.getResetTypeDescription(resetType) + " have been reset! Total: &e" + String.valueOf(totalPlayersReset) + "&7 players with &e" + Utils.ticksToFormattedPlaytime(totalPlaytimeReset.get()) + "&7 of playtime")));
            });
        });
    }

    private void resetSinglePlayer(CommandSender sender, String playerName, String resetType) {
        DBUser user = this.dbUsersManager.getUserFromNickname(playerName);
        if (user == null) {
            sender.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getPluginPrefix() + " The player &e" + playerName + "&7 has never joined the server!"));
            return;
        }
        long playtimeBeforeReset = user.getPlaytime();
        AtomicLong totalPlaytimeReset = new AtomicLong(0L);
        CompletionStage<Object> resetFuture = CompletableFuture.completedFuture(null);
        if (resetType.equals("stats") || resetType.equals("all")) {
            resetFuture = ((CompletableFuture)resetFuture).thenCompose(v -> {
                CompletableFuture statsFuture = new CompletableFuture();
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                    if (user instanceof OnlineUser) {
                        Player p = Bukkit.getPlayerExact((String)playerName);
                        if (p != null) {
                            totalPlaytimeReset.addAndGet(p.getStatistic(Statistic.PLAY_ONE_MINUTE));
                            p.setStatistic(Statistic.PLAY_ONE_MINUTE, 0);
                            ((OnlineUser)user).refreshFromServerOnJoinPlayTime();
                        }
                    } else {
                        OfflinePlayer p = Bukkit.getOfflinePlayer((String)playerName);
                        if (p.hasPlayedBefore()) {
                            try {
                                totalPlaytimeReset.addAndGet(p.getStatistic(Statistic.PLAY_ONE_MINUTE));
                                p.setStatistic(Statistic.PLAY_ONE_MINUTE, 0);
                            }
                            catch (Exception e) {
                                this.plugin.getLogger().warning("Failed to reset statistics for offline player: " + playerName);
                            }
                        }
                    }
                    statsFuture.complete(null);
                });
                return statsFuture;
            });
        }
        if (resetType.equals("db") || resetType.equals("all")) {
            resetFuture = ((CompletableFuture)resetFuture).thenCompose(v -> {
                CompletableFuture dbFuture = new CompletableFuture();
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                    totalPlaytimeReset.addAndGet(playtimeBeforeReset);
                    user.reset();
                    dbFuture.complete(null);
                });
                return dbFuture;
            });
        }
        ((CompletableFuture)resetFuture).thenRun(() -> Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            if (user instanceof OnlineUser) {
                try {
                    ((OnlineUser)user).updateDB();
                }
                catch (Exception e) {
                    this.plugin.getLogger().severe(String.format("Failed to update playtime for user %s: %s", user.getNickname(), e.getMessage()));
                }
            }
            this.dbUsersManager.updateTopPlayersFromDB();
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> sender.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getPluginPrefix() + " Reset " + this.getResetTypeDescription(resetType) + " for player &e" + playerName + "&7 (Removed &e" + Utils.ticksToFormattedPlaytime(totalPlaytimeReset.get()) + "&7 of playtime)")));
        }));
    }

    private String getResetTypeDescription(String resetType) {
        switch (resetType) {
            case "db": {
                return "database records";
            }
            case "stats": {
                return "in-game statistics";
            }
        }
        return "database records and in-game statistics";
    }

    public static void cleanupExpiredConfirmations() {
        pendingResets.entrySet().removeIf(entry -> ((PendingReset)entry.getValue()).isExpired());
    }

    private static class PendingReset {
        final String resetType;
        final long timestamp;

        PendingReset(String resetType) {
            this.resetType = resetType;
            this.timestamp = System.currentTimeMillis();
        }

        boolean isExpired() {
            return System.currentTimeMillis() - this.timestamp > TimeUnit.SECONDS.toMillis(60L);
        }
    }
}

