/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.Commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.thegabro.playtimemanager.GUIs.AllGoalsGui;
import me.thegabro.playtimemanager.Goals.Goal;
import me.thegabro.playtimemanager.Goals.GoalsManager;
import me.thegabro.playtimemanager.PlayTimeManager;
import me.thegabro.playtimemanager.Users.OnlineUsersManager;
import me.thegabro.playtimemanager.Utils;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;

public class PlaytimeGoal
implements TabExecutor {
    private final PlayTimeManager plugin = PlayTimeManager.getInstance();
    private final String[] SUBCOMMANDS = new String[]{"set", "remove", "rename"};
    private final String[] SUBSUBCOMMANDS = new String[]{"time:", "activate:"};
    private final GoalsManager goalsManager = GoalsManager.getInstance();
    private final OnlineUsersManager onlineUsersManager = OnlineUsersManager.getInstance();

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String s, @NotNull String[] args) {
        String subCommand;
        if (!sender.hasPermission("playtime.goal")) {
            sender.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getPluginPrefix() + " You don't have the permission to execute this command"));
            return false;
        }
        if (args.length == 0) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getPluginPrefix() + " Only players can use the GUI!"));
                return false;
            }
            AllGoalsGui gui = new AllGoalsGui();
            gui.openInventory((Player)sender);
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "set": {
                if (args.length < 2) {
                    sender.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getPluginPrefix() + " Usage: /playtimegoal set <goalName> [time:<time>] [activate:true|false]"));
                    return false;
                }
                String goalName = args[1];
                String time = null;
                boolean activate = false;
                for (int i = 2; i < args.length; ++i) {
                    if (args[i].startsWith("time:")) {
                        time = args[i].substring(5);
                        if (time.isEmpty()) {
                            sender.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getPluginPrefix() + " Missing time value!"));
                            return false;
                        }
                        long timeToTicks = Utils.formattedPlaytimeToTicks(time);
                        if (timeToTicks != -1L) continue;
                        sender.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getPluginPrefix() + " Invalid time format!"));
                        return false;
                    }
                    if (args[i].startsWith("activate:")) {
                        String activateValue = args[i].substring(9).toLowerCase();
                        if (activateValue.equals("true")) {
                            activate = true;
                            continue;
                        }
                        if (activateValue.equals("false")) continue;
                        sender.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getPluginPrefix() + " Invalid activate value! Use true or false"));
                        return false;
                    }
                    sender.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getPluginPrefix() + " Invalid argument: " + args[i]));
                    return false;
                }
                this.setGoal(sender, goalName, time != null ? Long.valueOf(Utils.formattedPlaytimeToTicks(time)) : null, activate);
                break;
            }
            case "remove": {
                if (args.length < 2) {
                    sender.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getPluginPrefix() + " Usage: /playtimegoal remove <goalName>"));
                    return false;
                }
                String goalName = args[1];
                this.removeGoal(sender, goalName);
                break;
            }
            case "rename": {
                if (args.length != 3) {
                    sender.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getPluginPrefix() + " Usage: /playtimegoal rename <oldName> <newName>"));
                    return false;
                }
                String oldName = args[1];
                String newName = args[2];
                this.renameGoal(sender, oldName, newName);
                break;
            }
            default: {
                sender.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getPluginPrefix() + " Subcommand " + subCommand + " is not valid."));
                return false;
            }
        }
        return true;
    }

    private void renameGoal(CommandSender sender, String oldName, String newName) {
        Goal oldGoal = this.goalsManager.getGoal(oldName);
        if (oldGoal == null) {
            sender.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getPluginPrefix() + " The goal &e" + oldName + " &7doesn't exist!"));
            return;
        }
        if (this.goalsManager.getGoal(newName) != null) {
            sender.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getPluginPrefix() + " A goal with the name &e" + newName + " &7already exists!"));
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            oldGoal.rename(newName);
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> sender.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getPluginPrefix() + " Successfully renamed goal &e" + oldName + " &7to &e" + newName)));
        });
    }

    private void setGoal(CommandSender sender, String goalName, Long time, boolean activate) {
        Goal g = this.goalsManager.getGoal(goalName);
        StringBuilder message = new StringBuilder();
        if (g != null) {
            message.append(this.plugin.getConfiguration().getPluginPrefix()).append(" Goal &e").append(goalName).append(" &7updated:\n");
            if (time != null) {
                g.setTime(time);
            }
        } else {
            g = new Goal(this.plugin, goalName, time, activate);
            message.append(this.plugin.getConfiguration().getPluginPrefix()).append(" Goal &e").append(goalName).append(" &7created:\n");
        }
        g.setActivation(activate);
        long gTime = g.getTime();
        if (gTime == Long.MAX_VALUE) {
            message.append("&7- Required time to reach the goal: &6None\n");
        } else {
            message.append("&7- Required time to reach the goal: &6").append(Utils.ticksToFormattedPlaytime(gTime)).append("\n");
        }
        message.append("&7- Active: ").append(activate ? "&a" : "&c").append(activate).append("\n");
        sender.sendMessage(Utils.parseColors(message.toString()));
        this.onlineUsersManager.startGoalCheckSchedule();
    }

    private void removeGoal(CommandSender sender, String goalName) {
        Goal goal = this.goalsManager.getGoal(goalName);
        if (goal == null) {
            sender.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getPluginPrefix() + " The goal &e" + goalName + " &7doesn't exist!"));
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            goal.kill();
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                this.onlineUsersManager.startGoalCheckSchedule();
                sender.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getPluginPrefix() + " The goal &e" + goalName + " &7has been removed!"));
            });
        });
    }

    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            StringUtil.copyPartialMatches((String)args[0], Arrays.asList(this.SUBCOMMANDS), completions);
            return completions;
        }
        if (args.length == 2) {
            if (args[0].equalsIgnoreCase("set")) {
                StringUtil.copyPartialMatches((String)args[1], this.goalsManager.getGoalsNames(), completions);
            } else if (args[0].equalsIgnoreCase("remove") || args[0].equalsIgnoreCase("rename")) {
                StringUtil.copyPartialMatches((String)args[1], this.goalsManager.getGoalsNames(), completions);
            }
            return completions;
        }
        if (args.length >= 3 && args[0].equalsIgnoreCase("set")) {
            ArrayList<String> availableSubSubCommands = new ArrayList<String>(Arrays.asList(this.SUBSUBCOMMANDS));
            for (int i = 2; i < args.length - 1; ++i) {
                for (String subSubCmd : this.SUBSUBCOMMANDS) {
                    if (!args[i].startsWith(subSubCmd)) continue;
                    availableSubSubCommands.remove(subSubCmd);
                }
            }
            StringUtil.copyPartialMatches((String)args[args.length - 1], availableSubSubCommands, completions);
            return completions;
        }
        return null;
    }
}

