/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.Commands;

import java.util.Objects;
import me.thegabro.playtimemanager.Goals.GoalsManager;
import me.thegabro.playtimemanager.PlayTimeManager;
import me.thegabro.playtimemanager.Users.DBUsersManager;
import me.thegabro.playtimemanager.Users.OnlineUser;
import me.thegabro.playtimemanager.Users.OnlineUsersManager;
import me.thegabro.playtimemanager.Utils;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class PlaytimeReload
implements CommandExecutor {
    private final GoalsManager goalsManager = GoalsManager.getInstance();
    private final PlayTimeManager plugin = PlayTimeManager.getInstance();
    private final DBUsersManager dbUsersManager = DBUsersManager.getInstance();
    private final OnlineUsersManager onlineUsersManager = OnlineUsersManager.getInstance();

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String s, @NotNull String[] args) {
        if (sender.hasPermission("playtime.reload")) {
            this.plugin.getConfiguration().reload();
            sender.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getPluginPrefix() + " The configuration file has been reloaded"));
            this.goalsManager.clearGoals();
            this.goalsManager.loadGoals();
            for (Player p : Bukkit.getOnlinePlayers()) {
                OnlineUser user = this.onlineUsersManager.getOnlineUser(Objects.requireNonNull(p.getPlayer()).getName());
                if (user == null) continue;
                user.updateDB();
                this.onlineUsersManager.removeOnlineUser(user);
            }
            this.onlineUsersManager.loadOnlineUsers();
            this.onlineUsersManager.startGoalCheckSchedule();
            sender.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getPluginPrefix() + " Goal check schedule has been restarted"));
            this.dbUsersManager.updateTopPlayersFromDB();
            return true;
        }
        sender.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getPluginPrefix() + " You don't have the permission to execute this command"));
        return false;
    }
}

