/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.Commands;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;
import me.thegabro.playtimemanager.ExternalPluginSupport.LuckPermsManager;
import me.thegabro.playtimemanager.PlayTimeManager;
import me.thegabro.playtimemanager.Users.DBUser;
import me.thegabro.playtimemanager.Users.DBUsersManager;
import me.thegabro.playtimemanager.Users.OnlineUsersManager;
import me.thegabro.playtimemanager.Utils;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlaytimeTop
implements TabExecutor {
    private final PlayTimeManager plugin = PlayTimeManager.getInstance();
    private final DBUsersManager dbUsersManager = DBUsersManager.getInstance();
    private final OnlineUsersManager onlineUsersManager = OnlineUsersManager.getInstance();
    private LuckPermsManager luckPermsManager = null;
    private final int TOP_MAX = 100;
    private final Pattern pagePattern = Pattern.compile("p\\d+");
    private int page;

    public PlaytimeTop() {
        if (this.plugin.isPermissionsManagerConfigured()) {
            try {
                this.luckPermsManager = LuckPermsManager.getInstance(this.plugin);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String s, @NotNull String[] args) {
        if (!sender.hasPermission("playtime.top")) {
            sender.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getPluginPrefix() + " You don't have the permission to execute this command"));
            return false;
        }
        if (args.length > 0) {
            if (!this.pagePattern.matcher(args[0]).matches()) {
                sender.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getPluginPrefix() + " The argument is not valid! Use p1, p2, etc."));
                return false;
            }
            if (!this.getPages().contains(args[0])) {
                sender.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getPluginPrefix() + " Page " + args[0].substring(1) + " doesn't exist!"));
                return false;
            }
            this.page = Integer.parseInt(args[0].substring(1));
        } else {
            this.page = 1;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                this.onlineUsersManager.updateAllOnlineUsersPlaytime().get();
                List<DBUser> topPlayers = this.dbUsersManager.getTopPlayers();
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                    if (topPlayers.isEmpty()) {
                        sender.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getPluginPrefix() + " No players joined!"));
                        return;
                    }
                    int totalUsers = Math.min(100, topPlayers.size());
                    int totalPages = (int)Math.ceil(Float.parseFloat(String.valueOf(totalUsers)) / 10.0f);
                    if (this.page <= 0 || this.page > totalPages) {
                        sender.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getPluginPrefix() + " Invalid page!"));
                        return;
                    }
                    sender.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getPluginPrefix() + " Top " + totalUsers + " players - page: " + this.page));
                    int startIndex = (this.page - 1) * 10;
                    int endIndex = Math.min(this.page * 10, totalUsers);
                    CompletableFuture[] messageFutures = new CompletableFuture[endIndex - startIndex];
                    String format = this.plugin.getConfiguration().getPlaytimetopLeaderboardFormat();
                    boolean usePrefixes = this.plugin.getConfiguration().getPlaytimetopLeaderboardFormat().contains("%PREFIX%") && this.plugin.isPermissionsManagerConfigured();
                    for (int i = startIndex; i < endIndex; ++i) {
                        int rank = i + 1;
                        int arrayIndex = i - startIndex;
                        DBUser user = (DBUser)topPlayers.get(i);
                        if (usePrefixes) {
                            messageFutures[arrayIndex] = this.luckPermsManager.getPrefixAsync(user.getUuid()).thenApply(prefix -> {
                                String formattedMessage = format.replace("%POSITION%", String.valueOf(rank)).replace("%PREFIX%", prefix != null ? prefix : "").replace("%PLAYER_NAME%", user.getNickname()).replace("%PLAYTIME%", Utils.ticksToFormattedPlaytime(user.getPlaytime()));
                                formattedMessage = formattedMessage.replaceAll("\\s+", " ");
                                return Component.empty().append(Utils.parseColors(formattedMessage));
                            });
                            continue;
                        }
                        String formattedMessage = format.replace("%POSITION%", String.valueOf(rank)).replace("%PREFIX%", "").replace("%PLAYER_NAME%", user.getNickname()).replace("%PLAYTIME%", Utils.ticksToFormattedPlaytime(user.getPlaytime())).replaceAll("\\s+", " ");
                        messageFutures[arrayIndex] = CompletableFuture.completedFuture(Component.empty().append(Utils.parseColors(formattedMessage)));
                    }
                    CompletableFuture.allOf(messageFutures).thenRun(() -> {
                        for (CompletableFuture future : messageFutures) {
                            sender.sendMessage((Component)future.join());
                        }
                        TextComponent navigationMessage = Component.empty();
                        if (this.page > 1) {
                            Component previousArrow = Utils.parseColors("&6\u00ab").clickEvent(ClickEvent.runCommand((String)("/playtimetop p" + (this.page - 1)))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Utils.parseColors("&7Click to go to previous page")));
                            navigationMessage = navigationMessage.append(previousArrow);
                        } else {
                            navigationMessage = navigationMessage.append(Utils.parseColors("&7\u00ab"));
                        }
                        navigationMessage = navigationMessage.append(Utils.parseColors(" &7Page " + this.page + "/" + totalPages + " "));
                        if (this.page < totalPages) {
                            Component nextArrow = Utils.parseColors("&6\u00bb").clickEvent(ClickEvent.runCommand((String)("/playtimetop p" + (this.page + 1)))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Utils.parseColors("&7Click to go to next page")));
                            navigationMessage = navigationMessage.append(nextArrow);
                        } else {
                            navigationMessage = navigationMessage.append(Utils.parseColors("&7\u00bb"));
                        }
                        sender.sendMessage((Component)navigationMessage);
                    });
                });
            }
            catch (InterruptedException | ExecutionException e) {
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> sender.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getPluginPrefix() + " Error while loading top players: " + e.getMessage())));
                this.plugin.getLogger().severe("Error in PlaytimeTop command: " + e.getMessage());
            }
        });
        return true;
    }

    public List<String> getPages() {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while ((double)i < Math.ceil(Float.parseFloat(String.valueOf(100)) / 10.0f)) {
            result.add("p" + (i + 1));
            ++i;
        }
        return result;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, @NotNull String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length > 0) {
            List<String> pages = this.getPages();
            StringUtil.copyPartialMatches((String)args[0], pages, completions);
            return completions;
        }
        return null;
    }
}

