/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager;

import java.io.File;
import java.text.SimpleDateFormat;
import me.thegabro.playtimemanager.PlayTimeManager;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class Configuration {
    private final boolean createIfNotExist;
    private final boolean resource;
    private final PlayTimeManager plugin = PlayTimeManager.getInstance();
    private FileConfiguration config;
    private File file;
    private final File path;
    private final String name;
    private long goalsCheckRate;
    private boolean goalsCheckVerbose;
    private String playtimeSelfMessage;
    private String playtimeOthersMessage;
    private String permissionsManagerPlugin;
    private String datetimeFormat;
    private String playtimetopLeaderboardFormat;
    private boolean placeholdersEnableErrors;
    private String placeholdersDefaultMessage;
    private String pluginChatPrefix;

    public Configuration(File path, String name, boolean createIfNotExist, boolean resource) {
        this.path = path;
        this.name = name + ".yml";
        this.createIfNotExist = createIfNotExist;
        this.resource = resource;
        this.create();
        this.reload();
    }

    private void save() {
        try {
            this.config.save(this.file);
        }
        catch (Exception exc) {
            this.plugin.getLogger().severe(String.valueOf(exc));
        }
    }

    private void reloadFile() {
        this.file = new File(this.path, this.name);
    }

    private void reloadConfig() {
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
    }

    public void reload() {
        this.reloadFile();
        this.reloadConfig();
        this.updateGoalsSettings();
        this.updateMessages();
        this.updatePermissionsSettings();
        this.updateDateTimeSettings();
        this.updatePrefixesSettings();
        this.updatePlaceholdersSettings();
        this.updatePlaytimetopSettings();
    }

    private void create() {
        if (this.file == null) {
            this.reloadFile();
        }
        if (!this.createIfNotExist || this.file.exists()) {
            return;
        }
        this.file.getParentFile().mkdirs();
        if (this.resource) {
            this.plugin.saveResource(this.name, false);
        } else {
            try {
                this.file.createNewFile();
            }
            catch (Exception exc) {
                this.plugin.getLogger().severe(String.valueOf(exc));
            }
        }
    }

    private void updateMessages() {
        this.playtimeSelfMessage = this.config.getString("playtime-self-message");
        this.playtimeOthersMessage = this.config.getString("playtime-others-message");
    }

    private void updateGoalsSettings() {
        this.goalsCheckRate = this.config.getLong("goal-check-rate");
        this.goalsCheckVerbose = this.config.getBoolean("goal-check-verbose");
    }

    private void updatePermissionsSettings() {
        this.permissionsManagerPlugin = this.config.getString("permissions-manager-plugin", "luckperms");
    }

    private void updatePlaceholdersSettings() {
        this.placeholdersEnableErrors = this.config.getBoolean("placeholders.enable-errors", false);
        this.placeholdersDefaultMessage = this.config.getString("placeholders.default-message", "No data");
    }

    public String getPluginPrefix() {
        return this.pluginChatPrefix;
    }

    public void setPluginChatPrefix(String prefix) {
        this.pluginChatPrefix = prefix;
        this.config.set("prefix", (Object)prefix);
        this.save();
    }

    private void updatePrefixesSettings() {
        this.pluginChatPrefix = this.config.getString("prefix", "[\u00a76PlayTime\u00a7eManager\u00a7f]\u00a77");
    }

    private void updatePlaytimetopSettings() {
        this.playtimetopLeaderboardFormat = this.config.getString("playtimetop.leaderboard-format", "&7&l#%POSITION%&r %PREFIX% &e%PLAYER_NAME% &7- &d%PLAYTIME%");
    }

    public String getPlaytimetopLeaderboardFormat() {
        return this.playtimetopLeaderboardFormat;
    }

    public void setPlaytimetopLeaderboardFormat(String format) {
        if (format != null) {
            this.playtimetopLeaderboardFormat = format;
            this.config.set("playtimetop.leaderboard-format", (Object)format);
            this.save();
        }
    }

    public boolean isPlaceholdersEnableErrors() {
        return this.placeholdersEnableErrors;
    }

    public void setPlaceholdersEnableErrors(boolean enableErrors) {
        this.placeholdersEnableErrors = enableErrors;
        this.config.set("placeholders.enable-errors", (Object)enableErrors);
        this.save();
    }

    public String getPlaceholdersDefaultMessage() {
        return this.placeholdersDefaultMessage;
    }

    public void setPlaceholdersDefaultMessage(String message) {
        this.placeholdersDefaultMessage = message;
        this.config.set("placeholders.default-message", (Object)message);
        this.save();
    }

    public long getGoalsCheckRate() {
        return this.goalsCheckRate;
    }

    private void updateDateTimeSettings() {
        String configFormat = this.config.getString("datetime-format");
        try {
            new SimpleDateFormat(configFormat);
            this.datetimeFormat = configFormat;
        }
        catch (IllegalArgumentException e) {
            this.datetimeFormat = "MMM dd, yyyy HH:mm:ss";
            this.config.set("datetime-format", (Object)this.datetimeFormat);
            this.save();
            this.plugin.getLogger().warning("Invalid datetime format in config. Resetting to default: " + this.datetimeFormat);
        }
    }

    public String getDateTimeFormat() {
        return this.datetimeFormat;
    }

    public void setDateTimeFormat(String format) {
        this.datetimeFormat = format;
        this.config.set("datetime-format", (Object)format);
        this.save();
    }

    public void setGoalsCheckVerbose(Boolean verbose) {
        if (verbose != null) {
            this.config.set("goal-check-verbose", (Object)verbose);
            this.save();
        }
    }

    public void setGoalsCheckRate(Long rate) {
        if (rate != null) {
            this.config.set("goal-check-rate", (Object)rate);
            this.save();
        }
    }

    public boolean getGoalsCheckVerbose() {
        return this.goalsCheckVerbose;
    }

    public String getPermissionsManagerPlugin() {
        return this.permissionsManagerPlugin;
    }

    public void setPermissionsManagerPlugin(String plugin) {
        if (plugin != null) {
            this.config.set("permissions-manager-plugin", (Object)plugin.toLowerCase());
            this.save();
        }
    }

    public String getPlaytimeSelfMessage() {
        return this.playtimeSelfMessage;
    }

    public void setPlaytimeSelfMessage(String message) {
        if (message != null) {
            this.config.set("playtime-self-message", (Object)message);
            this.save();
        }
    }

    public String getPlaytimeOthersMessage() {
        return this.playtimeOthersMessage;
    }

    public void setPlaytimeOthersMessage(String message) {
        if (message != null) {
            this.config.set("playtime-others-message", (Object)message);
            this.save();
        }
    }
}

