/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.Events;

import io.papermc.paper.event.player.AsyncChatEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import me.thegabro.playtimemanager.PlayTimeManager;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.plugin.Plugin;

public class ChatEventManager
implements Listener {
    private final Map<UUID, ChatInputSession> activeSessions = new HashMap<UUID, ChatInputSession>();
    private final PlayTimeManager plugin = PlayTimeManager.getInstance();

    public ChatEventManager() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    public void startChatInput(Player player, String prompt, BiConsumer<Player, String> callback) {
        UUID playerId = player.getUniqueId();
        this.activeSessions.put(playerId, new ChatInputSession(callback));
        player.sendMessage((Component)Component.text((String)prompt));
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerCommand(PlayerCommandPreprocessEvent event) {
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        ChatInputSession session = this.activeSessions.get(playerId);
        if (session == null) {
            return;
        }
        event.setCancelled(true);
        String command = event.getMessage();
        if (!command.startsWith("/")) {
            player.sendMessage((Component)Component.text((String)"\u00a7cPlease enter a valid command starting with '/' or type 'cancel' to exit"));
            return;
        }
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.handleChatMessage(player, command, session));
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerChat(AsyncChatEvent event) {
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        ChatInputSession session = this.activeSessions.get(playerId);
        if (session == null) {
            return;
        }
        event.setCancelled(true);
        String message = PlainTextComponentSerializer.plainText().serialize(event.message());
        if (!message.equalsIgnoreCase("cancel")) {
            player.sendMessage((Component)Component.text((String)"\u00a7cPlease enter a valid command starting with '/' or type 'cancel' to exit"));
            return;
        }
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            this.activeSessions.remove(player.getUniqueId());
            session.callback().accept(player, message);
        });
    }

    private void handleChatMessage(Player player, String message, ChatInputSession session) {
        UUID playerId = player.getUniqueId();
        session.callback().accept(player, message);
        this.activeSessions.remove(playerId);
    }

    private record ChatInputSession(BiConsumer<Player, String> callback) {
    }
}

