/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.ExternalPluginSupport;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import me.thegabro.playtimemanager.Goals.Goal;
import me.thegabro.playtimemanager.PlayTimeManager;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.model.group.Group;
import net.luckperms.api.model.user.User;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.ScopedNode;
import net.luckperms.api.node.types.InheritanceNode;

public class LuckPermsManager {
    private final PlayTimeManager plugin;
    private static LuckPerms luckPermsApi;
    private static LuckPermsManager instance;

    private LuckPermsManager(PlayTimeManager plugin) {
        this.plugin = plugin;
    }

    public static LuckPermsManager getInstance(PlayTimeManager plugin) {
        if (instance == null) {
            luckPermsApi = LuckPermsProvider.get();
            instance = new LuckPermsManager(plugin);
        }
        return instance;
    }

    public LuckPerms getLuckPermsApi() {
        return luckPermsApi;
    }

    public CompletableFuture<String> getPrefixAsync(String uuid) {
        try {
            return ((CompletableFuture)luckPermsApi.getUserManager().loadUser(UUID.fromString(uuid)).thenApplyAsync(user -> {
                String prefix = user.getCachedData().getMetaData().getPrefix();
                return prefix != null ? prefix : "";
            })).exceptionally(throwable -> "");
        }
        catch (Exception e) {
            return CompletableFuture.completedFuture("");
        }
    }

    public void assignPermission(String uuid, String permission) {
        try {
            User user = luckPermsApi.getUserManager().getUser(UUID.fromString(uuid));
            if (user == null) {
                return;
            }
            if (permission.startsWith("group.")) {
                this.assignGroup(user, permission.substring(6));
            } else {
                this.assignDirectPermission(user, permission);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Failed to assign permission " + permission + " to UUID " + uuid + ": " + e.getMessage());
        }
    }

    private void assignGroup(User user, String groupName) {
        Group group = luckPermsApi.getGroupManager().getGroup(groupName);
        if (group == null) {
            return;
        }
        InheritanceNode node = (InheritanceNode)((InheritanceNode.Builder)InheritanceNode.builder((Group)group).value(true)).build();
        user.data().add((Node)node);
        luckPermsApi.getUserManager().saveUser(user);
    }

    private void assignDirectPermission(User user, String permission) {
        ScopedNode permissionNode = Node.builder((String)permission).value(true).build();
        user.data().add((Node)permissionNode);
        luckPermsApi.getUserManager().saveUser(user);
    }

    public void assignGoalPermissions(String uuid, Goal goal) {
        if (goal.getPermissions() == null || goal.getPermissions().isEmpty()) {
            return;
        }
        for (String permission : goal.getPermissions()) {
            this.assignPermission(uuid, permission);
        }
    }

    public boolean hasPermission(String uuid, String permission) {
        User user = luckPermsApi.getUserManager().getUser(UUID.fromString(uuid));
        if (user == null) {
            return false;
        }
        return user.getCachedData().getPermissionData().checkPermission(permission).asBoolean();
    }

    public boolean isInGroup(String uuid, String groupName) {
        User user = luckPermsApi.getUserManager().getUser(UUID.fromString(uuid));
        if (user == null) {
            return false;
        }
        return user.getCachedData().getPermissionData().checkPermission("group." + groupName).asBoolean();
    }

    public boolean groupExists(String groupName) {
        try {
            return luckPermsApi.getGroupManager().getGroup(groupName) != null;
        }
        catch (Exception e) {
            return false;
        }
    }
}

