/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.ExternalPluginSupport;

import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.ExecutionException;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import me.thegabro.playtimemanager.ExternalPluginSupport.LuckPermsManager;
import me.thegabro.playtimemanager.PlayTimeManager;
import me.thegabro.playtimemanager.Users.DBUser;
import me.thegabro.playtimemanager.Users.DBUsersManager;
import me.thegabro.playtimemanager.Users.OnlineUsersManager;
import me.thegabro.playtimemanager.Utils;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;

public class PlayTimePlaceHolders
extends PlaceholderExpansion {
    private static final String[] TIME_UNITS = new String[]{"s", "m", "h", "d", "y"};
    private final PlayTimeManager plugin = PlayTimeManager.getInstance();
    private final DBUsersManager dbUsersManager = DBUsersManager.getInstance();
    private final OnlineUsersManager onlineUsersManager = OnlineUsersManager.getInstance();
    private LuckPermsManager luckPermsManager = null;

    public PlayTimePlaceHolders() {
        if (this.plugin.isPermissionsManagerConfigured()) {
            try {
                this.luckPermsManager = LuckPermsManager.getInstance(this.plugin);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
    }

    @NotNull
    public String getIdentifier() {
        return "PTM";
    }

    @NotNull
    public String getAuthor() {
        return "TheGabro";
    }

    @NotNull
    public String getVersion() {
        return "3.2.0";
    }

    public boolean persist() {
        return true;
    }

    public String onRequest(OfflinePlayer player, String params) {
        String prefix;
        if (params == null) {
            return null;
        }
        if (params.equalsIgnoreCase("playtime")) {
            try {
                return Utils.ticksToFormattedPlaytime(this.onlineUsersManager.getOnlineUser(player.getName()).getPlaytime());
            }
            catch (Exception e) {
                return this.getErrorMessage("couldn't get playtime");
            }
        }
        for (String unit : TIME_UNITS) {
            if (!params.equalsIgnoreCase("playtime_" + unit)) continue;
            try {
                return String.valueOf(Utils.ticksToTimeUnit(this.onlineUsersManager.getOnlineUser(player.getName()).getPlaytime(), unit));
            }
            catch (Exception e) {
                return this.getErrorMessage("couldn't get playtime");
            }
        }
        String paramLower = params.toLowerCase();
        if (paramLower.startsWith("lp_prefix_top_")) {
            return this.handleLPPrefixTop(params.substring(14));
        }
        for (String unit : TIME_UNITS) {
            prefix = "lastseen_elapsed_top_" + unit.toLowerCase() + "_";
            if (!paramLower.startsWith(prefix)) continue;
            return this.handleLastSeenElapsedTop(params.substring(prefix.length()), unit);
        }
        if (paramLower.startsWith("lastseen_elapsed_top_")) {
            return this.handleLastSeenElapsedTop(params.substring(21));
        }
        for (String unit : TIME_UNITS) {
            prefix = "lastseen_elapsed_" + unit.toLowerCase() + "_";
            if (!paramLower.startsWith(prefix)) continue;
            return this.handleLastSeenElapsed(params.substring(prefix.length()), unit);
        }
        if (paramLower.startsWith("lastseen_elapsed_")) {
            return this.handleLastSeenElapsed(params.substring(17));
        }
        if (paramLower.startsWith("nickname_top_")) {
            return this.handleNicknameTop(params.substring(13));
        }
        for (String unit : TIME_UNITS) {
            prefix = "playtime_top_" + unit.toLowerCase() + "_";
            if (!paramLower.startsWith(prefix)) continue;
            return this.handlePlayTimeTop(params.substring(prefix.length()), unit);
        }
        if (paramLower.startsWith("playtime_top_")) {
            return this.handlePlayTimeTop(params.substring(13));
        }
        for (String unit : TIME_UNITS) {
            prefix = "playtime_" + unit.toLowerCase() + "_";
            if (!paramLower.startsWith(prefix)) continue;
            return this.handlePlayTime(params.substring(prefix.length()), unit);
        }
        if (paramLower.startsWith("playtime_")) {
            return this.handlePlayTime(params.substring(9));
        }
        if (paramLower.startsWith("lastseen_top_")) {
            return this.handleLastSeenTop(params.substring(13));
        }
        if (paramLower.startsWith("lastseen_")) {
            return this.handleLastSeen(params.substring(9));
        }
        return null;
    }

    private String handleLPPrefixTop(String posStr) {
        if (!this.isStringInt(posStr)) {
            return this.getErrorMessage("wrong top position?");
        }
        DBUser user = this.dbUsersManager.getTopPlayerAtPosition(Integer.parseInt(posStr));
        if (user == null) {
            return this.getErrorMessage("wrong top position?");
        }
        if (!this.plugin.isPermissionsManagerConfigured()) {
            return this.getErrorMessage("luckperms not loaded");
        }
        try {
            return this.luckPermsManager.getPrefixAsync(user.getUuid()).get();
        }
        catch (InterruptedException | ExecutionException e) {
            return this.getErrorMessage("luckperms retrieve unsuccessful");
        }
    }

    private String handleLastSeenElapsedTop(String posStr, String unit) {
        if (!this.isStringInt(posStr)) {
            return this.getErrorMessage("wrong top position?");
        }
        DBUser user = this.dbUsersManager.getTopPlayerAtPosition(Integer.parseInt(posStr));
        if (user == null) {
            return this.getErrorMessage("wrong top position?");
        }
        if (user.getLastSeen() == null) {
            return this.getErrorMessage("last seen data missing");
        }
        Duration duration = Duration.between(user.getLastSeen(), LocalDateTime.now());
        return String.valueOf(Utils.ticksToTimeUnit(duration.getSeconds() * 20L, unit));
    }

    private String handleLastSeenElapsedTop(String posStr) {
        if (!this.isStringInt(posStr)) {
            return this.getErrorMessage("wrong top position?");
        }
        DBUser user = this.dbUsersManager.getTopPlayerAtPosition(Integer.parseInt(posStr));
        if (user == null) {
            return this.getErrorMessage("wrong top position?");
        }
        if (user.getLastSeen() == null) {
            return this.getErrorMessage("last seen data missing");
        }
        Duration duration = Duration.between(user.getLastSeen(), LocalDateTime.now());
        return Utils.ticksToFormattedPlaytime(duration.getSeconds() * 20L);
    }

    private String handleLastSeenElapsed(String nickname, String unit) {
        DBUser user = this.dbUsersManager.getUserFromNickname(nickname);
        if (user == null) {
            return this.getErrorMessage("wrong nickname?");
        }
        if (user.getLastSeen() == null) {
            return this.getErrorMessage("last seen data missing");
        }
        Duration duration = Duration.between(user.getLastSeen(), LocalDateTime.now());
        return String.valueOf(Utils.ticksToTimeUnit(duration.getSeconds() * 20L, unit));
    }

    private String handleLastSeenElapsed(String nickname) {
        DBUser user = this.dbUsersManager.getUserFromNickname(nickname);
        if (user == null) {
            return this.getErrorMessage("wrong nickname?");
        }
        if (user.getLastSeen() == null) {
            return this.getErrorMessage("last seen data missing");
        }
        Duration duration = Duration.between(user.getLastSeen(), LocalDateTime.now());
        return Utils.ticksToFormattedPlaytime(duration.getSeconds() * 20L);
    }

    private String handleNicknameTop(String posStr) {
        if (!this.isStringInt(posStr)) {
            return this.getErrorMessage("wrong top position?");
        }
        DBUser user = this.dbUsersManager.getTopPlayerAtPosition(Integer.parseInt(posStr));
        return user != null ? user.getNickname() : this.getErrorMessage("wrong top position?");
    }

    private String handlePlayTimeTop(String posStr, String unit) {
        if (!this.isStringInt(posStr)) {
            return this.getErrorMessage("wrong top position?");
        }
        DBUser user = this.dbUsersManager.getTopPlayerAtPosition(Integer.parseInt(posStr));
        return user != null ? String.valueOf(Utils.ticksToTimeUnit(user.getPlaytime(), unit)) : this.getErrorMessage("wrong top position?");
    }

    private String handlePlayTimeTop(String posStr) {
        if (!this.isStringInt(posStr)) {
            return this.getErrorMessage("wrong top position?");
        }
        DBUser user = this.dbUsersManager.getTopPlayerAtPosition(Integer.parseInt(posStr));
        return user != null ? Utils.ticksToFormattedPlaytime(user.getPlaytime()) : this.getErrorMessage("wrong top position?");
    }

    private String handlePlayTime(String nickname, String unit) {
        DBUser user = this.dbUsersManager.getUserFromNickname(nickname);
        return user != null ? String.valueOf(Utils.ticksToTimeUnit(user.getPlaytime(), unit)) : this.getErrorMessage("wrong nickname?");
    }

    private String handlePlayTime(String nickname) {
        DBUser user = this.dbUsersManager.getUserFromNickname(nickname);
        return user != null ? Utils.ticksToFormattedPlaytime(user.getPlaytime()) : this.getErrorMessage("wrong nickname?");
    }

    private String handleCurrentPlayerPlayTime(OfflinePlayer player) {
        return Utils.ticksToFormattedPlaytime(this.onlineUsersManager.getOnlineUser(player.getName()).getPlaytime());
    }

    private String handleLastSeenTop(String posStr) {
        if (!this.isStringInt(posStr)) {
            return this.getErrorMessage("wrong top position?");
        }
        DBUser user = this.dbUsersManager.getTopPlayerAtPosition(Integer.parseInt(posStr));
        if (user == null) {
            return this.getErrorMessage("wrong top position?");
        }
        if (user.getLastSeen() == null) {
            return this.getErrorMessage("last seen data missing");
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(this.plugin.getConfiguration().getDateTimeFormat());
        return user.getLastSeen().format(formatter);
    }

    private String handleLastSeen(String nickname) {
        DBUser user = this.dbUsersManager.getUserFromNickname(nickname);
        if (user == null) {
            return this.getErrorMessage("wrong nickname?");
        }
        if (user.getLastSeen() == null) {
            return this.getErrorMessage("last seen data missing");
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(this.plugin.getConfiguration().getDateTimeFormat());
        return user.getLastSeen().format(formatter);
    }

    private String getErrorMessage(String error) {
        return this.plugin.getConfiguration().isPlaceholdersEnableErrors() ? "Error: " + error : this.plugin.getConfiguration().getPlaceholdersDefaultMessage();
    }

    private boolean isStringInt(String s) {
        try {
            Integer.parseInt(s);
            return true;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }
}

