/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.GUIs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import me.thegabro.playtimemanager.GUIs.GoalSettingsGui;
import me.thegabro.playtimemanager.Goals.Goal;
import me.thegabro.playtimemanager.Goals.GoalsManager;
import me.thegabro.playtimemanager.PlayTimeManager;
import me.thegabro.playtimemanager.Utils;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AllGoalsGui
implements InventoryHolder,
Listener {
    private final Inventory inv;
    private final ArrayList<Integer> protectedSlots = new ArrayList();
    private final PlayTimeManager plugin = PlayTimeManager.getInstance();
    private final GoalsManager goalsManager = GoalsManager.getInstance();

    public AllGoalsGui() {
        this.inv = Bukkit.createInventory((InventoryHolder)this, (int)54, (Component)Component.text((String)"Goals"));
    }

    public void openInventory(Player p) {
        this.initializeItems();
        p.openInventory(this.inv);
    }

    public void initializeItems() {
        int leftIndex = 9;
        int rightIndex = 17;
        List<Goal> sortedGoals = this.goalsManager.getGoals().stream().sorted(Comparator.comparing(Goal::getName)).toList();
        this.protectedSlots.clear();
        this.inv.clear();
        for (int i = 0; i < 54; ++i) {
            if (i > 9 && i < 45 && i != leftIndex && i != rightIndex) continue;
            this.inv.setItem(i, this.createGuiItem(Material.BLACK_STAINED_GLASS_PANE, Component.text((String)"\u00a7f[\u00a76P.T.M.\u00a7f]\u00a77"), new TextComponent[0]));
            this.protectedSlots.add(i);
            if (i == leftIndex) {
                leftIndex += 9;
            }
            if (i != rightIndex) continue;
            rightIndex += 9;
        }
        if (!sortedGoals.isEmpty()) {
            int slot = 0;
            for (Goal goal : sortedGoals) {
                while (this.protectedSlots.contains(slot)) {
                    ++slot;
                }
                if (slot < 54) {
                    this.inv.setItem(slot, this.createGuiItem(Material.EXPERIENCE_BOTTLE, Component.text((String)("\u00a7e" + goal.getName())), Component.text((String)("\u00a77Required Time: " + Utils.ticksToFormattedPlaytime(goal.getTime()))), (TextComponent)((TextComponent)Component.text((String)"\u00a77Active: ").append(Component.text((String)(goal.isActive() ? "true" : "false")).color(goal.isActive() ? TextColor.color((int)0x55FF55) : TextColor.color((int)0xFF5555)))).decoration(TextDecoration.ITALIC, false), Component.text((String)("\u00a7e" + goal.getPermissions().size() + "\u00a77 " + (goal.getPermissions().size() != 1 ? "permissions loaded" : "permission loaded"))), Component.text((String)("\u00a7e" + goal.getCommands().size() + "\u00a77 " + (goal.getCommands().size() != 1 ? "commands loaded" : "command loaded")))));
                    ++slot;
                    continue;
                }
                break;
            }
        } else {
            this.inv.setItem(22, this.createGuiItem(Material.BARRIER, Component.text((String)"\u00a7l\u00a7cNo goals have been set!"), Component.text((String)"\u00a77Use \u00a7e/playtimegoal set \u00a77to add goals")));
        }
    }

    private ItemStack createGuiItem(Material material, @Nullable TextComponent name, TextComponent ... lore) {
        ItemStack item = new ItemStack(material, 1);
        ItemMeta meta = item.getItemMeta();
        meta.displayName((Component)name);
        ArrayList<TextComponent> metalore = new ArrayList<TextComponent>(Arrays.asList(lore));
        meta.lore(metalore);
        item.setItemMeta(meta);
        return item;
    }

    @NotNull
    public Inventory getInventory() {
        return this.inv;
    }

    public void onGUIClick(Player whoClicked, int slot, ItemStack clickedItem, @NotNull InventoryAction action) {
        String goalName = "";
        if (clickedItem == null || clickedItem.getType().equals((Object)Material.AIR) || clickedItem.getType().equals((Object)Material.BLACK_STAINED_GLASS_PANE)) {
            return;
        }
        if (clickedItem.getType() == Material.BARRIER) {
            whoClicked.closeInventory();
            Component baseMessage = Utils.parseColors(this.plugin.getConfiguration().getPluginPrefix() + "    To create a goal use:\n\n    /playtimegoal set \u00a7e<name> \u00a77time:\u00a7e<time> \u00a77[activate:\u00a7etrue\u00a77|\u00a7efalse\u00a77]\n");
            String command = "/playtimegoal set goal1 time:1d,2h,3m,4s";
            Component preText = Component.text((String)"You can ").color(TextColor.color((int)170, (int)170, (int)170));
            Component clickableText = ((TextComponent)((TextComponent)((TextComponent)Component.text((String)"[click here]").color(TextColor.color((int)255, (int)170, (int)0))).decoration(TextDecoration.BOLD, true)).clickEvent(ClickEvent.suggestCommand((String)command))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click to autocomplete command")));
            Component fullMessage = ((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.empty().append(baseMessage)).append((Component)Component.text((String)"\n"))).append(preText)).append(clickableText)).append(Component.text((String)" to autocomplete the command").color(TextColor.color((int)170, (int)170, (int)170)));
            whoClicked.sendMessage(fullMessage);
            return;
        }
        if (clickedItem.getItemMeta().hasDisplayName()) {
            goalName = PlainTextComponentSerializer.plainText().serialize(clickedItem.getItemMeta().displayName());
            whoClicked.closeInventory();
            GoalSettingsGui settingsGui = new GoalSettingsGui(this.goalsManager.getGoal(goalName.substring(2)), this);
            settingsGui.openInventory(whoClicked);
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent e) {
        if (e.getInventory().getHolder() instanceof AllGoalsGui) {
            if (e.getRawSlot() < e.getInventory().getSize()) {
                e.setCancelled(true);
                AllGoalsGui gui = (AllGoalsGui)e.getInventory().getHolder();
                gui.onGUIClick((Player)e.getWhoClicked(), e.getRawSlot(), e.getCurrentItem(), e.getAction());
            } else if (e.getAction().equals((Object)InventoryAction.MOVE_TO_OTHER_INVENTORY)) {
                e.setCancelled(true);
            }
        }
    }
}

