/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.GUIs;

import java.util.ArrayList;
import me.thegabro.playtimemanager.Events.ChatEventManager;
import me.thegabro.playtimemanager.GUIs.ConfirmationGui;
import me.thegabro.playtimemanager.GUIs.GoalSettingsGui;
import me.thegabro.playtimemanager.Goals.Goal;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class CommandsGui
implements InventoryHolder,
Listener {
    private static final int GUI_SIZE = 54;
    private static final int COMMANDS_PER_PAGE = 45;
    private Inventory inventory;
    private Goal goal;
    private GoalSettingsGui parentGui;
    private int currentPage = 0;
    private ChatEventManager chatHandler;

    public CommandsGui() {
    }

    public CommandsGui(Goal goal, GoalSettingsGui parentGui) {
        this.goal = goal;
        this.parentGui = parentGui;
        this.chatHandler = new ChatEventManager();
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)54, (Component)Component.text((String)"\u00a76Commands Editor"));
    }

    @NotNull
    public Inventory getInventory() {
        return this.inventory;
    }

    public void openInventory(Player player) {
        this.initializeItems();
        player.openInventory(this.inventory);
    }

    private void initializeItems() {
        for (int i = 0; i < 54; ++i) {
            this.inventory.setItem(i, this.createBackgroundItem());
        }
        this.updateCommandsPage();
        this.addControlButtons();
    }

    private ItemStack createBackgroundItem() {
        return this.parentGui.createGuiItem(Material.BLACK_STAINED_GLASS_PANE, Component.text((String)"\u00a7f"), new TextComponent[0]);
    }

    private void updateCommandsPage() {
        int i;
        ArrayList<String> commands = this.goal.getCommands();
        int startIndex = this.currentPage * 45;
        for (i = 0; i < 45; ++i) {
            this.inventory.setItem(i, this.createBackgroundItem());
        }
        for (i = 0; i < 45 && startIndex + i < commands.size(); ++i) {
            String command = (String)commands.get(startIndex + i);
            this.inventory.setItem(i, this.parentGui.createGuiItem(Material.PAPER, Component.text((String)("\u00a7e" + command)), Component.text((String)"\u00a77Click to edit"), Component.text((String)"\u00a7cRight-click to remove")));
        }
        this.addControlButtons();
    }

    private void addControlButtons() {
        if (this.currentPage > 0) {
            this.inventory.setItem(45, this.parentGui.createGuiItem(Material.ARROW, Component.text((String)"\u00a7ePrevious Page"), new TextComponent[0]));
        }
        if ((this.currentPage + 1) * 45 < this.goal.getCommands().size()) {
            this.inventory.setItem(53, this.parentGui.createGuiItem(Material.ARROW, Component.text((String)"\u00a7eNext Page"), new TextComponent[0]));
        }
        this.inventory.setItem(48, this.parentGui.createGuiItem(Material.EMERALD, Component.text((String)"\u00a7a\u00a7lAdd Command"), Component.text((String)"\u00a77Click to add a new command")));
        this.inventory.setItem(49, this.parentGui.createGuiItem(Material.MAGENTA_GLAZED_TERRACOTTA, Component.text((String)"\u00a76\u00a7lBack"), new TextComponent[0]));
        this.inventory.setItem(50, this.parentGui.createGuiItem(Material.BARRIER, Component.text((String)"\u00a7c\u00a7lDelete all"), Component.text((String)"\u00a77Click to discard every command")));
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent e) {
        if (e.getInventory().getHolder() instanceof CommandsGui) {
            if (e.getRawSlot() < e.getInventory().getSize()) {
                e.setCancelled(true);
                CommandsGui gui = (CommandsGui)e.getInventory().getHolder();
                gui.handleGUIClick((Player)e.getWhoClicked(), e.getRawSlot(), e.getCurrentItem(), e.getAction());
            } else if (e.getAction().equals((Object)InventoryAction.MOVE_TO_OTHER_INVENTORY)) {
                e.setCancelled(true);
            }
        }
    }

    private void handleGUIClick(Player whoClicked, int slot, ItemStack clickedItem, InventoryAction action) {
        if (clickedItem == null || clickedItem.getType().equals((Object)Material.AIR) || clickedItem.getType().equals((Object)Material.BLACK_STAINED_GLASS_PANE)) {
            return;
        }
        switch (slot) {
            case 45: {
                if (this.currentPage <= 0) break;
                --this.currentPage;
                this.updateCommandsPage();
                break;
            }
            case 53: {
                if ((this.currentPage + 1) * 45 >= this.goal.getCommands().size()) break;
                ++this.currentPage;
                this.updateCommandsPage();
                break;
            }
            case 48: {
                whoClicked.closeInventory();
                this.startCommandAdd(whoClicked);
                break;
            }
            case 49: {
                whoClicked.closeInventory();
                this.parentGui.openInventory(whoClicked);
                break;
            }
            case 50: {
                this.handleDeleteAll(whoClicked);
                break;
            }
            default: {
                if (slot >= 45 || clickedItem.getType() != Material.PAPER) break;
                String command = PlainTextComponentSerializer.plainText().serialize(clickedItem.getItemMeta().displayName()).substring(2);
                if (action.equals((Object)InventoryAction.PICKUP_HALF)) {
                    this.goal.removeCommand(command);
                    this.updateCommandsPage();
                    break;
                }
                whoClicked.closeInventory();
                this.startCommandEdit(whoClicked, command);
            }
        }
    }

    private void startCommandAdd(Player player) {
        this.chatHandler.startChatInput(player, "\n\u00a77Enter a command with '/' or type \u00a7ccancel\u00a77 to exit.\nYou can use the \u00a7ePLAYER_NAME \u00a77placeholder to refer to the player.", (p, input) -> {
            if (input.equalsIgnoreCase("cancel")) {
                p.sendMessage((Component)Component.text((String)"\u00a77Command add cancelled"));
                this.openInventory((Player)p);
                return;
            }
            this.goal.addCommand((String)input);
            p.sendMessage((Component)Component.text((String)("\u00a77Command \u00a7e" + input + " \u00a77added. It will be executed when a player reaches the goal \u00a7e" + this.goal.getName())));
            this.openInventory((Player)p);
        });
    }

    private void startCommandEdit(Player player, String oldCommand) {
        this.chatHandler.startChatInput(player, "\n\u00a77Please type the new command in chat or type \u00a7ccancel\u00a77 to exit.\nYou can also type \u00a7e/cancel \u00a77to exit the process anytime.", (p, input) -> {
            if (input.equalsIgnoreCase("cancel")) {
                p.sendMessage((Component)Component.text((String)"\u00a7cCommand edit cancelled"));
                this.openInventory((Player)p);
                return;
            }
            this.goal.removeCommand(oldCommand);
            this.goal.addCommand((String)input);
            p.sendMessage((Component)Component.text((String)"\u00a7aCommand edited successfully!"));
            this.openInventory((Player)p);
        });
        Component preText = Component.text((String)"You can ").color(TextColor.color((int)170, (int)170, (int)170));
        Component clickableText = ((TextComponent)((TextComponent)((TextComponent)Component.text((String)"[click here]").color(TextColor.color((int)255, (int)170, (int)0))).decoration(TextDecoration.BOLD, true)).clickEvent(ClickEvent.suggestCommand((String)oldCommand))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click to autocomplete command")));
        Component fullMessage = ((TextComponent)((TextComponent)((TextComponent)Component.empty().append((Component)Component.text((String)"\n"))).append(preText)).append(clickableText)).append(Component.text((String)" to autocomplete the old command").color(TextColor.color((int)170, (int)170, (int)170)));
        player.sendMessage(fullMessage);
    }

    private void handleDeleteAll(Player whoClicked) {
        ItemStack warningItem = this.parentGui.createGuiItem(Material.BARRIER, Component.text((String)"\u00a7c\u00a7lDelete All Commands"), Component.text((String)"\u00a77This will remove all commands from this goal"));
        ConfirmationGui confirmationGui = new ConfirmationGui(warningItem, confirmed -> {
            if (confirmed.booleanValue()) {
                for (String cmd : new ArrayList<String>(this.goal.getCommands())) {
                    this.goal.removeCommand(cmd);
                }
                this.openInventory(whoClicked);
            } else {
                this.openInventory(whoClicked);
            }
        });
        whoClicked.closeInventory();
        confirmationGui.openInventory(whoClicked);
    }

    private static final class Slots {
        static final int PREV_PAGE = 45;
        static final int NEXT_PAGE = 53;
        static final int ADD_COMMAND = 48;
        static final int BACK = 49;
        static final int DELETE_ALL = 50;

        private Slots() {
        }
    }
}

