/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.GUIs;

import java.util.Arrays;
import java.util.function.Consumer;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.NotNull;

public class ConfirmationGui
implements InventoryHolder,
Listener {
    private static final int GUI_SIZE = 27;
    private Inventory inv;
    private ItemStack itemToRemove;
    private Consumer<Boolean> callback;

    public ConfirmationGui() {
    }

    public ConfirmationGui(ItemStack itemToRemove, Consumer<Boolean> callback) {
        this.inv = Bukkit.createInventory((InventoryHolder)this, (int)27, (Component)Component.text((String)"Confirm removal"));
        this.itemToRemove = itemToRemove;
        this.callback = callback;
    }

    @NotNull
    public Inventory getInventory() {
        return this.inv;
    }

    public void initializeItems() {
        for (int i = 0; i < 27; ++i) {
            this.inv.setItem(i, this.createGuiItem(new ItemStack(Material.BLACK_STAINED_GLASS_PANE, 1), Component.text((String)"\u00a7f[\u00a76P.T.M.\u00a7f]\u00a77"), new TextComponent[0]));
        }
        this.inv.setItem(11, this.createGuiItem(new ItemStack(Material.GREEN_CONCRETE, 1), Component.text((String)"\u00a72\u00a7lYes"), new TextComponent[0]));
        this.inv.setItem(15, this.createGuiItem(new ItemStack(Material.RED_CONCRETE, 1), Component.text((String)"\u00a74\u00a7lNo"), new TextComponent[0]));
        this.inv.setItem(13, this.itemToRemove);
    }

    private ItemStack createGuiItem(ItemStack item, @Nullable TextComponent name, TextComponent ... lore) {
        ItemMeta meta = item.getItemMeta();
        meta.displayName((Component)name);
        if (lore != null) {
            meta.lore(Arrays.asList(lore));
        }
        item.setItemMeta(meta);
        return item;
    }

    public void openInventory(Player p) {
        this.initializeItems();
        p.openInventory(this.inv);
    }

    public void onGUIClick(Player whoClicked, int slot) {
        if (slot == 11) {
            whoClicked.closeInventory();
            this.callback.accept(true);
        } else if (slot == 15) {
            whoClicked.closeInventory();
            this.callback.accept(false);
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent e) {
        if (e.getInventory().getHolder() instanceof ConfirmationGui && e.getRawSlot() < e.getInventory().getSize()) {
            e.setCancelled(true);
            ConfirmationGui gui = (ConfirmationGui)e.getInventory().getHolder();
            gui.onGUIClick((Player)e.getWhoClicked(), e.getRawSlot());
        }
    }

    private static final class Slots {
        static final int YES_BUTTON = 11;
        static final int ITEM_DISPLAY = 13;
        static final int NO_BUTTON = 15;

        private Slots() {
        }
    }
}

