/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.GUIs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import me.thegabro.playtimemanager.GUIs.AllGoalsGui;
import me.thegabro.playtimemanager.GUIs.CommandsGui;
import me.thegabro.playtimemanager.GUIs.ConfirmationGui;
import me.thegabro.playtimemanager.GUIs.PermissionsGui;
import me.thegabro.playtimemanager.Goals.Goal;
import me.thegabro.playtimemanager.PlayTimeManager;
import me.thegabro.playtimemanager.Users.DBUser;
import me.thegabro.playtimemanager.Users.DBUsersManager;
import me.thegabro.playtimemanager.Utils;
import me.thegabro.playtimemanager.anvilgui.AnvilGUI;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.NotNull;

public class GoalSettingsGui
implements InventoryHolder,
Listener {
    private static final int GUI_SIZE = 45;
    private Inventory inventory;
    private Goal goal;
    private Object previousGui;
    private PlayTimeManager plugin;
    private final DBUsersManager dbUsersManager = DBUsersManager.getInstance();

    public GoalSettingsGui() {
    }

    public GoalSettingsGui(Goal goal, Object previousGui) {
        this.goal = goal;
        this.previousGui = previousGui;
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)45, (Component)Component.text((String)(goal.getName() + " - Settings")));
        this.plugin = PlayTimeManager.getInstance();
    }

    @NotNull
    public Inventory getInventory() {
        return this.inventory;
    }

    public void initializeItems() {
        this.inventory.clear();
        this.initializeBackground();
        this.initializeButtons();
    }

    private void initializeBackground() {
        for (int i = 0; i < 45; ++i) {
            if (this.isButtonSlot(i)) continue;
            this.inventory.setItem(i, this.createGuiItem(Material.BLACK_STAINED_GLASS_PANE, Component.text((String)"\u00a7f[\u00a76P.T.M.\u00a7f]\u00a77"), new TextComponent[0]));
        }
    }

    private boolean isButtonSlot(int slot) {
        return slot == 10 || slot == 12 || slot == 14 || slot == 16 || slot == 29 || slot == 31 || slot == 33 || slot == 44;
    }

    private void initializeButtons() {
        this.inventory.setItem(10, this.createGuiItem(Material.CLOCK, Component.text((String)("\u00a7e\u00a7lRequired Time: \u00a76" + Utils.ticksToFormattedPlaytime(this.goal.getTime()))), Component.text((String)"\u00a77Click to modify the required playtime")));
        ArrayList<TextComponent> lore = new ArrayList<TextComponent>();
        lore.add(Component.text((String)("\u00a77Currently \u00a7e" + this.goal.getPermissions().size() + "\u00a77 " + (this.goal.getPermissions().size() != 1 ? "permissions loaded" : "permission loaded"))));
        lore.add(Component.text((String)"\u00a77Click to change the permissions"));
        if (!PlayTimeManager.getInstance().isPermissionsManagerConfigured()) {
            lore.add(Component.text((String)""));
            lore.add(Component.text((String)"\u00a74\u00a7lWARNING: \u00a7cNo permissions plugin detected!"));
            lore.add(Component.text((String)"\u00a7cPermissions will not be assigned"));
        }
        this.inventory.setItem(12, this.createGuiItem(Material.NAME_TAG, Component.text((String)"\u00a7e\u00a7lPermissions"), lore.toArray(new TextComponent[0])));
        this.inventory.setItem(14, this.createGuiItem(Material.OAK_SIGN, Component.text((String)"\u00a7e\u00a7lGoal Message"), Component.text((String)"\u00a7cTo update this setting, please edit the"), Component.text((String)("\u00a7c'" + this.goal.getName() + ".yml' configuration file.")), Component.text((String)"\u00a7cModification via GUI is not currently supported.")));
        this.inventory.setItem(16, this.createGuiItem(Material.NOTE_BLOCK, Component.text((String)"\u00a7e\u00a7lGoal Sound"), Component.text((String)("\u00a77Current: \u00a7f" + this.goal.getGoalSound())), Component.text((String)"\u00a77Right click to play the sound."), Component.text((String)""), Component.text((String)"\u00a7cTo update this setting, please edit the"), Component.text((String)("\u00a7c'" + this.goal.getName() + ".yml' configuration file.")), Component.text((String)"\u00a7cModification via GUI is not currently supported.")));
        this.inventory.setItem(29, this.createGuiItem(this.goal.isActive() ? Material.GREEN_CONCRETE : Material.RED_CONCRETE, Component.text((String)(this.goal.isActive() ? "\u00a7a\u00a7lGoal Active" : "\u00a7c\u00a7lGoal Inactive")), Component.text((String)("\u00a77Click to " + (this.goal.isActive() ? "deactivate" : "activate") + " this goal"))));
        this.inventory.setItem(31, this.createGuiItem(Material.COMMAND_BLOCK, Component.text((String)"\u00a7e\u00a7lCommands"), Component.text((String)("\u00a77Currently \u00a7e" + this.goal.getCommands().size() + "\u00a77 " + (this.goal.getCommands().size() != 1 ? "commands loaded" : "command loaded"))), Component.text((String)"\u00a77Click to manage commands")));
        this.inventory.setItem(33, this.createGuiItem(Material.BARRIER, Component.text((String)"\u00a7c\u00a7lDelete Goal"), Component.text((String)"\u00a77Click to delete this goal")));
        this.inventory.setItem(36, this.createGuiItem(Material.PLAYER_HEAD, Component.text((String)"\u00a7e\u00a7lUncomplete Goal for Player"), Component.text((String)"\u00a77Click to remove this goal's completion"), Component.text((String)"\u00a77from a specific player")));
        this.inventory.setItem(44, this.createGuiItem(Material.MAGENTA_GLAZED_TERRACOTTA, Component.text((String)"\u00a7e\u00a7lBack"), new TextComponent[0]));
    }

    protected ItemStack createGuiItem(Material material, @Nullable TextComponent name, TextComponent ... lore) {
        ItemStack item = new ItemStack(material, 1);
        ItemMeta meta = item.getItemMeta();
        meta.displayName((Component)name);
        if (lore != null) {
            meta.lore(Arrays.asList(lore));
        }
        item.setItemMeta(meta);
        return item;
    }

    public void openInventory(Player player) {
        this.initializeItems();
        player.openInventory(this.inventory);
    }

    public void onGUIClick(Player player, int slot, ItemStack clickedItem, ClickType clickType) {
        if (clickedItem == null || clickedItem.getType().equals((Object)Material.AIR) || clickedItem.getType().equals((Object)Material.BLACK_STAINED_GLASS_PANE)) {
            return;
        }
        switch (slot) {
            case 10: {
                this.openTimeEditor(player);
                break;
            }
            case 12: {
                player.closeInventory();
                new PermissionsGui(this.goal, this).openInventory(player);
                break;
            }
            case 14: {
                break;
            }
            case 16: {
                if (clickType != ClickType.RIGHT) break;
                this.playGoalSound(player);
                break;
            }
            case 31: {
                player.closeInventory();
                new CommandsGui(this.goal, this).openInventory(player);
                break;
            }
            case 29: {
                this.goal.setActivation(!this.goal.isActive());
                this.initializeItems();
                break;
            }
            case 33: {
                this.handleDeleteGoal(player);
                break;
            }
            case 36: {
                this.openUncompleteGoalDialog(player);
                break;
            }
            case 44: {
                this.handleBackButton(player);
            }
        }
    }

    private void playGoalSound(Player player) {
        try {
            Sound sound;
            String soundName;
            block6: {
                soundName = this.goal.getGoalSound();
                sound = null;
                try {
                    sound = (Sound)Sound.class.getField(soundName).get(null);
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    if (!this.plugin.getConfiguration().getGoalsCheckVerbose()) break block6;
                    this.plugin.getLogger().info("Could not find sound directly, attempting fallback: " + e.getMessage());
                }
            }
            if (sound != null) {
                player.playSound(player.getLocation(), sound, 10.0f, 0.0f);
            } else {
                this.plugin.getLogger().warning(String.format("Could not find sound '%s' for goal '%s'", soundName, this.goal.getName()));
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().severe(String.format("Failed to play sound '%s' for goal '%s': %s", this.goal.getGoalSound(), this.goal.getName(), e.getMessage()));
        }
    }

    private void handleDeleteGoal(Player player) {
        ItemStack goalItem = this.createGuiItem(Material.BARRIER, Component.text((String)("\u00a7c\u00a7lDelete Goal: " + this.goal.getName())), new TextComponent[0]);
        ConfirmationGui confirmationGui = new ConfirmationGui(goalItem, confirmed -> {
            if (confirmed.booleanValue()) {
                player.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getPluginPrefix() + " &7Deleting goal &e" + this.goal.getName() + "&7..."));
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)PlayTimeManager.getInstance(), () -> {
                    this.goal.kill();
                    Bukkit.getScheduler().runTask((Plugin)PlayTimeManager.getInstance(), () -> {
                        player.sendMessage(Utils.parseColors(this.plugin.getConfiguration().getPluginPrefix() + " &aSuccessfully &7deleted goal &e" + this.goal.getName()));
                        if (this.previousGui != null) {
                            ((AllGoalsGui)this.previousGui).openInventory(player);
                        }
                    });
                });
            } else {
                this.openInventory(player);
            }
        });
        player.closeInventory();
        confirmationGui.openInventory(player);
    }

    private void handleBackButton(Player player) {
        if (this.previousGui != null) {
            player.closeInventory();
            ((AllGoalsGui)this.previousGui).openInventory(player);
        }
    }

    private void openTimeEditor(Player player) {
        player.closeInventory();
        new AnvilGUI.Builder().onClick((slot, stateSnapshot) -> {
            if (slot != 2) {
                return Collections.emptyList();
            }
            String text = stateSnapshot.getText();
            long time = Utils.formattedPlaytimeToTicks(text);
            if (time != -1L) {
                this.goal.setTime(time);
                this.reopenMainGui(player);
                return Collections.singletonList(AnvilGUI.ResponseAction.close());
            }
            return Collections.singletonList(AnvilGUI.ResponseAction.updateTitle("Invalid format!", true));
        }).onClose(state -> Bukkit.getScheduler().runTask((Plugin)PlayTimeManager.getPlugin(PlayTimeManager.class), () -> this.openInventory(state.getPlayer()))).text(Utils.ticksToFormattedPlaytime(this.goal.getTime())).title("Format: 1y,2d,3h,4m,5s").plugin((Plugin)PlayTimeManager.getPlugin(PlayTimeManager.class)).open(player);
    }

    private void openUncompleteGoalDialog(Player player) {
        ItemStack item = new ItemStack(Material.PLAYER_HEAD);
        ItemMeta meta = item.getItemMeta();
        meta.displayName((Component)Component.text((String)" "));
        item.setItemMeta(meta);
        player.closeInventory();
        new AnvilGUI.Builder().onClick((slot, stateSnapshot) -> {
            if (slot != 2) {
                return Collections.emptyList();
            }
            String playerName = stateSnapshot.getText().replace(" ", "");
            DBUser user = this.dbUsersManager.getUserFromNickname(playerName);
            if (user == null) {
                return Collections.singletonList(AnvilGUI.ResponseAction.updateTitle("Player not found!", true));
            }
            if (user.hasCompletedGoal(this.goal.getName())) {
                user.unmarkGoalAsCompleted(this.goal.getName());
                player.sendMessage((Component)Component.text((String)("[\u00a76PlayTime\u00a7eManager\u00a7f]\u00a77 Successfully uncompleted goal \u00a7a" + this.goal.getName() + "\u00a77 for player \u00a7a" + playerName)));
                this.reopenMainGui(player);
                return Collections.singletonList(AnvilGUI.ResponseAction.close());
            }
            return Collections.singletonList(AnvilGUI.ResponseAction.updateTitle("Player hasn't reach that goal!", true));
        }).onClose(state -> Bukkit.getScheduler().runTask((Plugin)PlayTimeManager.getPlugin(PlayTimeManager.class), () -> this.openInventory(state.getPlayer()))).itemLeft(item).title("Enter player name:").plugin((Plugin)PlayTimeManager.getPlugin(PlayTimeManager.class)).open(player);
    }

    private void reopenMainGui(Player player) {
        Bukkit.getScheduler().runTask((Plugin)PlayTimeManager.getPlugin(PlayTimeManager.class), () -> this.openInventory(player));
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent e) {
        if (e.getInventory().getHolder() instanceof GoalSettingsGui && e.getRawSlot() < e.getInventory().getSize()) {
            e.setCancelled(true);
            GoalSettingsGui gui = (GoalSettingsGui)e.getInventory().getHolder();
            gui.onGUIClick((Player)e.getWhoClicked(), e.getRawSlot(), e.getCurrentItem(), e.getClick());
        }
    }

    private static final class Slots {
        static final int TIME_SETTING = 10;
        static final int GOAL_PERMISSIONS = 12;
        static final int GOAL_MESSAGE = 14;
        static final int GOAL_SOUND = 16;
        static final int GOAL_ACTIVATION_STATUS = 29;
        static final int GOAL_COMMANDS = 31;
        static final int DELETE_GOAL = 33;
        static final int UNCOMPLETE_GOAL = 36;
        static final int BACK_BUTTON = 44;

        private Slots() {
        }
    }
}

