/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.GUIs;

import java.util.ArrayList;
import java.util.Collections;
import me.thegabro.playtimemanager.ExternalPluginSupport.LuckPermsManager;
import me.thegabro.playtimemanager.GUIs.ConfirmationGui;
import me.thegabro.playtimemanager.GUIs.GoalSettingsGui;
import me.thegabro.playtimemanager.Goals.Goal;
import me.thegabro.playtimemanager.PlayTimeManager;
import me.thegabro.playtimemanager.anvilgui.AnvilGUI;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class PermissionsGui
implements InventoryHolder,
Listener {
    private static final int GUI_SIZE = 54;
    private static final int PERMISSIONS_PER_PAGE = 45;
    private Inventory inventory;
    private Goal goal;
    private GoalSettingsGui parentGui;
    private int currentPage;

    public PermissionsGui() {
    }

    public PermissionsGui(Goal goal, GoalSettingsGui parentGui) {
        this.goal = goal;
        this.parentGui = parentGui;
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)54, (Component)Component.text((String)"\u00a76Permissions Editor"));
        this.currentPage = 0;
    }

    @NotNull
    public Inventory getInventory() {
        return this.inventory;
    }

    public void openInventory(Player player) {
        this.initializeItems();
        player.openInventory(this.inventory);
    }

    private void initializeItems() {
        for (int i = 0; i < 54; ++i) {
            this.inventory.setItem(i, this.createBackgroundItem());
        }
        this.updatePermissionsPage();
        this.addControlButtons();
    }

    private ItemStack createBackgroundItem() {
        return this.parentGui.createGuiItem(Material.BLACK_STAINED_GLASS_PANE, Component.text((String)"\u00a7f"), new TextComponent[0]);
    }

    private void updatePermissionsPage() {
        int i;
        ArrayList<String> permissions = this.goal.getPermissions();
        int startIndex = this.currentPage * 45;
        for (i = 0; i < 45; ++i) {
            this.inventory.setItem(i, this.createBackgroundItem());
        }
        for (i = 0; i < 45 && startIndex + i < permissions.size(); ++i) {
            String permission = (String)permissions.get(startIndex + i);
            if (permission.startsWith("group.")) {
                boolean groupExists;
                String groupName = permission.substring(6);
                boolean bl = groupExists = PlayTimeManager.getInstance().isPermissionsManagerConfigured() && PlayTimeManager.getInstance().getLuckPermsApi() != null && LuckPermsManager.getInstance(PlayTimeManager.getInstance()).groupExists(groupName);
                if (!groupExists) {
                    this.inventory.setItem(i, this.parentGui.createGuiItem(Material.BOOK, Component.text((String)("\u00a7e" + permission)), Component.text((String)"\u00a77Click to edit"), Component.text((String)"\u00a7cRight-click to remove"), Component.text((String)""), Component.text((String)("\u00a7c\u26a0 WARNING: Group '" + groupName + "' does not exist!")), Component.text((String)"\u00a7cPlease create this group in LuckPerms"), Component.text((String)"\u00a7cor remove this permission.")));
                    continue;
                }
                this.inventory.setItem(i, this.parentGui.createGuiItem(Material.BOOK, Component.text((String)("\u00a7e" + permission)), Component.text((String)"\u00a77Click to edit"), Component.text((String)"\u00a7cRight-click to remove")));
                continue;
            }
            this.inventory.setItem(i, this.parentGui.createGuiItem(Material.PAPER, Component.text((String)("\u00a7e" + permission)), Component.text((String)"\u00a77Click to edit"), Component.text((String)"\u00a7cRight-click to remove")));
        }
        this.addControlButtons();
    }

    private void addControlButtons() {
        if (this.currentPage > 0) {
            this.inventory.setItem(45, this.parentGui.createGuiItem(Material.ARROW, Component.text((String)"\u00a7ePrevious Page"), new TextComponent[0]));
        }
        if ((this.currentPage + 1) * 45 < this.goal.getPermissions().size()) {
            this.inventory.setItem(53, this.parentGui.createGuiItem(Material.ARROW, Component.text((String)"\u00a7eNext Page"), new TextComponent[0]));
        }
        this.inventory.setItem(48, this.parentGui.createGuiItem(Material.EMERALD, Component.text((String)"\u00a7a\u00a7lAdd Permission"), Component.text((String)"\u00a77Click to add a new permission")));
        this.inventory.setItem(49, this.parentGui.createGuiItem(Material.MAGENTA_GLAZED_TERRACOTTA, Component.text((String)"\u00a76\u00a7lBack"), new TextComponent[0]));
        this.inventory.setItem(50, this.parentGui.createGuiItem(Material.BARRIER, Component.text((String)"\u00a7c\u00a7lDelete all"), Component.text((String)"\u00a77Click to discard every permission")));
    }

    public void onGUIClick(Player whoClicked, int slot, ItemStack clickedItem, InventoryAction action) {
        if (clickedItem == null || clickedItem.getType().equals((Object)Material.AIR) || clickedItem.getType().equals((Object)Material.BLACK_STAINED_GLASS_PANE)) {
            return;
        }
        switch (slot) {
            case 45: {
                if (this.currentPage <= 0) break;
                --this.currentPage;
                this.updatePermissionsPage();
                break;
            }
            case 53: {
                if ((this.currentPage + 1) * 45 >= this.goal.getPermissions().size()) break;
                ++this.currentPage;
                this.updatePermissionsPage();
                break;
            }
            case 48: {
                whoClicked.closeInventory();
                this.openAddPermissionDialog(whoClicked);
                break;
            }
            case 49: {
                whoClicked.closeInventory();
                this.parentGui.openInventory(whoClicked);
                break;
            }
            case 50: {
                this.handleDeleteAll(whoClicked);
                break;
            }
            default: {
                if (slot >= 45 || clickedItem.getType() != Material.PAPER && clickedItem.getType() != Material.BOOK) break;
                String permission = PlainTextComponentSerializer.plainText().serialize(clickedItem.getItemMeta().displayName()).substring(2);
                if (action.equals((Object)InventoryAction.PICKUP_HALF)) {
                    this.goal.removePermission(permission);
                    this.updatePermissionsPage();
                    break;
                }
                whoClicked.closeInventory();
                this.openEditPermissionDialog(whoClicked, permission);
            }
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent e) {
        if (e.getInventory().getHolder() instanceof PermissionsGui) {
            if (e.getRawSlot() < e.getInventory().getSize()) {
                e.setCancelled(true);
                PermissionsGui gui = (PermissionsGui)e.getInventory().getHolder();
                gui.onGUIClick((Player)e.getWhoClicked(), e.getRawSlot(), e.getCurrentItem(), e.getAction());
            } else if (e.getAction().equals((Object)InventoryAction.MOVE_TO_OTHER_INVENTORY)) {
                e.setCancelled(true);
            }
        }
    }

    private void openAddPermissionDialog(Player player) {
        new AnvilGUI.Builder().onClick((slot, state) -> {
            if (slot != 2) {
                return Collections.emptyList();
            }
            String permission = state.getText();
            if (!permission.isEmpty()) {
                this.goal.addPermission(permission);
            }
            Bukkit.getScheduler().runTask((Plugin)PlayTimeManager.getPlugin(PlayTimeManager.class), () -> this.openInventory(player));
            return Collections.singletonList(AnvilGUI.ResponseAction.close());
        }).onClose(state -> Bukkit.getScheduler().runTask((Plugin)PlayTimeManager.getPlugin(PlayTimeManager.class), () -> this.openInventory(state.getPlayer()))).text("Enter permission").title("Add Permission").plugin((Plugin)PlayTimeManager.getPlugin(PlayTimeManager.class)).open(player);
    }

    private void openEditPermissionDialog(Player player, String oldPermission) {
        new AnvilGUI.Builder().onClick((slot, state) -> {
            if (slot != 2) {
                return Collections.emptyList();
            }
            String newPermission = state.getText();
            if (!newPermission.isEmpty()) {
                this.goal.removePermission(oldPermission);
                this.goal.addPermission(newPermission);
            }
            Bukkit.getScheduler().runTask((Plugin)PlayTimeManager.getPlugin(PlayTimeManager.class), () -> this.openInventory(player));
            return Collections.singletonList(AnvilGUI.ResponseAction.close());
        }).onClose(state -> Bukkit.getScheduler().runTask((Plugin)PlayTimeManager.getPlugin(PlayTimeManager.class), () -> this.openInventory(state.getPlayer()))).text(oldPermission).title("Edit Permission").plugin((Plugin)PlayTimeManager.getPlugin(PlayTimeManager.class)).open(player);
    }

    private void handleDeleteAll(Player whoClicked) {
        ItemStack warningItem = this.parentGui.createGuiItem(Material.BARRIER, Component.text((String)"\u00a7c\u00a7lDelete All Permissions"), Component.text((String)"\u00a77This will remove all permissions from this goal"));
        ConfirmationGui confirmationGui = new ConfirmationGui(warningItem, confirmed -> {
            if (confirmed.booleanValue()) {
                for (String p : new ArrayList<String>(this.goal.getPermissions())) {
                    this.goal.removePermission(p);
                }
                this.openInventory(whoClicked);
            } else {
                this.openInventory(whoClicked);
            }
        });
        whoClicked.closeInventory();
        confirmationGui.openInventory(whoClicked);
    }

    private static final class Slots {
        static final int PREV_PAGE = 45;
        static final int NEXT_PAGE = 53;
        static final int ADD_PERMISSION = 48;
        static final int BACK = 49;
        static final int DELETE_ALL = 50;

        private Slots() {
        }
    }
}

