/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.Goals;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import me.thegabro.playtimemanager.Goals.GoalsManager;
import me.thegabro.playtimemanager.PlayTimeManager;
import me.thegabro.playtimemanager.Users.DBUsersManager;
import me.thegabro.playtimemanager.Users.OnlineUser;
import me.thegabro.playtimemanager.Users.OnlineUsersManager;
import org.bukkit.configuration.file.YamlConfiguration;

public class Goal {
    private final PlayTimeManager plugin;
    private final GoalsManager goalsManager = GoalsManager.getInstance();
    private final OnlineUsersManager onlineUsersManager = OnlineUsersManager.getInstance();
    private String name;
    private long time;
    private final File goalFile;
    private ArrayList<String> permissions = new ArrayList();
    private ArrayList<String> commands = new ArrayList();
    private String goalMessage;
    private String goalSound;
    private boolean active;

    public Goal(PlayTimeManager plugin, String name, Long time, boolean active) {
        this.plugin = plugin;
        this.name = name;
        this.time = time == null ? Long.MAX_VALUE : time;
        this.goalFile = new File(String.valueOf(plugin.getDataFolder()) + File.separator + "Goals" + File.separator + name + ".yml");
        this.active = active;
        this.loadFromFile();
        this.saveToFile();
        this.goalsManager.addGoal(this);
    }

    private void loadFromFile() {
        if (this.goalFile.exists()) {
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)this.goalFile);
            this.time = config.getLong("time", this.time);
            this.goalMessage = config.getString("goal-message", this.getDefaultGoalMessage());
            this.goalSound = config.getString("goal-sound", this.getDefaultGoalSound());
            this.permissions = new ArrayList(config.getStringList("permissions"));
            this.commands = new ArrayList(config.getStringList("commands"));
            this.active = config.getBoolean("active", false);
        } else {
            this.goalMessage = this.getDefaultGoalMessage();
            this.goalSound = this.getDefaultGoalSound();
            this.permissions = new ArrayList();
            this.commands = new ArrayList();
        }
    }

    private void saveToFile() {
        try {
            if (!this.goalFile.exists()) {
                this.goalFile.getParentFile().mkdirs();
                this.goalFile.createNewFile();
            }
            YamlConfiguration config = new YamlConfiguration();
            config.options().setHeader(Arrays.asList("GUIDE OF AVAILABLE OPTIONS:", "---------------------------", "goal-sound is played to a player if it reaches the time specified in this config.", "A list of available sounds can be found here: https://jd.papermc.io/paper/<VERSION>/org/bukkit/Sound.html", "Replace '<VERSION>' in the link with your current minecraft version. If it doesn't work try with the ", "latest update of your version (e.g. '1.19' doesn't work and you need to use '1.19.4')", "---------------------------", "goal-message is showed to a player if it reaches the time specified in this config.", "Available placeholders: %TIME_REQUIRED%, %PLAYER_NAME%. %GOAL_NAME%", "---------------------------", "active determines whether this goal is enabled and being checked by the plugin", "Set to 'true' to enable the goal and track player progress", "Set to 'false' (default option) to disable the goal without deleting it", "This is useful for:", "* Temporarily disabling goals without removing them", "* Testing new goals before making them live", "* Managing seasonal or event-specific goals", "---------------------------", "permissions defines what permissions will be granted to a player when they reach this goal", "You can specify multiple permissions and groups that will all be granted. The plugin will assume that", "the group has already been created using the permissions manager plugin specified in the main config.", "---------------------------", "commands defines a list of commands that will be executed when a player reaches this goal", "Available placeholders: %PLAYER_NAME%", "Example commands:", "- '/give %PLAYER_NAME% diamond 64'", "- '/broadcast %PLAYER_NAME% has reached an amazing milestone!'"));
            config.set("time", (Object)this.time);
            config.set("goal-sound", (Object)this.goalSound);
            config.set("goal-message", (Object)this.goalMessage);
            config.set("active", (Object)this.active);
            config.set("permissions", this.permissions);
            config.set("commands", this.commands);
            config.save(this.goalFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save goal file for " + this.name + ": " + e.getMessage());
        }
    }

    public void deleteFile() {
        if (this.goalFile.exists() && !this.goalFile.delete()) {
            this.plugin.getLogger().warning("Failed to delete goal file for " + this.name);
        }
    }

    private String getDefaultGoalSound() {
        return "ENTITY_PLAYER_LEVELUP";
    }

    private String getDefaultGoalMessage() {
        return "[\u00a76PlayTime\u00a7eManager\u00a7f]\u00a77 Congratulations \u00a7e%PLAYER_NAME%\u00a77 you have reached \u00a76%TIME_REQUIRED%\u00a77 of playtime!";
    }

    public String getName() {
        return this.name;
    }

    public long getTime() {
        return this.time;
    }

    public String getGoalMessage() {
        return this.goalMessage;
    }

    public String getGoalSound() {
        return this.goalSound;
    }

    public boolean isActive() {
        return this.active;
    }

    public ArrayList<String> getCommands() {
        return this.commands;
    }

    public ArrayList<String> getPermissions() {
        return this.permissions;
    }

    public void rename(String newName) {
        File oldFile = this.goalFile;
        for (OnlineUser user : this.onlineUsersManager.getOnlineUsersByUUID().values()) {
            user.unmarkGoalAsCompleted(this.name);
            user.markGoalAsCompleted(newName);
        }
        this.name = newName;
        File newFile = new File(String.valueOf(this.plugin.getDataFolder()) + File.separator + "Goals" + File.separator + newName + ".yml");
        try {
            if (!newFile.getParentFile().exists()) {
                newFile.getParentFile().mkdirs();
            }
            if (oldFile.exists() && !oldFile.renameTo(newFile)) {
                YamlConfiguration config = YamlConfiguration.loadConfiguration((File)oldFile);
                config.save(newFile);
                oldFile.delete();
            }
            this.saveToFile();
            this.plugin.getDatabase().updateGoalName(oldFile.getName().replace(".yml", ""), newName);
            oldFile.delete();
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not rename goal file from " + oldFile.getName() + " to " + newFile.getName() + ": " + e.getMessage());
        }
    }

    public void setTime(long time) {
        this.time = time;
        this.saveToFile();
    }

    public void setGoalMessage(String goalMessage) {
        this.goalMessage = goalMessage;
        this.saveToFile();
    }

    public void setGoalSound(String goalSound) {
        this.goalSound = goalSound;
        this.saveToFile();
    }

    public void setActivation(boolean activation) {
        this.active = activation;
        this.saveToFile();
    }

    public void addCommand(String command) {
        this.commands.add(command);
        this.saveToFile();
    }

    public void removeCommand(String command) {
        this.commands.remove(command);
        this.saveToFile();
    }

    public void addPermission(String permission) {
        this.permissions.add(permission);
        this.saveToFile();
    }

    public void removePermission(String permission) {
        this.permissions.remove(permission);
        this.saveToFile();
    }

    public void kill() {
        this.goalsManager.removeGoal(this);
        DBUsersManager.getInstance().removeGoalFromAllUsers(this.name);
        this.deleteFile();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Goal goal = (Goal)o;
        return Objects.equals(this.name, goal.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public String toString() {
        return "Goal{name='" + this.name + "', time=" + this.time + ", active=" + this.active + ", permissions=" + this.permissions.size() + ", commands=" + this.commands.size() + ", message='" + this.goalMessage + "', sound='" + this.goalSound + "'}";
    }
}

