/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.Goals;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import me.thegabro.playtimemanager.Goals.Goal;
import me.thegabro.playtimemanager.PlayTimeManager;

public class GoalsManager {
    private static GoalsManager instance;
    private final Set<Goal> goals = new HashSet<Goal>();
    private PlayTimeManager plugin;

    private GoalsManager() {
    }

    public static synchronized GoalsManager getInstance() {
        if (instance == null) {
            instance = new GoalsManager();
        }
        return instance;
    }

    public void initialize(PlayTimeManager playTimeManager) {
        this.plugin = playTimeManager;
        this.clearGoals();
        this.loadGoals();
    }

    public void addGoal(Goal goal) {
        this.goals.add(goal);
    }

    public void removeGoal(Goal goal) {
        this.goals.remove(goal);
        goal.deleteFile();
    }

    public Goal getGoal(String name) {
        return this.goals.stream().filter(g -> g.getName().equals(name)).findFirst().orElse(null);
    }

    public Set<Goal> getGoals() {
        return new HashSet<Goal>(this.goals);
    }

    public List<String> getGoalsNames() {
        return this.goals.stream().map(Goal::getName).collect(Collectors.toList());
    }

    public void clearGoals() {
        this.goals.clear();
    }

    public void loadGoals() {
        File[] goalFiles;
        File goalsFolder = new File(this.plugin.getDataFolder(), "Goals");
        if (goalsFolder.exists() && goalsFolder.isDirectory() && (goalFiles = goalsFolder.listFiles((dir, name) -> name.endsWith(".yml"))) != null) {
            for (File file : goalFiles) {
                String goalName = file.getName().replace(".yml", "");
                new Goal(this.plugin, goalName, 0L, false);
            }
        }
    }

    public boolean areAllInactive() {
        for (Goal g : this.goals) {
            if (!g.isActive()) continue;
            return false;
        }
        return true;
    }
}

