/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager;

import java.io.File;
import java.util.Objects;
import me.thegabro.playtimemanager.Commands.PlayTimeBackup;
import me.thegabro.playtimemanager.Commands.PlayTimeCommandManager.PlayTimeCommandManager;
import me.thegabro.playtimemanager.Commands.PlaytimeAverage;
import me.thegabro.playtimemanager.Commands.PlaytimeGoal;
import me.thegabro.playtimemanager.Commands.PlaytimePercentage;
import me.thegabro.playtimemanager.Commands.PlaytimeReload;
import me.thegabro.playtimemanager.Commands.PlaytimeTop;
import me.thegabro.playtimemanager.Configuration;
import me.thegabro.playtimemanager.Events.ChatEventManager;
import me.thegabro.playtimemanager.Events.JoinEventManager;
import me.thegabro.playtimemanager.Events.QuitEventManager;
import me.thegabro.playtimemanager.ExternalPluginSupport.LuckPermsManager;
import me.thegabro.playtimemanager.ExternalPluginSupport.PlayTimePlaceHolders;
import me.thegabro.playtimemanager.GUIs.AllGoalsGui;
import me.thegabro.playtimemanager.GUIs.CommandsGui;
import me.thegabro.playtimemanager.GUIs.ConfirmationGui;
import me.thegabro.playtimemanager.GUIs.GoalSettingsGui;
import me.thegabro.playtimemanager.GUIs.PermissionsGui;
import me.thegabro.playtimemanager.Goals.GoalsManager;
import me.thegabro.playtimemanager.SQLiteDB.LogFilter;
import me.thegabro.playtimemanager.SQLiteDB.PlayTimeDatabase;
import me.thegabro.playtimemanager.SQLiteDB.SQLite;
import me.thegabro.playtimemanager.Updates.UpdateManager;
import me.thegabro.playtimemanager.Users.DBUsersManager;
import me.thegabro.playtimemanager.Users.OnlineUsersManager;
import me.thegabro.playtimemanager.bstats.bukkit.Metrics;
import net.luckperms.api.LuckPerms;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class PlayTimeManager
extends JavaPlugin {
    private static PlayTimeManager instance;
    private Configuration config;
    private PlayTimeDatabase db;
    private boolean permissionsManagerConfigured;
    private final String CURRENTCONFIGVERSION = "3.4";
    private final String CURRENTGOALSCONFIGVERSION = "1.0";
    private OnlineUsersManager onlineUsersManager;
    private DBUsersManager dbUsersManager;
    private GoalsManager goalsManager;
    private final int BSTATS_PLUGIN_ID = 24739;
    private final String serverVersion = Bukkit.getBukkitVersion().split("-")[0];

    public void onEnable() {
        YamlConfiguration config;
        Metrics metrics = new Metrics(this, 24739);
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
        }
        instance = this;
        LogFilter.registerFilter();
        this.db = new SQLite(this);
        this.db.load();
        UpdateManager updateManager = UpdateManager.getInstance(this);
        updateManager.initialize();
        File configFile = new File(this.getDataFolder(), "config.yml");
        if (configFile.exists() && !(config = YamlConfiguration.loadConfiguration((File)configFile)).getString("config-version").equals("3.4")) {
            updateManager.performVersionUpdate(config.getString("config-version"), "3.4");
        }
        this.config = new Configuration(this.getDataFolder(), "config", true, true);
        this.goalsManager = GoalsManager.getInstance();
        this.goalsManager.initialize(this);
        this.onlineUsersManager = OnlineUsersManager.getInstance();
        this.dbUsersManager = DBUsersManager.getInstance();
        this.permissionsManagerConfigured = this.checkPermissionsPlugin();
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new PlayTimePlaceHolders().register();
        }
        this.getServer().getPluginManager().registerEvents((Listener)new QuitEventManager(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new JoinEventManager(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ChatEventManager(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new AllGoalsGui(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new GoalSettingsGui(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new PermissionsGui(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new CommandsGui(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new ConfirmationGui(), (Plugin)this);
        Objects.requireNonNull(this.getCommand("playtimegoal")).setExecutor((CommandExecutor)new PlaytimeGoal());
        Objects.requireNonNull(this.getCommand("playtime")).setExecutor((CommandExecutor)new PlayTimeCommandManager(){});
        Objects.requireNonNull(this.getCommand("playtimeaverage")).setExecutor((CommandExecutor)new PlaytimeAverage(){});
        Objects.requireNonNull(this.getCommand("playtimepercentage")).setExecutor((CommandExecutor)new PlaytimePercentage(){});
        Objects.requireNonNull(this.getCommand("playtimetop")).setExecutor((CommandExecutor)new PlaytimeTop(){});
        Objects.requireNonNull(this.getCommand("playtimereload")).setExecutor((CommandExecutor)new PlaytimeReload(){});
        Objects.requireNonNull(this.getCommand("playtimebackup")).setExecutor((CommandExecutor)new PlayTimeBackup(){});
        this.onlineUsersManager.initialize();
        this.dbUsersManager.updateTopPlayersFromDB();
        this.getLogger().info("has been enabled!");
    }

    public void onDisable() {
        this.onlineUsersManager.stopSchedules();
        for (Player p : Bukkit.getOnlinePlayers()) {
            this.onlineUsersManager.removeOnlineUser(this.onlineUsersManager.getOnlineUser(Objects.requireNonNull(p.getPlayer()).getName()));
        }
        this.db.close();
        HandlerList.unregisterAll((Plugin)this);
        this.dbUsersManager.clearCache();
        this.getLogger().info("has been disabled!");
    }

    public static PlayTimeManager getInstance() {
        return instance;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void setConfiguration(Configuration config) {
        this.config = config;
    }

    public PlayTimeDatabase getDatabase() {
        return this.db;
    }

    public LuckPerms getLuckPermsApi() {
        return LuckPermsManager.getInstance(this).getLuckPermsApi();
    }

    public boolean isPermissionsManagerConfigured() {
        return this.permissionsManagerConfigured;
    }

    public String getServerVersion() {
        return this.serverVersion;
    }

    private boolean checkPermissionsPlugin() {
        String configuredPlugin = this.config.getPermissionsManagerPlugin().toLowerCase();
        if ("luckperms".equals(configuredPlugin)) {
            Plugin luckPerms = Bukkit.getPluginManager().getPlugin("LuckPerms");
            if (luckPerms != null && luckPerms.isEnabled()) {
                try {
                    LuckPermsManager.getInstance(this);
                    this.getLogger().info("LuckPerms detected! Launching related functions");
                    return true;
                }
                catch (Exception e) {
                    this.getLogger().severe("ERROR: Failed to initialize LuckPerms API: " + e.getMessage());
                    return false;
                }
            }
            this.getLogger().warning("Failed to initialize permissions system: LuckPerms plugin configured but not found! \nUntil this is resolved, PlayTimeManager will not be able to manage permissions or groups");
            return false;
        }
        return false;
    }
}

