/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.SQLiteDB;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.stream.Collectors;
import me.thegabro.playtimemanager.PlayTimeManager;
import me.thegabro.playtimemanager.SQLiteDB.Errors;

public abstract class PlayTimeDatabase {
    PlayTimeManager plugin;
    Connection connection;
    protected static HikariDataSource dataSource;

    public PlayTimeDatabase(PlayTimeManager instance) {
        this.plugin = instance;
    }

    public abstract Connection getSQLConnection();

    public abstract void load();

    public void initialize(String dbName) {
        File dataFolder = new File(this.plugin.getDataFolder(), dbName + ".db");
        if (!dataFolder.exists()) {
            try {
                dataFolder.createNewFile();
            }
            catch (IOException e) {
                this.plugin.getLogger().log(Level.SEVERE, "File write error: " + dbName + ".db");
            }
        }
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl("jdbc:sqlite:" + dataFolder.getAbsolutePath());
        config.setDriverClassName("org.sqlite.JDBC");
        config.setMaximumPoolSize(20);
        config.setConnectionTestQuery("SELECT 1");
        config.addDataSourceProperty("journal_mode", "WAL");
        config.addDataSourceProperty("busy_timeout", "30000");
        dataSource = new HikariDataSource(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNickname(String uuid) {
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = this.getSQLConnection();
            ps = conn.prepareStatement("SELECT nickname FROM play_time WHERE uuid = ?;");
            ps.setString(1, uuid);
            rs = ps.executeQuery();
            if (rs.next()) {
                String string = rs.getString("nickname");
                return string;
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (ps != null) {
                    ps.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionClose(), ex);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getPlaytime(String uuid) {
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = this.getSQLConnection();
            ps = conn.prepareStatement("SELECT playtime FROM play_time WHERE uuid = ?;");
            ps.setString(1, uuid);
            rs = ps.executeQuery();
            if (rs.next()) {
                Long l = rs.getLong("playtime");
                return l;
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (ps != null) {
                    ps.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionClose(), ex);
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getArtificialPlaytime(String uuid) {
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = this.getSQLConnection();
            ps = conn.prepareStatement("SELECT artificial_playtime FROM play_time WHERE uuid = ?;");
            ps.setString(1, uuid);
            rs = ps.executeQuery();
            if (rs.next()) {
                Long l = rs.getLong("artificial_playtime");
                return l;
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (ps != null) {
                    ps.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionClose(), ex);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUUIDFromNickname(String nickname) {
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = this.getSQLConnection();
            ps = conn.prepareStatement("SELECT uuid FROM play_time WHERE nickname = ? LIMIT 1;");
            ps.setString(1, nickname);
            rs = ps.executeQuery();
            if (rs.next()) {
                String string = rs.getString("uuid");
                return string;
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (ps != null) {
                    ps.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionClose(), ex);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getAllNicknames() {
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<String> nicknames = new ArrayList<String>();
        try {
            conn = this.getSQLConnection();
            ps = conn.prepareStatement("SELECT nickname FROM play_time;");
            rs = ps.executeQuery();
            while (rs.next()) {
                nicknames.add(rs.getString("nickname"));
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (ps != null) {
                    ps.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionClose(), ex);
            }
        }
        return nicknames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePlaytime(String uuid, long newPlaytime) {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.getSQLConnection();
            ps = conn.prepareStatement("UPDATE play_time SET playtime = ? WHERE uuid = ?;");
            ps.setLong(1, newPlaytime);
            ps.setString(2, uuid);
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionClose(), ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateArtificialPlaytime(String uuid, long newArtificialPlaytime) {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.getSQLConnection();
            ps = conn.prepareStatement("UPDATE play_time SET artificial_playtime = ? WHERE uuid = ?;");
            ps.setLong(1, newArtificialPlaytime);
            ps.setString(2, uuid);
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionClose(), ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateNickname(String uuid, String newNickname) {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.getSQLConnection();
            ps = conn.prepareStatement("UPDATE play_time SET nickname = ? WHERE uuid = ?;");
            ps.setString(1, newNickname);
            ps.setString(2, uuid);
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionClose(), ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateUUID(String uuid, String nickname) {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.getSQLConnection();
            ps = conn.prepareStatement("UPDATE play_time SET uuid = ? WHERE nickname = ?;");
            ps.setString(1, uuid);
            ps.setString(2, nickname);
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionClose(), ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean playerExists(String uuid) {
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = this.getSQLConnection();
            ps = conn.prepareStatement("SELECT COUNT(*) FROM play_time WHERE uuid = ?;");
            ps.setString(1, uuid);
            rs = ps.executeQuery();
            if (rs.next()) {
                int count = rs.getInt(1);
                boolean bl = count > 0;
                return bl;
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (ps != null) {
                    ps.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionClose(), ex);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNewPlayer(String uuid, String nickname, long playtime) {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.getSQLConnection();
            ps = conn.prepareStatement("INSERT INTO play_time (uuid, nickname, playtime, artificial_playtime) VALUES (?, ?, ?, ?);");
            ps.setString(1, uuid);
            ps.setString(2, nickname);
            ps.setLong(3, playtime);
            ps.setLong(4, 0L);
            ps.executeUpdate();
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionClose(), ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double getAveragePlaytime() {
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = this.getSQLConnection();
            ps = conn.prepareStatement("SELECT AVG(playtime + artificial_playtime) AS avg_playtime FROM play_time;");
            rs = ps.executeQuery();
            if (rs.next()) {
                Double d = rs.getDouble("avg_playtime");
                return d;
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (ps != null) {
                    ps.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionClose(), ex);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getPercentageOfPlayers(long playtime) {
        Connection conn = null;
        PreparedStatement psTotal = null;
        Statement psGreater = null;
        ResultSet rsTotal = null;
        ResultSet rsGreater = null;
        try {
            conn = this.getSQLConnection();
            psTotal = conn.prepareStatement("SELECT COUNT(*) AS total_players FROM play_time;");
            rsTotal = psTotal.executeQuery();
            psGreater = conn.prepareStatement("SELECT COUNT(*) AS greater_players FROM play_time WHERE (playtime + artificial_playtime) >= ?;");
            psGreater.setLong(1, playtime);
            rsGreater = psGreater.executeQuery();
            if (rsTotal.next() && rsGreater.next()) {
                int totalPlayers = rsTotal.getInt("total_players");
                int greaterPlayers = rsGreater.getInt("greater_players");
                if (totalPlayers > 0) {
                    Object[] objectArray = new Object[]{(double)greaterPlayers * 100.0 / (double)totalPlayers, greaterPlayers, totalPlayers};
                    return objectArray;
                }
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        finally {
            try {
                if (rsTotal != null) {
                    rsTotal.close();
                }
                if (rsGreater != null) {
                    rsGreater.close();
                }
                if (psTotal != null) {
                    psTotal.close();
                }
                if (psGreater != null) {
                    psGreater.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionClose(), ex);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getTopPlayersByPlaytime(int topN) {
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        LinkedHashMap<String, String> topPlayers = new LinkedHashMap<String, String>();
        try {
            conn = this.getSQLConnection();
            ps = conn.prepareStatement("SELECT uuid,nickname FROM play_time ORDER BY (playtime + artificial_playtime) DESC LIMIT ?;");
            ps.setInt(1, topN);
            rs = ps.executeQuery();
            while (rs.next()) {
                String uuid = rs.getString("uuid");
                String nickname = rs.getString("nickname");
                topPlayers.put(uuid, nickname != null ? nickname : uuid);
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionExecute(), ex);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (ps != null) {
                    ps.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionClose(), ex);
            }
        }
        return topPlayers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGoalFromAllUsers(String goalToRemove) {
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = this.getSQLConnection();
            ps = conn.prepareStatement("SELECT uuid, completed_goals FROM play_time WHERE completed_goals IS NOT NULL AND completed_goals != '';");
            rs = ps.executeQuery();
            PreparedStatement updateStmt = conn.prepareStatement("UPDATE play_time SET completed_goals = ? WHERE uuid = ?;");
            while (rs.next()) {
                String uuid = rs.getString("uuid");
                String completedGoals = rs.getString("completed_goals");
                if (completedGoals == null || completedGoals.isEmpty()) continue;
                ArrayList<String> goals = new ArrayList<String>();
                for (String goal2 : completedGoals.split(",")) {
                    String trimmedGoal = goal2.trim();
                    if (trimmedGoal.isEmpty() || trimmedGoal.equals(goalToRemove)) continue;
                    goals.add(trimmedGoal);
                }
                String updatedGoals = goals.stream().map(String::trim).filter(goal -> !goal.isEmpty()).collect(Collectors.joining(","));
                updateStmt.setString(1, updatedGoals);
                updateStmt.setString(2, uuid);
                updateStmt.executeUpdate();
            }
            updateStmt.close();
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, "Error removing goal " + goalToRemove + " from all players: " + ex.getMessage());
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (ps != null) {
                    ps.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionClose(), ex);
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public ArrayList<String> getCompletedGoals(String uuid) {
        String query = "SELECT completed_goals FROM play_time WHERE uuid = ?";
        ArrayList<String> goals = new ArrayList<String>();
        try (Connection conn = this.getSQLConnection();){
            ArrayList<String> arrayList;
            block16: {
                PreparedStatement stmt = conn.prepareStatement(query);
                try {
                    String completedGoals;
                    stmt.setString(1, uuid);
                    ResultSet rs = stmt.executeQuery();
                    if (rs.next() && (completedGoals = rs.getString("completed_goals")) != null && !completedGoals.isEmpty()) {
                        String[] goalsArray;
                        for (String goal : goalsArray = completedGoals.split(",")) {
                            String trimmedGoal = goal.trim();
                            if (trimmedGoal.isEmpty()) continue;
                            goals.add(trimmedGoal);
                        }
                    }
                    arrayList = goals;
                    if (stmt == null) break block16;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return arrayList;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return goals;
        }
    }

    public void updateCompletedGoals(String uuid, ArrayList<String> goals) {
        String updateQuery = "UPDATE play_time SET completed_goals = ? WHERE uuid = ?";
        try (Connection conn = this.getSQLConnection();
             PreparedStatement updateStmt = conn.prepareStatement(updateQuery);){
            String updatedGoals = goals.stream().map(String::trim).filter(goal -> !goal.isEmpty()).collect(Collectors.joining(","));
            updateStmt.setString(1, updatedGoals);
            updateStmt.setString(2, uuid);
            updateStmt.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void close() {
        if (dataSource != null) {
            dataSource.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateGoalName(String oldName, String newName) {
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = this.getSQLConnection();
            ps = conn.prepareStatement("SELECT uuid, completed_goals FROM play_time WHERE completed_goals IS NOT NULL AND completed_goals != '';");
            rs = ps.executeQuery();
            PreparedStatement updateStmt = conn.prepareStatement("UPDATE play_time SET completed_goals = ? WHERE uuid = ?;");
            while (rs.next()) {
                String uuid = rs.getString("uuid");
                String completedGoals = rs.getString("completed_goals");
                if (completedGoals == null || completedGoals.isEmpty()) continue;
                CharSequence[] goals = completedGoals.split(",");
                boolean needsUpdate = false;
                for (int i = 0; i < goals.length; ++i) {
                    if (!goals[i].trim().equals(oldName)) continue;
                    goals[i] = newName;
                    needsUpdate = true;
                }
                if (!needsUpdate) continue;
                String updatedGoals = String.join((CharSequence)",", goals);
                updateStmt.setString(1, updatedGoals);
                updateStmt.setString(2, uuid);
                updateStmt.executeUpdate();
            }
            updateStmt.close();
        }
        catch (SQLException ex) {
            this.plugin.getLogger().log(Level.SEVERE, "Error updating goal name from " + oldName + " to " + newName + ": " + ex.getMessage());
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (ps != null) {
                    ps.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.getLogger().log(Level.SEVERE, Errors.sqlConnectionClose(), ex);
            }
        }
    }

    public void updateLastSeen(String uuid, LocalDateTime lastSeen) {
        try (Connection connection = this.getSQLConnection();
             PreparedStatement ps = connection.prepareStatement("UPDATE play_time SET last_seen = ? WHERE uuid = ?");){
            if (lastSeen != null) {
                LocalDateTime truncated = lastSeen.truncatedTo(ChronoUnit.SECONDS);
                ps.setTimestamp(1, Timestamp.valueOf(truncated));
            } else {
                ps.setNull(1, 93);
            }
            ps.setString(2, uuid);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Error updating last_seen time: " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LocalDateTime getLastSeen(String uuid) {
        try (Connection connection = this.getSQLConnection();
             PreparedStatement ps = connection.prepareStatement("SELECT last_seen FROM play_time WHERE uuid = ?");){
            ps.setString(1, uuid);
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) return null;
            Timestamp timestamp = rs.getTimestamp("last_seen");
            LocalDateTime localDateTime = timestamp != null ? timestamp.toLocalDateTime() : null;
            return localDateTime;
        }
        catch (SQLException e) {
            return null;
        }
    }

    public void updateFirstJoin(String uuid, LocalDateTime firstJoin) {
        try (Connection connection = this.getSQLConnection();
             PreparedStatement ps = connection.prepareStatement("UPDATE play_time SET first_join = ? WHERE uuid = ?");){
            if (firstJoin != null) {
                LocalDateTime truncated = firstJoin.truncatedTo(ChronoUnit.SECONDS);
                ps.setTimestamp(1, Timestamp.valueOf(truncated));
            } else {
                ps.setNull(1, 93);
            }
            ps.setString(2, uuid);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Error updating first_join time: " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LocalDateTime getFirstJoin(String uuid) {
        try (Connection connection = this.getSQLConnection();
             PreparedStatement ps = connection.prepareStatement("SELECT first_join FROM play_time WHERE uuid = ?");){
            ps.setString(1, uuid);
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) return null;
            Timestamp timestamp = rs.getTimestamp("first_join");
            LocalDateTime localDateTime = timestamp != null ? timestamp.toLocalDateTime() : null;
            return localDateTime;
        }
        catch (SQLException e) {
            return null;
        }
    }
}

