/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.Updates;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import me.thegabro.playtimemanager.PlayTimeManager;

public class DatabaseBackupUtility {
    private final PlayTimeManager plugin;
    private static final int BUFFER_SIZE = 1024;

    public DatabaseBackupUtility(PlayTimeManager plugin) {
        this.plugin = plugin;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public File createBackup(String dbName, String readme) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
        String timestamp = dateFormat.format(new Date());
        String backupFileName = "backup_" + timestamp + ".zip";
        File dataFolder = this.plugin.getDataFolder();
        File backupFolder = new File(dataFolder, "backups");
        if (!backupFolder.exists()) {
            backupFolder.mkdirs();
        }
        File backupFile = new File(backupFolder, backupFileName);
        File dbFile = new File(dataFolder, dbName + ".db");
        try (FileOutputStream fos = new FileOutputStream(backupFile);){
            File file;
            try (ZipOutputStream zos = new ZipOutputStream(fos);){
                this.addFileToZip(dbFile, dbName + ".db", zos);
                this.addTextToZip(readme, zos);
                file = backupFile;
            }
            return file;
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Backup creation failed: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    private void addFileToZip(File file, String entryName, ZipOutputStream zos) throws IOException {
        byte[] buffer = new byte[1024];
        try (FileInputStream fis = new FileInputStream(file);){
            int len;
            ZipEntry ze = new ZipEntry(entryName);
            zos.putNextEntry(ze);
            while ((len = fis.read(buffer)) > 0) {
                zos.write(buffer, 0, len);
            }
            zos.closeEntry();
        }
    }

    private void addTextToZip(String content, ZipOutputStream zos) throws IOException {
        ZipEntry ze = new ZipEntry("README.txt");
        zos.putNextEntry(ze);
        zos.write(content.getBytes());
        zos.closeEntry();
    }
}

