/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.Updates;

import me.thegabro.playtimemanager.PlayTimeManager;
import me.thegabro.playtimemanager.Updates.Version304To31Updater;
import me.thegabro.playtimemanager.Updates.Version31to32Updater;
import me.thegabro.playtimemanager.Updates.Version321to33Updater;
import me.thegabro.playtimemanager.updatechecker.UpdateCheckSource;
import me.thegabro.playtimemanager.updatechecker.UpdateChecker;
import me.thegabro.playtimemanager.updatechecker.UserAgentBuilder;
import org.bukkit.Bukkit;

public class UpdateManager {
    private static UpdateManager instance;
    private final PlayTimeManager plugin;
    private UpdateChecker updateChecker;

    private UpdateManager(PlayTimeManager plugin) {
        this.plugin = plugin;
    }

    public static UpdateManager getInstance(PlayTimeManager plugin) {
        if (instance == null) {
            instance = new UpdateManager(plugin);
        }
        return instance;
    }

    public void initialize() {
        this.setupUpdateChecker();
    }

    private void setupUpdateChecker() {
        this.updateChecker = new UpdateChecker(this.plugin, UpdateCheckSource.HANGAR, "TheGaBr0/PlayTimeManager/Release").setUserAgent(new UserAgentBuilder().addPluginNameAndVersion()).checkEveryXHours(24.0).onSuccess((commandSenders, latestVersion) -> {
            this.updateChecker.setDownloadLink("https://hangar.papermc.io/TheGabro/PlayTimeManager/versions/" + latestVersion);
            this.updateChecker.setChangelogLink("https://hangar.papermc.io/TheGabro/PlayTimeManager/versions/" + latestVersion);
        }).checkNow();
    }

    public void performVersionUpdate(String currentVersion, String targetVersion) {
        switch (currentVersion) {
            case "3.1": {
                Bukkit.getServer().getConsoleSender().sendMessage("[\u00a76PlayTime\u00a7eManager\u00a7f]\u00a77 3.1 config version detected, updating it to the latest one...");
                new Version304To31Updater(this.plugin).performUpgrade();
                new Version31to32Updater(this.plugin).performUpgrade();
                new Version321to33Updater(this.plugin).performUpgrade();
                break;
            }
            case "3.2": {
                Bukkit.getServer().getConsoleSender().sendMessage("[\u00a76PlayTime\u00a7eManager\u00a7f]\u00a77 3.2 config version detected, updating it to the latest one...");
                new Version31to32Updater(this.plugin).performUpgrade();
                new Version321to33Updater(this.plugin).performUpgrade();
                break;
            }
            case "3.3": {
                Bukkit.getServer().getConsoleSender().sendMessage("[\u00a76PlayTime\u00a7eManager\u00a7f]\u00a77 3.3 config version detected, updating it to the latest one...");
                new Version321to33Updater(this.plugin).performUpgrade();
                break;
            }
            default: {
                this.plugin.getLogger().severe("[\u00a76PlayTime\u00a7eManager\u00a7f]\u00a77 Unknown config version detected! Something may break!");
                return;
            }
        }
        Bukkit.getServer().getConsoleSender().sendMessage("[\u00a76PlayTime\u00a7eManager\u00a7f]\u00a77 Update completed! Latest version: \u00a7r" + targetVersion);
    }
}

