/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.Updates;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.logging.Level;
import me.thegabro.playtimemanager.Configuration;
import me.thegabro.playtimemanager.PlayTimeManager;
import me.thegabro.playtimemanager.SQLiteDB.SQLite;
import me.thegabro.playtimemanager.Updates.DatabaseBackupUtility;
import org.bukkit.configuration.file.YamlConfiguration;

public class Version31to32Updater {
    private final PlayTimeManager plugin;
    private final SQLite database;

    public Version31to32Updater(PlayTimeManager plugin) {
        this.plugin = plugin;
        this.database = (SQLite)plugin.getDatabase();
    }

    public void performUpgrade() {
        this.handleDuplicates();
        this.updateUniqueDBEntries();
        this.addLastSeenColumn();
        this.recreateConfigFile();
    }

    private String mergeGoals(String goals) {
        if (goals == null || goals.isEmpty()) {
            return "";
        }
        LinkedHashSet<String> uniqueGoals = new LinkedHashSet<String>();
        for (String goalList : goals.split(",")) {
            String goal = goalList.trim();
            if (goal.isEmpty()) continue;
            uniqueGoals.add(goal);
        }
        return String.join((CharSequence)",", uniqueGoals);
    }

    private void handleDuplicates() {
        try (Connection connection = this.database.getSQLConnection();){
            connection.setAutoCommit(false);
            DatabaseBackupUtility backupUtility = new DatabaseBackupUtility(this.plugin);
            backupUtility.createBackup("play_time", this.generateReadmeContent());
            try (Statement s = connection.createStatement();){
                String mergedGoals;
                String allGoals;
                long artificialPlaytime;
                long playtime;
                String nickname;
                String uuid;
                s.executeUpdate("CREATE TEMPORARY TABLE temp_merged_entries (uuid VARCHAR(32) NOT NULL,nickname VARCHAR(32) NOT NULL,playtime BIGINT NOT NULL,artificial_playtime BIGINT NOT NULL,completed_goals TEXT DEFAULT '')");
                s.executeUpdate("CREATE INDEX idx_temp_uuid ON temp_merged_entries(uuid)");
                ResultSet rs = s.executeQuery("SELECT uuid, MAX(nickname) as nickname, SUM(playtime) as total_playtime, SUM(artificial_playtime) as total_artificial_playtime, GROUP_CONCAT(completed_goals) as all_goals FROM play_time GROUP BY uuid");
                PreparedStatement insertStmt = connection.prepareStatement("INSERT INTO temp_merged_entries (uuid, nickname, playtime, artificial_playtime, completed_goals) VALUES (?, ?, ?, ?, ?)");
                while (rs.next()) {
                    uuid = rs.getString("uuid");
                    nickname = rs.getString("nickname");
                    playtime = rs.getLong("total_playtime");
                    artificialPlaytime = rs.getLong("total_artificial_playtime");
                    allGoals = rs.getString("all_goals");
                    mergedGoals = this.mergeGoals(allGoals);
                    insertStmt.setString(1, uuid);
                    insertStmt.setString(2, nickname);
                    insertStmt.setLong(3, playtime);
                    insertStmt.setLong(4, artificialPlaytime);
                    insertStmt.setString(5, mergedGoals);
                    insertStmt.executeUpdate();
                }
                rs.close();
                insertStmt.close();
                s.executeUpdate("CREATE TABLE final_merged_entries (uuid VARCHAR(32) NOT NULL,nickname VARCHAR(32) NOT NULL,playtime BIGINT NOT NULL,artificial_playtime BIGINT NOT NULL,completed_goals TEXT DEFAULT '')");
                rs = s.executeQuery("SELECT MAX(uuid) as uuid, nickname, SUM(playtime) as total_playtime, SUM(artificial_playtime) as total_artificial_playtime, GROUP_CONCAT(completed_goals) as all_goals FROM temp_merged_entries GROUP BY nickname");
                insertStmt = connection.prepareStatement("INSERT INTO final_merged_entries (uuid, nickname, playtime, artificial_playtime, completed_goals) VALUES (?, ?, ?, ?, ?)");
                while (rs.next()) {
                    uuid = rs.getString("uuid");
                    nickname = rs.getString("nickname");
                    playtime = rs.getLong("total_playtime");
                    artificialPlaytime = rs.getLong("total_artificial_playtime");
                    allGoals = rs.getString("all_goals");
                    mergedGoals = this.mergeGoals(allGoals);
                    insertStmt.setString(1, uuid);
                    insertStmt.setString(2, nickname);
                    insertStmt.setLong(3, playtime);
                    insertStmt.setLong(4, artificialPlaytime);
                    insertStmt.setString(5, mergedGoals);
                    insertStmt.executeUpdate();
                }
                ResultSet countRs = s.executeQuery("SELECT COUNT(*) as total FROM play_time");
                int originalCount = countRs.next() ? countRs.getInt("total") : 0;
                countRs.close();
                countRs = s.executeQuery("SELECT COUNT(*) as total FROM final_merged_entries");
                int finalCount = countRs.next() ? countRs.getInt("total") : 0;
                countRs.close();
                this.plugin.getLogger().info(String.format("Merged %d entries into %d unique entries", originalCount, finalCount));
                s.executeUpdate("DELETE FROM play_time");
                s.executeUpdate("INSERT INTO play_time SELECT * FROM final_merged_entries");
                s.executeUpdate("DROP TABLE IF EXISTS temp_merged_entries");
                s.executeUpdate("DROP TABLE IF EXISTS final_merged_entries");
                connection.commit();
            }
            catch (SQLException e) {
                connection.rollback();
                throw e;
            }
            finally {
                connection.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to handle duplicates: " + e.getMessage(), e);
        }
    }

    public void updateUniqueDBEntries() {
        try (Connection connection = this.database.getSQLConnection();){
            connection.setAutoCommit(false);
            try (Statement s = connection.createStatement();){
                s.executeUpdate("CREATE TABLE play_time_new (uuid VARCHAR(32) NOT NULL UNIQUE,nickname VARCHAR(32) NOT NULL UNIQUE,playtime BIGINT NOT NULL,artificial_playtime BIGINT NOT NULL,completed_goals TEXT DEFAULT '',PRIMARY KEY (uuid))");
                s.executeUpdate("INSERT INTO play_time_new SELECT * FROM play_time");
                s.executeUpdate("DROP TABLE play_time");
                s.executeUpdate("ALTER TABLE play_time_new RENAME TO play_time");
                connection.commit();
            }
            catch (SQLException e) {
                connection.rollback();
                throw e;
            }
            finally {
                connection.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to add unique constraints: " + e.getMessage());
        }
    }

    public void addLastSeenColumn() {
        try (Connection connection = this.database.getSQLConnection();){
            connection.setAutoCommit(false);
            try (Statement s = connection.createStatement();){
                s.executeUpdate("ALTER TABLE play_time ADD COLUMN last_seen DATETIME DEFAULT NULL");
                connection.commit();
            }
            catch (SQLException e) {
                connection.rollback();
                throw e;
            }
            finally {
                connection.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to alter table: " + e.getMessage());
        }
    }

    private void recreateConfigFile() {
        File configFile = new File(this.plugin.getDataFolder(), "config.yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
        String playtimeSelfMessage = config.getString("playtime-self-message");
        String playtimeOthersMessage = config.getString("playtime-others-message");
        long goalsCheckRate = config.getLong("goal-check-rate");
        boolean goalsCheckVerbose = config.getBoolean("goal-check-verbose");
        configFile.delete();
        Configuration newConfig = new Configuration(this.plugin.getDataFolder(), "config", true, true);
        newConfig.setPlaytimeSelfMessage(playtimeSelfMessage);
        newConfig.setPlaytimeOthersMessage(playtimeOthersMessage);
        newConfig.setGoalsCheckRate(goalsCheckRate);
        newConfig.setGoalsCheckVerbose(goalsCheckVerbose);
        newConfig.reload();
        this.plugin.setConfiguration(newConfig);
    }

    private String generateReadmeContent() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
        String timestamp = dateFormat.format(new Date());
        StringBuilder readme = new StringBuilder();
        readme.append("PlayTimeManager Database Backup\n");
        readme.append("============================\n\n");
        readme.append("!!! IMPORTANT VERSION UPGRADE NOTICE !!!\n");
        readme.append("=====================================\n");
        readme.append("This backup was automatically created during the upgrade from version 3.1 to 3.2\n");
        readme.append("This is a critical backup as the upgrade transforms the database adding strict rules regardingduplicates for the safeguard of data's integrity.\n\n");
        readme.append("Backup Information:\n");
        readme.append("------------------\n");
        readme.append("Backup created: ").append(timestamp).append("\n");
        readme.append("Restore Instructions:\n");
        readme.append("-------------------\n");
        readme.append("!!! CRITICAL: The restored database file MUST be named 'play_time.db' !!!\n");
        readme.append("If the file is not named exactly 'play_time.db', the plugin will not load it.\n\n");
        readme.append("Steps to restore:\n");
        readme.append("1. Stop your server\n");
        readme.append("2. Delete the current 'play_time.db'\n");
        readme.append("3. Extract the database.db file from this backup zip\n");
        readme.append("4. Rename the extracted file to 'play_time.db'\n");
        readme.append("5. Place it in your plugin's data folder\n");
        readme.append("6. Start your server\n\n");
        readme.append("Warning: This backup contains data from before the data integrity changes.\n");
        readme.append("Restoring this backup will revert your data to the 3.1 format.\n");
        return readme.toString();
    }
}

