/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.Updates;

import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import me.thegabro.playtimemanager.Configuration;
import me.thegabro.playtimemanager.PlayTimeManager;
import me.thegabro.playtimemanager.SQLiteDB.SQLite;
import me.thegabro.playtimemanager.Updates.DatabaseBackupUtility;
import org.bukkit.configuration.file.YamlConfiguration;

public class Version321to33Updater {
    private final PlayTimeManager plugin;
    private final SQLite database;

    public Version321to33Updater(PlayTimeManager plugin) {
        this.plugin = plugin;
        this.database = (SQLite)plugin.getDatabase();
    }

    public void performUpgrade() {
        this.addFirstJoinColumn();
        this.recreateConfigFile();
    }

    public void addFirstJoinColumn() {
        DatabaseBackupUtility backupUtility = new DatabaseBackupUtility(this.plugin);
        backupUtility.createBackup("play_time", this.generateReadmeContent());
        try (Connection connection = this.database.getSQLConnection();){
            connection.setAutoCommit(false);
            try (Statement s = connection.createStatement();){
                s.executeUpdate("ALTER TABLE play_time ADD COLUMN first_join DATETIME DEFAULT NULL");
                connection.commit();
            }
            catch (SQLException e) {
                connection.rollback();
                throw e;
            }
            finally {
                connection.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Failed to alter table: " + e.getMessage());
        }
    }

    private void recreateConfigFile() {
        File configFile = new File(this.plugin.getDataFolder(), "config.yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
        String playtimeSelfMessage = config.getString("playtime-self-message");
        String playtimeOthersMessage = config.getString("playtime-others-message");
        long goalsCheckRate = config.getLong("goal-check-rate");
        boolean goalsCheckVerbose = config.getBoolean("goal-check-verbose");
        String permissionsManagerPlugin = config.getString("permissions-manager-plugin");
        String datetimeFormat = config.getString("datetime-format");
        configFile.delete();
        Configuration newConfig = new Configuration(this.plugin.getDataFolder(), "config", true, true);
        newConfig.setPlaytimeSelfMessage(playtimeSelfMessage);
        newConfig.setPlaytimeOthersMessage(playtimeOthersMessage);
        newConfig.setGoalsCheckRate(goalsCheckRate);
        newConfig.setGoalsCheckVerbose(goalsCheckVerbose);
        newConfig.setPermissionsManagerPlugin(permissionsManagerPlugin);
        newConfig.setDateTimeFormat(datetimeFormat);
        newConfig.reload();
        this.plugin.setConfiguration(newConfig);
    }

    private String generateReadmeContent() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
        String timestamp = dateFormat.format(new Date());
        StringBuilder readme = new StringBuilder();
        readme.append("PlayTimeManager Database Backup\n");
        readme.append("============================\n\n");
        readme.append("!!! IMPORTANT VERSION UPGRADE NOTICE !!!\n");
        readme.append("=====================================\n");
        readme.append("This backup was automatically created during the upgrade from version 3.2.1 to 3.3\n");
        readme.append("This is a critical backup as the upgrade adds a new first join field.\n\n");
        readme.append("Backup Information:\n");
        readme.append("------------------\n");
        readme.append("Backup created: ").append(timestamp).append("\n");
        readme.append("Restore Instructions:\n");
        readme.append("-------------------\n");
        readme.append("!!! CRITICAL: The restored database file MUST be named 'play_time.db' !!!\n");
        readme.append("If the file is not named exactly 'play_time.db', the plugin will not load it.\n\n");
        readme.append("Steps to restore:\n");
        readme.append("1. Stop your server\n");
        readme.append("2. Delete the current 'play_time.db'\n");
        readme.append("3. Extract the database.db file from this backup zip\n");
        readme.append("4. Rename the extracted file to 'play_time.db'\n");
        readme.append("5. Place it in your plugin's data folder\n");
        readme.append("6. Start your server\n\n");
        readme.append("Warning: This backup contains data from before the data integrity changes.\n");
        readme.append("Restoring this backup will revert your data to the 3.3 format.\n");
        return readme.toString();
    }
}

