/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.Users;

import java.time.LocalDateTime;
import java.util.ArrayList;
import me.thegabro.playtimemanager.Goals.GoalsManager;
import me.thegabro.playtimemanager.PlayTimeManager;
import me.thegabro.playtimemanager.SQLiteDB.PlayTimeDatabase;
import org.bukkit.Statistic;
import org.bukkit.entity.Player;

public class DBUser {
    protected String uuid;
    protected String nickname;
    protected long DBplaytime;
    protected long artificialPlaytime;
    protected static final PlayTimeManager plugin = PlayTimeManager.getInstance();
    protected long fromServerOnJoinPlayTime;
    protected ArrayList<String> completedGoals;
    protected static PlayTimeDatabase db = plugin.getDatabase();
    protected LocalDateTime lastSeen;
    protected LocalDateTime firstJoin;
    protected final GoalsManager goalsManager = GoalsManager.getInstance();

    private DBUser(String uuid, String nickname, long playtime, long artificialPlaytime, ArrayList<String> completedGoals, LocalDateTime lastSeen, LocalDateTime firstJoin) {
        this.uuid = uuid;
        this.nickname = nickname;
        this.DBplaytime = playtime;
        this.artificialPlaytime = artificialPlaytime;
        this.completedGoals = completedGoals;
        this.fixGhostGoals();
        this.lastSeen = lastSeen;
        this.firstJoin = firstJoin;
    }

    public DBUser(Player p) {
        this.fromServerOnJoinPlayTime = p.getStatistic(Statistic.PLAY_ONE_MINUTE);
        this.uuid = p.getUniqueId().toString();
        this.nickname = p.getName();
        this.userMapping();
        this.DBplaytime = db.getPlaytime(this.uuid);
        this.artificialPlaytime = db.getArtificialPlaytime(this.uuid);
        this.completedGoals = db.getCompletedGoals(this.uuid);
        this.fixGhostGoals();
        this.lastSeen = db.getLastSeen(this.uuid);
        this.firstJoin = db.getFirstJoin(this.uuid);
        if (this.firstJoin == null) {
            this.firstJoin = LocalDateTime.now();
            db.updateFirstJoin(this.uuid, this.firstJoin);
        }
    }

    protected static DBUser fromUUID(String uuid) {
        String nickname = db.getNickname(uuid);
        if (uuid == null) {
            return null;
        }
        long playtime = db.getPlaytime(uuid);
        long artificialPlaytime = db.getArtificialPlaytime(uuid);
        ArrayList<String> completedGoals = db.getCompletedGoals(uuid);
        LocalDateTime lastSeen = db.getLastSeen(uuid);
        LocalDateTime firstJoin = db.getFirstJoin(uuid);
        return new DBUser(uuid, nickname, playtime, artificialPlaytime, completedGoals, lastSeen, firstJoin);
    }

    public void reset() {
        this.DBplaytime = 0L;
        this.artificialPlaytime = 0L;
        this.fromServerOnJoinPlayTime = 0L;
        this.lastSeen = null;
        this.firstJoin = null;
        this.completedGoals.clear();
        db.updatePlaytime(this.uuid, 0L);
        db.updateArtificialPlaytime(this.uuid, 0L);
        db.updateCompletedGoals(this.uuid, this.completedGoals);
        db.updateLastSeen(this.uuid, this.lastSeen);
        db.updateFirstJoin(this.uuid, this.firstJoin);
    }

    public LocalDateTime getFirstJoin() {
        return this.firstJoin;
    }

    public LocalDateTime getLastSeen() {
        return this.lastSeen;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getNickname() {
        return this.nickname;
    }

    public long getPlaytime() {
        return this.DBplaytime + this.artificialPlaytime;
    }

    public long getArtificialPlaytime() {
        return this.artificialPlaytime;
    }

    public void setArtificialPlaytime(long artificialPlaytime) {
        this.artificialPlaytime = artificialPlaytime;
        db.updateArtificialPlaytime(this.uuid, artificialPlaytime);
    }

    public ArrayList<String> getCompletedGoals() {
        return this.completedGoals;
    }

    public boolean hasCompletedGoal(String goalName) {
        return this.completedGoals.contains(goalName);
    }

    public void markGoalAsCompleted(String goalName) {
        this.completedGoals.add(goalName);
        db.updateCompletedGoals(this.uuid, this.completedGoals);
    }

    public void unmarkGoalAsCompleted(String goalName) {
        this.completedGoals.remove(goalName);
        db.updateCompletedGoals(this.uuid, this.completedGoals);
    }

    private void fixGhostGoals() {
        ArrayList<String> goalsToRemove = new ArrayList<String>();
        for (String completedGoal : this.completedGoals) {
            if (this.goalsManager.getGoal(completedGoal) != null) continue;
            goalsToRemove.add(completedGoal);
        }
        for (String goalToRemove : goalsToRemove) {
            this.unmarkGoalAsCompleted(goalToRemove);
        }
    }

    private void userMapping() {
        boolean uuidExists = db.playerExists(this.uuid);
        String existingNickname = uuidExists ? db.getNickname(this.uuid) : null;
        String existingUUID = db.getUUIDFromNickname(this.nickname);
        if (uuidExists) {
            if (!this.nickname.equals(existingNickname)) {
                db.updateNickname(this.uuid, this.nickname);
            }
        } else if (existingUUID != null) {
            db.updateUUID(this.uuid, this.nickname);
        } else {
            db.addNewPlayer(this.uuid, this.nickname, this.fromServerOnJoinPlayTime);
        }
    }
}

