/*
 * Decompiled with CFR 0.152.
 */
package me.thegabro.playtimemanager.Users;

import java.time.LocalDateTime;
import me.thegabro.playtimemanager.Users.DBUser;
import org.bukkit.Statistic;
import org.bukkit.entity.Player;

public class OnlineUser
extends DBUser {
    private final Player p;

    public OnlineUser(Player p) {
        super(p);
        this.p = p;
        this.fromServerOnJoinPlayTime = p.getStatistic(Statistic.PLAY_ONE_MINUTE);
    }

    private long getCachedPlayTime() {
        return this.DBplaytime + ((long)this.p.getStatistic(Statistic.PLAY_ONE_MINUTE) - this.fromServerOnJoinPlayTime);
    }

    public void updateDB() {
        db.updatePlaytime(this.uuid, this.getCachedPlayTime());
    }

    public void updateLastSeen() {
        this.lastSeen = LocalDateTime.now();
        db.updateLastSeen(this.uuid, this.lastSeen);
    }

    @Override
    public long getPlaytime() {
        return this.getCachedPlayTime() + this.artificialPlaytime;
    }

    @Override
    public LocalDateTime getLastSeen() {
        return LocalDateTime.now();
    }

    public void refreshFromServerOnJoinPlayTime() {
        this.fromServerOnJoinPlayTime = this.p.getStatistic(Statistic.PLAY_ONE_MINUTE);
    }

    @Override
    public void reset() {
        this.DBplaytime = 0L;
        this.artificialPlaytime = 0L;
        this.fromServerOnJoinPlayTime = this.p.getStatistic(Statistic.PLAY_ONE_MINUTE);
        this.lastSeen = null;
        this.firstJoin = null;
        this.completedGoals.clear();
        db.updatePlaytime(this.uuid, 0L);
        db.updateArtificialPlaytime(this.uuid, 0L);
        db.updateCompletedGoals(this.uuid, this.completedGoals);
        db.updateLastSeen(this.uuid, this.lastSeen);
        db.updateFirstJoin(this.uuid, this.firstJoin);
    }
}

