/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enhancedanvils.client.screen.widget;

import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class FormatButton
extends Button {
    private final ChatFormatting chatFormatting;

    protected FormatButton(int x, int y, int width, int height, Component message, Button.OnPress onPress, Button.CreateNarration createNarration, ChatFormatting chatFormatting) {
        super(x, y, width, height, message, onPress, createNarration);
        this.chatFormatting = chatFormatting;
    }

    public FormatButton(Builder builder) {
        this(builder.x, builder.y, builder.width, builder.height, builder.message, builder.onPress, builder.createNarration, builder.formatting);
        this.setTooltip(builder.tooltip);
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Integer color;
        Minecraft minecraft = Minecraft.getInstance();
        guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, SPRITES.get(this.active, this.isHoveredOrFocused()), this.getX(), this.getY(), this.getWidth(), this.getHeight());
        if (this.chatFormatting.isColor() && (color = this.chatFormatting.getColor()) != null) {
            color = !this.isActive() ? Integer.valueOf(ARGB.color((int)120, (int)ARGB.red((int)color), (int)ARGB.green((int)color), (int)ARGB.blue((int)color))) : Integer.valueOf(ARGB.opaque((int)color));
            guiGraphics.fill(this.getX() + 2, this.getY() + 2, this.getX() + this.getWidth() - 2, this.getY() + this.getHeight() - 2, color.intValue());
        }
        int i = this.active ? 0xFFFFFF : 0xA0A0A0;
        this.renderString(guiGraphics, minecraft.font, i | Mth.ceil((float)(this.alpha * 255.0f)) << 24);
    }

    static /* synthetic */ Button.CreateNarration access$000() {
        return DEFAULT_NARRATION;
    }

    public static class Builder {
        private final Component message;
        private final ChatFormatting formatting;
        private final Button.OnPress onPress;
        @Nullable
        private Tooltip tooltip;
        private int x;
        private int y;
        private int width = 150;
        private int height = 20;
        private Button.CreateNarration createNarration = FormatButton.access$000();

        public Builder(Component message, ChatFormatting formatting, Button.OnPress onPress) {
            this.message = message;
            this.formatting = formatting;
            this.onPress = onPress;
        }

        public Builder pos(int x, int y) {
            this.x = x;
            this.y = y;
            return this;
        }

        public Builder width(int width) {
            this.width = width;
            return this;
        }

        public Builder size(int width, int height) {
            this.width = width;
            this.height = height;
            return this;
        }

        public Builder bounds(int x, int y, int width, int height) {
            return this.pos(x, y).size(width, height);
        }

        public Builder tooltip(@Nullable Tooltip tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        public Builder createNarration(Button.CreateNarration createNarration) {
            this.createNarration = createNarration;
            return this;
        }

        public FormatButton build() {
            return this.build(FormatButton::new);
        }

        public FormatButton build(Function<Builder, FormatButton> builder) {
            return builder.apply(this);
        }
    }
}

