/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enhancedanvils.client.screen.widget;

import java.util.function.Function;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class TypeButton<T extends Enum<T>>
extends Button {
    private final T type;

    protected TypeButton(int x, int y, int width, int height, Component message, Button.OnPress onPress, Button.CreateNarration createNarration, T type) {
        super(x, y, width, height, message, onPress, createNarration);
        this.type = type;
    }

    T getType() {
        return this.type;
    }

    public TypeButton(Builder<T> builder) {
        this(builder.x, builder.y, builder.width, builder.height, builder.message, builder.onPress, builder.createNarration, builder.type);
        this.setTooltip(builder.tooltip);
    }

    static /* synthetic */ Button.CreateNarration access$000() {
        return DEFAULT_NARRATION;
    }

    public static class Builder<T extends Enum<T>> {
        private final Component message;
        private final T type;
        private final Button.OnPress onPress;
        @Nullable
        private Tooltip tooltip;
        private int x;
        private int y;
        private int width = 150;
        private int height = 20;
        private Button.CreateNarration createNarration = TypeButton.access$000();

        public Builder(Component message, T type, Button.OnPress onPress) {
            this.message = message;
            this.type = type;
            this.onPress = onPress;
        }

        public Builder<T> pos(int x, int y) {
            this.x = x;
            this.y = y;
            return this;
        }

        public Builder<T> width(int width) {
            this.width = width;
            return this;
        }

        public Builder<T> size(int width, int height) {
            this.width = width;
            this.height = height;
            return this;
        }

        public Builder<T> bounds(int x, int y, int width, int height) {
            return this.pos(x, y).size(width, height);
        }

        public Builder<T> tooltip(@Nullable Tooltip tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        public Builder<T> createNarration(Button.CreateNarration createNarration) {
            this.createNarration = createNarration;
            return this;
        }

        public TypeButton<T> build() {
            return this.build(TypeButton::new);
        }

        public TypeButton<T> build(Function<Builder<T>, TypeButton<T>> builder) {
            return builder.apply(this);
        }
    }
}

