/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enhancedanvils.client.screen;

import com.mrbysco.enhancedanvils.client.StringRenderHelper;
import com.mrbysco.enhancedanvils.client.screen.widget.ComponentEditBox;
import com.mrbysco.enhancedanvils.client.screen.widget.FormatButton;
import com.mrbysco.enhancedanvils.client.screen.widget.TypeButton;
import com.mrbysco.enhancedanvils.util.TextFont;
import com.mrbysco.enhancedanvils.util.TextHelper;
import com.mrbysco.enhancedanvils.util.TextLore;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AnvilScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.ARGB;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AnvilMenu;

public class ExtendedAnvilScreen
extends AnvilScreen {
    private final List<ChatFormatting> formats = List.of(ChatFormatting.BLACK, ChatFormatting.DARK_BLUE, ChatFormatting.DARK_GREEN, ChatFormatting.DARK_AQUA, ChatFormatting.DARK_RED, ChatFormatting.DARK_PURPLE, ChatFormatting.GOLD, ChatFormatting.GRAY, ChatFormatting.DARK_GRAY, ChatFormatting.BLUE, ChatFormatting.GREEN, ChatFormatting.AQUA, ChatFormatting.RED, ChatFormatting.LIGHT_PURPLE, ChatFormatting.YELLOW, ChatFormatting.WHITE, ChatFormatting.OBFUSCATED, ChatFormatting.BOLD, ChatFormatting.STRIKETHROUGH, ChatFormatting.UNDERLINE, ChatFormatting.ITALIC, ChatFormatting.RESET);
    private final List<TextFont> fonts = List.of(TextFont.values());
    private final List<TextLore> lores = List.of(TextLore.values());
    private final FormatButton[] formattingButtons = new FormatButton[this.formats.size()];
    private final TypeButton[] fontButtons = new TypeButton[this.fonts.size()];
    private final TypeButton[] loreButtons = new TypeButton[this.lores.size()];
    private Button menuButton;
    private boolean buttonsVisible = false;

    public ExtendedAnvilScreen(AnvilMenu menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title);
    }

    protected void subInit() {
        int i;
        MutableComponent name;
        int centerWidth = (this.width - this.imageWidth) / 2;
        int centerHeight = (this.height - this.imageHeight) / 2;
        this.name = new ComponentEditBox(this.font, centerWidth + 62, centerHeight + 24, 103, 12, (Component)Component.translatable((String)"container.repair"));
        this.name.setCanLoseFocus(false);
        this.name.setTextColor(-1);
        this.name.setTextColorUneditable(-1);
        this.name.setBordered(false);
        this.name.setMaxLength(50);
        this.name.setResponder(arg_0 -> ((ExtendedAnvilScreen)this).onNameChanged(arg_0));
        this.name.setValue("");
        this.addRenderableWidget((GuiEventListener)this.name);
        this.name.setEditable(((AnvilMenu)this.menu).getSlot(0).hasItem());
        this.menuButton = new Button.Builder((Component)Component.literal((String)"\u2630"), button -> {
            this.buttonsVisible = !this.buttonsVisible;
            this.name.setFocused(true);
        }).bounds(centerWidth + 4, centerHeight + 4, 16, 16).build();
        this.menuButton.setTooltip(Tooltip.create((Component)Component.literal((String)"Show/Hide Formatting Options")));
        this.addRenderableWidget((GuiEventListener)this.menuButton);
        for (int i2 = 0; i2 < this.formats.size(); ++i2) {
            ChatFormatting format = this.formats.get(i2);
            int xPos = centerWidth - 76 + i2 % 4 * 18;
            int yPos = centerHeight + 4 + i2 / 4 * 18;
            if (i2 >= 20) {
                xPos += 18;
            }
            name = Component.empty();
            switch (format) {
                case OBFUSCATED: {
                    name = Component.literal((String)"O").withStyle(ChatFormatting.OBFUSCATED);
                    break;
                }
                case BOLD: {
                    name = Component.literal((String)"B").withStyle(ChatFormatting.BOLD);
                    break;
                }
                case STRIKETHROUGH: {
                    name = Component.literal((String)"ab").withStyle(ChatFormatting.STRIKETHROUGH);
                    break;
                }
                case UNDERLINE: {
                    name = Component.literal((String)"U").withStyle(ChatFormatting.UNDERLINE);
                    break;
                }
                case ITALIC: {
                    name = Component.literal((String)"I").withStyle(ChatFormatting.ITALIC);
                    break;
                }
                case RESET: {
                    name = Component.literal((String)"\ud83d\uddd8");
                }
            }
            this.formattingButtons[i2] = new FormatButton.Builder((Component)name, format, button -> {
                if (this.name.isEditable()) {
                    this.name.insertText(format.toString());
                }
                this.setFocused((GuiEventListener)this.name);
            }).bounds(xPos, yPos, 16, 16).build();
            this.formattingButtons[i2].setTooltip(Tooltip.create((Component)Component.literal((String)format.getName())));
            this.formattingButtons[i2].active = false;
            this.formattingButtons[i2].visible = false;
            this.addRenderableWidget((GuiEventListener)this.formattingButtons[i2]);
        }
        int xPos = centerWidth + this.imageWidth + 4;
        int yPos = centerHeight - 14;
        for (i = 0; i < this.fonts.size(); ++i) {
            TextFont fontType = this.fonts.get(i);
            name = Component.literal((String)fontType.getName()).withStyle(style -> style.withFont(fontType.getLocation()));
            this.fontButtons[i] = new TypeButton.Builder<TextFont>((Component)name, fontType, button -> {
                if (this.name.isEditable()) {
                    String currentText = this.name.getValue();
                    String strippedText = TextFont.stripFormatting(currentText);
                    if (strippedText != null && strippedText.length() >= 2) {
                        String firstTwo = strippedText.substring(0, 2);
                        TextLore lore = TextLore.getFromString(firstTwo);
                        if (lore != null) {
                            this.name.setValue(lore.toString() + String.valueOf((Object)fontType) + strippedText.substring(2));
                            this.setFocused((GuiEventListener)this.name);
                        } else {
                            this.name.setValue(String.valueOf((Object)fontType) + strippedText);
                        }
                    } else {
                        this.name.setValue(String.valueOf((Object)fontType) + strippedText);
                    }
                    this.setFocused((GuiEventListener)this.name);
                }
            }).bounds(xPos, yPos += 18, 48, 16).build();
            this.fontButtons[i].setTooltip(Tooltip.create((Component)Component.literal((String)fontType.getName())));
            this.fontButtons[i].active = false;
            this.fontButtons[i].visible = false;
            this.addRenderableWidget((GuiEventListener)this.fontButtons[i]);
        }
        yPos += 8;
        for (i = 0; i < this.lores.size(); ++i) {
            TextLore lore = this.lores.get(i);
            name = Component.literal((String)("Lore " + lore.getLine())).withStyle(style -> style.withColor(ChatFormatting.GRAY));
            this.loreButtons[i] = new TypeButton.Builder<TextLore>((Component)name, lore, button -> {
                if (this.name.isEditable()) {
                    String currentText = this.name.getValue();
                    String strippedText = TextLore.stripFormatting(currentText);
                    this.name.setValue(String.valueOf((Object)lore) + strippedText);
                }
                this.setFocused((GuiEventListener)this.name);
            }).bounds(xPos, yPos += 18, 48, 16).build();
            this.loreButtons[i].setTooltip(Tooltip.create((Component)Component.literal((String)("Add to " + name.getString()))));
            this.loreButtons[i].active = false;
            this.loreButtons[i].visible = false;
            this.addRenderableWidget((GuiEventListener)this.loreButtons[i]);
        }
    }

    protected void containerTick() {
        super.containerTick();
        if (this.buttonsVisible) {
            this.setButtonsVisible(true, this.formattingButtons, this.fontButtons, this.loreButtons);
            this.setButtonsActive(this.name.isEditable(), this.formattingButtons, this.fontButtons, this.loreButtons);
        } else {
            this.setButtonsVisible(false, this.formattingButtons, this.fontButtons, this.loreButtons);
            this.setButtonsActive(false, this.formattingButtons, this.fontButtons, this.loreButtons);
        }
    }

    private void setButtonsVisible(boolean visible, Button[] ... buttonArrays) {
        Button[][] buttonArray = buttonArrays;
        int n = buttonArray.length;
        for (int i = 0; i < n; ++i) {
            Button[] array;
            for (Button button : array = buttonArray[i]) {
                button.visible = visible;
            }
        }
    }

    private void setButtonsActive(boolean visible, Button[] ... buttonArrays) {
        Button[][] buttonArray = buttonArrays;
        int n = buttonArray.length;
        for (int i = 0; i < n; ++i) {
            Button[] array;
            for (Button button : array = buttonArray[i]) {
                button.active = visible;
            }
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        EditBox editBox;
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        if (this.buttonsVisible && ((AnvilMenu)this.menu).getSlot(0).hasItem() && (editBox = this.name) instanceof ComponentEditBox) {
            ComponentEditBox box = (ComponentEditBox)editBox;
            if (!box.isVisible()) {
                return;
            }
            Component adjustedValue = TextHelper.changeFont(box.getFinalValue());
            int n = box.getX() - 58;
            int n2 = box.getY() - 40;
            Objects.requireNonNull(this.font);
            TooltipRenderUtil.renderTooltipBackground((GuiGraphics)guiGraphics, (int)n, (int)n2, (int)168, (int)9, null);
            StringRenderHelper.drawScrollingString(guiGraphics, this.font, adjustedValue, box.getX() - 58, box.getX() + 110, box.getY() - 40, ARGB.opaque((int)-1));
        }
    }
}

