/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enhancedanvils.util;

import java.util.Locale;
import java.util.regex.Pattern;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.Nullable;

public enum TextFont implements StringRepresentable
{
    DEFAULT("DEFAULT", 'w', ResourceLocation.withDefaultNamespace((String)"default")),
    UNIFORM("UNIFORM", 'y', ResourceLocation.withDefaultNamespace((String)"uniform")),
    ALT("ENCHANTMENT", 'x', ResourceLocation.withDefaultNamespace((String)"alt")),
    ILLAGERALT("ILLAGER", 'z', ResourceLocation.withDefaultNamespace((String)"illageralt"));

    private static final Pattern FORMATTING_PATTERN;
    private final String name;
    private final String toString;
    private final ResourceLocation location;

    private TextFont(String name, char code, ResourceLocation location) {
        this.name = name;
        this.toString = "\u00a7" + code;
        this.location = location;
    }

    public String getName() {
        return this.name.toLowerCase(Locale.ROOT);
    }

    public ResourceLocation getLocation() {
        return this.location;
    }

    public String toString() {
        return this.toString;
    }

    public String getSerializedName() {
        return this.getName();
    }

    public static String stripFormatting(@Nullable String text) {
        return text == null ? "" : FORMATTING_PATTERN.matcher(text).replaceAll("");
    }

    public static boolean hasFormatting(String text) {
        return FORMATTING_PATTERN.matcher(text).find();
    }

    static {
        FORMATTING_PATTERN = Pattern.compile("(?i)\u00a7[WXYZ]");
    }
}

