/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.enhancedanvils.util;

import com.mrbysco.enhancedanvils.util.TextFont;
import com.mrbysco.enhancedanvils.util.TextLore;
import java.util.ArrayList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemLore;
import org.jetbrains.annotations.Nullable;

public class TextHelper {
    public static Component changeFont(Component component) {
        String text = component.getString();
        for (TextFont font : TextFont.values()) {
            if (!text.startsWith(font.toString())) continue;
            String newText = text.substring(font.toString().length());
            MutableComponent returnComp = Component.literal((String)newText);
            returnComp.withStyle(style -> style.withFont(font.getLocation()));
            return returnComp;
        }
        return component;
    }

    public static boolean loreChanged(ItemLore originalLore, String itemName) {
        for (TextLore lore : TextLore.values()) {
            if (!itemName.contains(lore.toString())) continue;
            String strippedName = TextLore.stripFormatting(itemName);
            strippedName = strippedName == null ? "" : strippedName.replace(lore.toString(), "");
            ArrayList lines = new ArrayList(originalLore.lines());
            if (lines.size() < lore.getLine() || !((Component)lines.get(lore.getLine() - 1)).getString().equals(strippedName)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static ItemLore createLore(ItemLore originalLore, String itemName) {
        for (TextLore lore : TextLore.values()) {
            if (!itemName.contains(lore.toString())) continue;
            String strippedName = TextLore.stripFormatting(itemName);
            strippedName = strippedName == null ? "" : strippedName.replace(lore.toString(), "");
            ArrayList<Object> lines = new ArrayList<Object>(originalLore.lines());
            if (lines.size() >= lore.getLine()) {
                if (strippedName.isEmpty()) {
                    lines.set(lore.getLine() - 1, Component.empty());
                } else {
                    lines.set(lore.getLine() - 1, TextHelper.changeFont((Component)Component.literal((String)strippedName)));
                }
            } else {
                while (lines.size() < lore.getLine() - 1) {
                    lines.add(Component.empty());
                }
                lines.add(TextHelper.changeFont((Component)Component.literal((String)strippedName)));
            }
            return new ItemLore(lines);
        }
        return null;
    }

    public static void setLore(ItemStack stack, String itemName) {
        ItemLore lore = TextHelper.createLore((ItemLore)stack.getOrDefault(DataComponents.LORE, (Object)ItemLore.EMPTY), itemName);
        boolean allEmpty = true;
        for (Component line : lore.lines()) {
            if (line.getString().isEmpty()) continue;
            allEmpty = false;
            break;
        }
        if (allEmpty) {
            stack.remove(DataComponents.LORE);
        } else {
            stack.set(DataComponents.LORE, (Object)lore);
        }
    }
}

