/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.usefulhats.item;

import de.cech12.usefulhats.item.AbstractHatItem;
import de.cech12.usefulhats.item.IBreakSpeedChanger;
import de.cech12.usefulhats.platform.Services;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.block.state.BlockState;

public abstract class AbstractMiningHatItem
extends AbstractHatItem
implements IBreakSpeedChanger {
    AbstractMiningHatItem(Holder<ArmorMaterial> material, int initColor, Supplier<Integer> durabilityConfig, Supplier<Boolean> enabledDamageConfig) {
        super(material, initColor, durabilityConfig, enabledDamageConfig);
    }

    protected double getEnchantmentDoubleValue(ItemStack stack) {
        return this.getSpeedConfig(Services.PLATFORM.getEnchantmentLevel(stack, Enchantments.EFFICIENCY));
    }

    protected abstract double getSpeedConfig(int var1);

    protected abstract boolean isToolEffective(ItemStack var1, BlockState var2);

    @Override
    public float onBreakSpeedEvent(Player player, BlockState blockState, float actualSpeed, ItemStack headSlotItemStack) {
        if (this.isToolEffective(player.getMainHandItem(), blockState)) {
            return (1.0f + (float)this.getEnchantmentDoubleValue(headSlotItemStack)) * actualSpeed;
        }
        return actualSpeed;
    }

    @Override
    public void onBreakEvent(Player player, BlockState blockState, ItemStack headSlotItemStack) {
        if (this.isToolEffective(player.getMainHandItem(), blockState)) {
            this.damageHatItemByOne(headSlotItemStack, (LivingEntity)player);
        }
    }
}

