/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.usefulhats.client;

import de.cech12.usefulhats.Constants;
import de.cech12.usefulhats.client.UsefulHatModel;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_10034;
import net.minecraft.class_10042;
import net.minecraft.class_10186;
import net.minecraft.class_10192;
import net.minecraft.class_1304;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3489;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5321;
import net.minecraft.class_5601;
import net.minecraft.class_572;
import net.minecraft.class_583;
import net.minecraft.class_918;
import net.minecraft.class_9282;
import net.minecraft.class_9334;
import net.minecraft.class_9848;

public abstract class AbstractUsefulHatsRenderer {
    public static final class_5601 USEFUL_HAT_LAYER = new class_5601(Constants.id("usefulhat_layer"), "main");
    private final Function<LayerTextureKey, class_2960> layerTextureLookup = class_156.method_34866(textureKey -> textureKey.layer.method_64007(textureKey.layerType));
    private class_572<class_10034> usefulHatModel;

    public void render(class_1799 stack, class_4587 matrices, class_4597 vertexConsumers, int light, class_572<class_10034> entityModel) {
        class_572<class_10034> model = this.getArmorModel(stack);
        entityModel.method_64254(model);
        this.internalRender(stack, matrices, vertexConsumers, light, (class_583)model);
    }

    public void render(class_1799 stack, class_4587 matrices, class_4597 vertexConsumers, int light, class_10034 humanoidRenderState) {
        class_572<class_10034> model = this.getArmorModel(stack);
        model.method_17087(humanoidRenderState);
        this.internalRender(stack, matrices, vertexConsumers, light, (class_583)model);
    }

    protected <S extends class_10042> void internalRender(class_1799 stack, class_4587 matrices, class_4597 vertexConsumers, int light, class_583<S> model) {
        class_10192 equippable = (class_10192)stack.method_57824(class_9334.field_54196);
        if (equippable != null && equippable.comp_3176().isPresent() && equippable.comp_3174() == class_1304.field_6169) {
            class_5321 assetId = (class_5321)equippable.comp_3176().orElseThrow();
            class_10186.class_10190 layerType = class_10186.class_10190.field_54125;
            List layers = class_310.method_1551().method_1561().field_55290.method_64087(assetId).method_63996(layerType);
            if (!layers.isEmpty()) {
                int defaultColor = stack.method_31573(class_3489.field_48803) ? class_9282.method_57470((class_1799)stack, (int)0) : 0;
                boolean glint = stack.method_7958();
                for (class_10186.class_10189 layer : layers) {
                    int color = AbstractUsefulHatsRenderer.getColorForLayer(layer, defaultColor);
                    if (color == 0) continue;
                    class_2960 layerTexture = this.layerTextureLookup.apply(new LayerTextureKey(layerType, layer));
                    class_4588 vertexConsumer = class_918.method_27952((class_4597)vertexConsumers, (class_1921)class_1921.method_65052((class_2960)layerTexture), (boolean)glint);
                    model.method_62100(matrices, vertexConsumer, light, class_4608.field_21444, color);
                    glint = false;
                }
            }
        }
    }

    private static int getColorForLayer(class_10186.class_10189 layer, int defaultColor) {
        Optional optional = layer.comp_3172();
        if (optional.isPresent()) {
            int color = ((class_10186.class_10188)optional.get()).comp_3170().map(class_9848::method_61334).orElse(0);
            return defaultColor != 0 ? defaultColor : color;
        }
        return -1;
    }

    private class_572<class_10034> getArmorModel(class_1799 stack) {
        if (this.usefulHatModel == null) {
            this.usefulHatModel = new UsefulHatModel<class_10034>(class_310.method_1551().method_31974().method_32072(USEFUL_HAT_LAYER));
        }
        return this.usefulHatModel;
    }

    record LayerTextureKey(class_10186.class_10190 layerType, class_10186.class_10189 layer) {
    }
}

