/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.usefulhats.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cech12.usefulhats.Constants;
import de.cech12.usefulhats.item.AbstractHatItem;
import de.cech12.usefulhats.item.HatArmorMaterials;
import de.cech12.usefulhats.item.IRightClickListener;
import de.cech12.usefulhats.platform.Services;
import java.util.List;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2709;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_5454;
import net.minecraft.class_5894;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class EnderHelmetItem
extends AbstractHatItem
implements IRightClickListener {
    public EnderHelmetItem(String name) {
        super(name, HatArmorMaterials.ENDER, Services.CONFIG::getEnderHelmetDurability, Services.CONFIG::isEnderHelmetDamageEnabled);
    }

    @Override
    public void method_7851(@NotNull class_1799 stack, @NotNull class_1792.class_9635 context, @NotNull List<class_2561> tooltip, @NotNull class_1836 flagIn) {
        tooltip.add((class_2561)class_2561.method_43471((String)"item.usefulhats.ender_helmet.desc.define_teleport").method_27692(class_124.field_1078));
        Position position = EnderHelmetItem.getPosition(stack);
        if (position != null) {
            super.method_7851(stack, context, tooltip, flagIn);
            tooltip.add((class_2561)class_2561.method_43471((String)"item.usefulhats.ender_helmet.desc.teleport").method_27692(class_124.field_1078));
            tooltip.add((class_2561)class_2561.method_43469((String)"item.usefulhats.ender_helmet.desc.teleport_position", (Object[])new Object[]{position.pos.method_10263(), position.pos.method_10264(), position.pos.method_10260()}).method_27692(class_124.field_1078));
            tooltip.add((class_2561)class_2561.method_43470((String)position.dimName.toString()).method_27692(class_124.field_1078));
        }
    }

    private static void setPosition(@NotNull class_1799 stack, @NotNull class_1937 level, @NotNull class_1309 entity) {
        stack.method_57379(Constants.ENDER_HELMET_POSITION.get(), (Object)new Position(level.method_27983().method_41185(), level.method_27983().method_29177(), entity.method_24515()));
    }

    private static boolean hasPosition(@NotNull class_1799 stack) {
        return stack.method_57826(Constants.ENDER_HELMET_POSITION.get());
    }

    private static Position getPosition(@NotNull class_1799 stack) {
        if (EnderHelmetItem.hasPosition(stack)) {
            return (Position)stack.method_57824(Constants.ENDER_HELMET_POSITION.get());
        }
        return null;
    }

    private static boolean levelEqualsPosition(class_1937 level, Position position) {
        return level.method_27983().method_41185().equals((Object)position.dimKey) && level.method_27983().method_29177().equals((Object)position.dimName);
    }

    private class_3218 getLevel(@NotNull MinecraftServer server, @NotNull class_1799 stack) {
        Position position = EnderHelmetItem.getPosition(stack);
        if (position != null) {
            for (class_3218 world : server.method_3738()) {
                if (!EnderHelmetItem.levelEqualsPosition((class_1937)world, position)) continue;
                return world;
            }
        }
        return null;
    }

    private static boolean canTeleportToPosition(@NotNull class_1937 level, @NotNull class_2338 pos) {
        return !level.method_8320(pos).method_26225() && !level.method_8320(pos.method_10084()).method_26225();
    }

    @NotNull
    public class_1269 method_7836(@NotNull class_1937 worldIn, @NotNull class_1657 playerIn, @NotNull class_1268 handIn) {
        class_1799 stack = playerIn.method_5998(handIn);
        if (playerIn.method_5715() && !stack.method_7960()) {
            if (!worldIn.field_9236) {
                EnderHelmetItem.setPosition(stack, worldIn, (class_1309)playerIn);
                playerIn.method_6122(handIn, stack);
                ((class_3222)playerIn).field_13987.method_14364((class_2596)new class_5894((class_2561)class_2561.method_43471((String)"item.usefulhats.ender_helmet.message.position_saved")));
            }
            return class_1269.field_5812;
        }
        return super.method_7836(worldIn, playerIn, handIn);
    }

    @Override
    public boolean onRightClickItemEvent(class_1937 level, class_1657 player, class_1799 usedStack, class_1268 hand, class_1799 headSlotItemStack) {
        if (!Services.REGISTRY.getEquippedHatItemStacks((class_1309)player).contains(headSlotItemStack)) {
            return false;
        }
        if (usedStack.method_7909() != class_1802.field_8634 || !EnderHelmetItem.hasPosition(headSlotItemStack)) {
            return false;
        }
        player.method_6104(hand);
        if (!level.field_9236) {
            Position position = EnderHelmetItem.getPosition(headSlotItemStack);
            if (position != null && (Services.CONFIG.isEnderHelmetInterdimensionalEnabled() || EnderHelmetItem.levelEqualsPosition(level, position))) {
                class_3218 destinationWorld = this.getLevel(player.method_5682(), headSlotItemStack);
                class_2338 destinationPos = position.pos;
                if (destinationPos != null && destinationWorld != null && EnderHelmetItem.canTeleportToPosition((class_1937)destinationWorld, destinationPos)) {
                    player.method_7357().method_62835(usedStack, 20);
                    player.field_6017 = 0.0f;
                    player.method_17356(class_3417.field_14879, class_3419.field_15248, 1.0f, 1.0f);
                    if (player.method_37908() != destinationWorld) {
                        player.method_5731(new class_5454(destinationWorld, new class_243((double)destinationPos.method_10263() + 0.5, (double)destinationPos.method_10264(), (double)destinationPos.method_10260() + 0.5), class_243.field_1353, player.field_5982, player.field_6004, class_2709.method_63641((Set[])new Set[]{class_2709.field_40711, class_2709.field_54094}), class_5454.field_52245));
                    } else {
                        player.method_5859((double)destinationPos.method_10263() + 0.5, (double)destinationPos.method_10264(), (double)destinationPos.method_10260() + 0.5);
                    }
                    player.method_17356(class_3417.field_14879, class_3419.field_15248, 1.0f, 1.0f);
                    player.method_7259(class_3468.field_15372.method_14956((Object)usedStack.method_7909()));
                    if (!player.method_31549().field_7477) {
                        usedStack.method_7934(1);
                    }
                    this.damageHatItemByOne(headSlotItemStack, (class_1309)player);
                } else {
                    ((class_3222)player).field_13987.method_14364((class_2596)new class_5894((class_2561)class_2561.method_43471((String)"item.usefulhats.ender_helmet.message.position_obstructed")));
                }
            } else {
                ((class_3222)player).field_13987.method_14364((class_2596)new class_5894((class_2561)class_2561.method_43471((String)"item.usefulhats.ender_helmet.message.wrong_dimension")));
            }
        }
        return true;
    }

    public record Position(class_2960 dimKey, class_2960 dimName, class_2338 pos) {
        public static final Codec<Position> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("dimKey").forGetter(Position::dimKey), (App)class_2960.field_25139.fieldOf("dimName").forGetter(Position::dimName), (App)class_2338.field_25064.fieldOf("pos").forGetter(Position::pos)).apply((Applicative)instance, Position::new));
        public static final class_9139<class_9129, Position> STREAM_CODEC = class_9139.method_56436((class_9139)class_2960.field_48267, Position::dimKey, (class_9139)class_2960.field_48267, Position::dimName, (class_9139)class_2338.field_48404, Position::pos, Position::new);
    }
}

