/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.usefulhats.item;

import de.cech12.usefulhats.item.AbstractHatItem;
import de.cech12.usefulhats.item.HatArmorMaterials;
import de.cech12.usefulhats.item.IEquipmentChangeListener;
import de.cech12.usefulhats.platform.Services;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;

public class WingHelmetItem
extends AbstractHatItem
implements IEquipmentChangeListener {
    private static final int SLOW_FALLING_AMPLIFIER = 0;
    private static final int SLOW_FALLING_DURATION = 219;
    private static final int LEVITATION_AMPLIFIER = 2;
    private static final int LEVITATION_DURATION = 200;

    public WingHelmetItem(String name) {
        super(name, HatArmorMaterials.WING, Services.CONFIG::getWingHelmetDurability, Services.CONFIG::isWingHelmetDamageEnabled);
    }

    @Override
    public void method_7851(@NotNull class_1799 stack, @NotNull class_1792.class_9635 context, @NotNull List<class_2561> tooltip, @NotNull class_1836 flagIn) {
        super.method_7851(stack, context, tooltip, flagIn);
        tooltip.add((class_2561)class_2561.method_43471((String)"item.usefulhats.wing_helmet.desc.slow_falling").method_27692(class_124.field_1078));
        if (Services.CONFIG.isWingHelmetLevitationEnabled()) {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.usefulhats.wing_helmet.desc.scared").method_27692(class_124.field_1061));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isPlayerFalling(class_1309 entity) {
        if (entity.method_24828()) return false;
        if (!(entity.method_18798().method_10214() < 0.0)) return false;
        if (!(entity instanceof class_1657)) return false;
        class_1657 player = (class_1657)entity;
        if (player.method_31549().field_7479) return false;
        if (entity.method_6128()) return false;
        if (Services.REGISTRY.isEntityInFluid(entity)) return false;
        return true;
    }

    public void method_7888(@NotNull class_1799 stack, class_1937 level, @NotNull class_1297 entity, int slot, boolean selectedIndex) {
        if (!level.field_9236 && entity instanceof class_1309) {
            boolean isSlowFallingEffectActive;
            boolean isLevitationEffectActive;
            class_1309 livingEntity = (class_1309)entity;
            if (!Services.REGISTRY.getEquippedHatItemStacks(livingEntity).contains(stack)) {
                return;
            }
            boolean isLevitationFromOtherSource = this.isEffectCausedByOtherSource(livingEntity, (class_6880<class_1291>)class_1294.field_5902, 200, 2);
            boolean bl = isLevitationEffectActive = livingEntity.method_6112(class_1294.field_5902) != null;
            if (!isLevitationEffectActive && Services.CONFIG.isWingHelmetLevitationEnabled() && livingEntity.method_6081() != null && livingEntity.method_6081().method_5529() instanceof class_1309 && level.field_9229.method_43048(100) == 0) {
                this.removeEffect(livingEntity, (class_6880<class_1291>)class_1294.field_5906, 219, 0);
                this.addEffect(livingEntity, (class_6880<class_1291>)class_1294.field_5902, 200, 2, true);
                isLevitationEffectActive = true;
            }
            boolean isSlowFallingFromOtherSource = this.isEffectCausedByOtherSource(livingEntity, (class_6880<class_1291>)class_1294.field_5906, 219, 0);
            boolean bl2 = isSlowFallingEffectActive = livingEntity.method_6112(class_1294.field_5906) != null;
            if (this.isPlayerFalling(livingEntity)) {
                if (!(isLevitationEffectActive || isSlowFallingFromOtherSource || isSlowFallingEffectActive && livingEntity.field_6012 % 19 != 0)) {
                    this.addEffect(livingEntity, (class_6880<class_1291>)class_1294.field_5906, 219, 0);
                    isSlowFallingEffectActive = true;
                }
            } else {
                this.removeEffect(livingEntity, (class_6880<class_1291>)class_1294.field_5906, 219, 0);
            }
            if ((isSlowFallingEffectActive && !isSlowFallingFromOtherSource || isLevitationEffectActive && !isLevitationFromOtherSource && Services.CONFIG.isWingHelmetLevitationEnabled()) && livingEntity.field_6012 % 20 == 0) {
                this.damageHatItemByOne(stack, livingEntity);
            }
        }
    }

    @Override
    public void onUnequippedHatItem(class_1309 entity, class_1799 oldStack) {
        this.removeEffect(entity, (class_6880<class_1291>)class_1294.field_5906, 219, 0);
        if (Services.CONFIG.isWingHelmetLevitationEnabled()) {
            this.removeEffect(entity, (class_6880<class_1291>)class_1294.field_5902, 200, 2);
        }
    }
}

