/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.usefulhats.item;

import de.cech12.usefulhats.CommonLoader;
import de.cech12.usefulhats.UsefulHatsUtils;
import de.cech12.usefulhats.item.AbstractHatItem;
import de.cech12.usefulhats.item.HatArmorMaterials;
import de.cech12.usefulhats.item.IEquipmentChangeListener;
import de.cech12.usefulhats.item.IItemFishedListener;
import de.cech12.usefulhats.item.ILivingDropsListener;
import de.cech12.usefulhats.platform.Services;
import java.util.function.Consumer;
import net.minecraft.class_10712;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;

public class LuckyHatItem
extends AbstractHatItem
implements IItemFishedListener,
ILivingDropsListener,
IEquipmentChangeListener {
    private static final int LUCK_DURATION = 219;
    private static final int UNLUCK_AMPLIFIER = 0;
    private static final int UNLUCK_DURATION = 200;

    public LuckyHatItem(String name) {
        super(name, HatArmorMaterials.LUCKY, Services.CONFIG::getLuckyHatDurability, Services.CONFIG::isLuckyHatDamageEnabled);
    }

    private boolean isLuckOrUnluckCausedByOtherSource(class_1309 entity, class_1799 stack) {
        return this.isEffectCausedByOtherSource(entity, (class_6880<class_1291>)class_1294.field_5926, 219, this.getLuckAmplifier(stack)) || this.isEffectCausedByOtherSource(entity, (class_6880<class_1291>)class_1294.field_5908, 200, 0);
    }

    private int getEffectLevel(class_1799 stack) {
        return 1 + CommonLoader.getEnchantmentLevel(stack, (class_5321<class_1887>)class_1893.field_9131);
    }

    private int getLuckAmplifier(class_1799 stack) {
        return this.getEffectLevel(stack) - 1;
    }

    @Override
    public void method_67187(@NotNull class_1799 stack, @NotNull class_1792.class_9635 context, @NotNull class_10712 display, @NotNull Consumer<class_2561> tooltip, @NotNull class_1836 flagIn) {
        super.method_67187(stack, context, display, tooltip, flagIn);
        tooltip.accept((class_2561)class_2561.method_43469((String)"item.usefulhats.lucky_hat.desc.luck", (Object[])new Object[]{UsefulHatsUtils.getRomanNumber(this.getEffectLevel(stack), false)}).method_27692(class_124.field_1078));
        if (Services.CONFIG.isLuckyHatUnluckEnabled()) {
            tooltip.accept((class_2561)class_2561.method_43471((String)"item.usefulhats.lucky_hat.desc.unluck").method_27692(class_124.field_1061));
        }
    }

    public void method_7888(@NotNull class_1799 stack, class_3218 level, @NotNull class_1297 entity, class_1304 slot) {
        if (!level.method_8608() && entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (!Services.REGISTRY.getEquippedHatItemStacks((class_1309)player).contains(stack)) {
                return;
            }
            if (this.isLuckOrUnluckCausedByOtherSource((class_1309)player, stack)) {
                return;
            }
            int luckAmplifier = this.getLuckAmplifier(stack);
            if (player.method_6112(class_1294.field_5908) == null) {
                if (player.method_6112(class_1294.field_5926) == null || player.field_6012 % 19 == 0) {
                    this.addEffect((class_1309)player, (class_6880<class_1291>)class_1294.field_5926, 219, luckAmplifier);
                }
            } else {
                this.removeEffect((class_1309)player, (class_6880<class_1291>)class_1294.field_5926, 219, luckAmplifier);
            }
        }
    }

    @Override
    public void onItemFishedListener(class_1657 player, class_1799 headSlotItemStack) {
        if (this.isLuckOrUnluckCausedByOtherSource((class_1309)player, headSlotItemStack)) {
            return;
        }
        this.damageHatItemByOne(headSlotItemStack, (class_1309)player);
        if (Services.CONFIG.isLuckyHatUnluckEnabled()) {
            this.removeEffect((class_1309)player, (class_6880<class_1291>)class_1294.field_5926, 219, this.getLuckAmplifier(headSlotItemStack));
            this.addEffect((class_1309)player, (class_6880<class_1291>)class_1294.field_5908, 200, 0);
        }
    }

    @Override
    public void onLivingDropsEvent(class_1309 dropReason, class_1799 headSlotItemStack) {
        if (this.isLuckOrUnluckCausedByOtherSource(dropReason, headSlotItemStack)) {
            return;
        }
        this.damageHatItemByOne(headSlotItemStack, dropReason);
        if (Services.CONFIG.isLuckyHatUnluckEnabled()) {
            this.removeEffect(dropReason, (class_6880<class_1291>)class_1294.field_5926, 219, this.getLuckAmplifier(headSlotItemStack));
            this.addEffect(dropReason, (class_6880<class_1291>)class_1294.field_5908, 200, 0);
        }
    }

    @Override
    public void onUnequippedHatItem(class_1309 entity, class_1799 oldStack) {
        this.removeEffect(entity, (class_6880<class_1291>)class_1294.field_5926, 219, this.getLuckAmplifier(oldStack));
    }
}

