/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.usefulhats.platform;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import de.cech12.usefulhats.platform.services.IConfigHelper;
import java.nio.file.Path;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLConfig;
import net.minecraftforge.fml.loading.FMLPaths;

public class ForgeConfigHelper
implements IConfigHelper {
    public static final ForgeConfigSpec SERVER_CONFIG;
    public static final ForgeConfigSpec.BooleanValue AQUANAUT_HELMET_DAMAGE_ENABLED;
    public static final ForgeConfigSpec.IntValue AQUANAUT_HELMET_DURABILITY;
    public static final ForgeConfigSpec.IntValue AQUANAUT_HELMET_EFFECT_TIME_WITH_EFFICIENCY_0;
    public static final ForgeConfigSpec.IntValue AQUANAUT_HELMET_EFFECT_TIME_WITH_EFFICIENCY_1;
    public static final ForgeConfigSpec.IntValue AQUANAUT_HELMET_EFFECT_TIME_WITH_EFFICIENCY_2;
    public static final ForgeConfigSpec.IntValue AQUANAUT_HELMET_EFFECT_TIME_WITH_EFFICIENCY_3;
    public static final ForgeConfigSpec.IntValue AQUANAUT_HELMET_EFFECT_TIME_WITH_EFFICIENCY_4;
    public static final ForgeConfigSpec.IntValue AQUANAUT_HELMET_EFFECT_TIME_WITH_EFFICIENCY_5;
    public static final ForgeConfigSpec.BooleanValue BUNNY_EARS_DAMAGE_ENABLED;
    public static final ForgeConfigSpec.IntValue BUNNY_EARS_DURABILITY;
    public static final ForgeConfigSpec.BooleanValue BUNNY_EARS_EAT_BOOST_ENABLED;
    public static final ForgeConfigSpec.BooleanValue BUNNY_EARS_JUMP_BOOST_ENABLED;
    public static final ForgeConfigSpec.BooleanValue CHOPPING_HAT_DAMAGE_ENABLED;
    public static final ForgeConfigSpec.IntValue CHOPPING_HAT_DURABILITY;
    public static final ForgeConfigSpec.DoubleValue CHOPPING_HAT_SPEED_WITH_EFFICIENCY_0;
    public static final ForgeConfigSpec.DoubleValue CHOPPING_HAT_SPEED_WITH_EFFICIENCY_1;
    public static final ForgeConfigSpec.DoubleValue CHOPPING_HAT_SPEED_WITH_EFFICIENCY_2;
    public static final ForgeConfigSpec.DoubleValue CHOPPING_HAT_SPEED_WITH_EFFICIENCY_3;
    public static final ForgeConfigSpec.DoubleValue CHOPPING_HAT_SPEED_WITH_EFFICIENCY_4;
    public static final ForgeConfigSpec.DoubleValue CHOPPING_HAT_SPEED_WITH_EFFICIENCY_5;
    public static final ForgeConfigSpec.BooleanValue ENDER_HELMET_DAMAGE_ENABLED;
    public static final ForgeConfigSpec.IntValue ENDER_HELMET_DURABILITY;
    public static final ForgeConfigSpec.BooleanValue ENDER_HELMET_INTERDIMENSIONAL_ENABLED;
    public static final ForgeConfigSpec.BooleanValue HALO_DAMAGE_ENABLED;
    public static final ForgeConfigSpec.IntValue HALO_DURABILITY;
    public static final ForgeConfigSpec.BooleanValue LUCKY_HAT_DAMAGE_ENABLED;
    public static final ForgeConfigSpec.IntValue LUCKY_HAT_DURABILITY;
    public static final ForgeConfigSpec.BooleanValue LUCKY_HAT_UNLUCK_ENABLED;
    public static final ForgeConfigSpec.BooleanValue MINING_HAT_DAMAGE_ENABLED;
    public static final ForgeConfigSpec.IntValue MINING_HAT_DURABILITY;
    public static final ForgeConfigSpec.BooleanValue MINING_HAT_NIGHT_VISION_ENABLED;
    public static final ForgeConfigSpec.BooleanValue MINING_HAT_MAKE_PIGLINS_NEUTRAL_ENABLED;
    public static final ForgeConfigSpec.DoubleValue MINING_HAT_SPEED_WITH_EFFICIENCY_0;
    public static final ForgeConfigSpec.DoubleValue MINING_HAT_SPEED_WITH_EFFICIENCY_1;
    public static final ForgeConfigSpec.DoubleValue MINING_HAT_SPEED_WITH_EFFICIENCY_2;
    public static final ForgeConfigSpec.DoubleValue MINING_HAT_SPEED_WITH_EFFICIENCY_3;
    public static final ForgeConfigSpec.DoubleValue MINING_HAT_SPEED_WITH_EFFICIENCY_4;
    public static final ForgeConfigSpec.DoubleValue MINING_HAT_SPEED_WITH_EFFICIENCY_5;
    public static final ForgeConfigSpec.BooleanValue MUSHROOM_HAT_DAMAGE_ENABLED;
    public static final ForgeConfigSpec.IntValue MUSHROOM_HAT_DURABILITY;
    public static final ForgeConfigSpec.IntValue MUSHROOM_HAT_EAT_INTERVAL;
    public static final ForgeConfigSpec.BooleanValue POSTMAN_HAT_DAMAGE_ENABLED;
    public static final ForgeConfigSpec.IntValue POSTMAN_HAT_DURABILITY;
    public static final ForgeConfigSpec.BooleanValue POSTMAN_HAT_HUNGER_ENABLED;
    public static final ForgeConfigSpec.BooleanValue SHULKER_HELMET_DAMAGE_ENABLED;
    public static final ForgeConfigSpec.IntValue SHULKER_HELMET_DURABILITY;
    public static final ForgeConfigSpec.BooleanValue STOCKING_CAP_DAMAGE_ENABLED;
    public static final ForgeConfigSpec.IntValue STOCKING_CAP_DURABILITY;
    public static final ForgeConfigSpec.BooleanValue STRAW_HAT_DAMAGE_ENABLED;
    public static final ForgeConfigSpec.IntValue STRAW_HAT_DURABILITY;
    public static final ForgeConfigSpec.DoubleValue STRAW_HAT_SPEED_WITH_EFFICIENCY_0;
    public static final ForgeConfigSpec.DoubleValue STRAW_HAT_SPEED_WITH_EFFICIENCY_1;
    public static final ForgeConfigSpec.DoubleValue STRAW_HAT_SPEED_WITH_EFFICIENCY_2;
    public static final ForgeConfigSpec.DoubleValue STRAW_HAT_SPEED_WITH_EFFICIENCY_3;
    public static final ForgeConfigSpec.DoubleValue STRAW_HAT_SPEED_WITH_EFFICIENCY_4;
    public static final ForgeConfigSpec.DoubleValue STRAW_HAT_SPEED_WITH_EFFICIENCY_5;
    public static final ForgeConfigSpec.BooleanValue WING_HELMET_DAMAGE_ENABLED;
    public static final ForgeConfigSpec.IntValue WING_HELMET_DURABILITY;
    public static final ForgeConfigSpec.BooleanValue WING_HELMET_LEVITATION_ENABLED;

    @Override
    public void init() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)SERVER_CONFIG);
        Path path = FMLPaths.GAMEDIR.get().resolve(FMLConfig.defaultConfigPath()).resolve("usefulhats-server.toml");
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        SERVER_CONFIG.setConfig((CommentedConfig)configData);
    }

    private boolean getBoolean(ForgeConfigSpec.BooleanValue config, boolean defaultValue) {
        try {
            return (Boolean)config.get();
        }
        catch (IllegalStateException ex) {
            return defaultValue;
        }
    }

    private int getInteger(ForgeConfigSpec.IntValue config, int defaultValue) {
        try {
            return (Integer)config.get();
        }
        catch (IllegalStateException ex) {
            return defaultValue;
        }
    }

    private int getEnchantmentInteger(int enchantmentLevel, ForgeConfigSpec.IntValue config0, int defaultValue0, ForgeConfigSpec.IntValue config1, int defaultValue1, ForgeConfigSpec.IntValue config2, int defaultValue2, ForgeConfigSpec.IntValue config3, int defaultValue3, ForgeConfigSpec.IntValue config4, int defaultValue4, ForgeConfigSpec.IntValue config5, int defaultValue5) {
        if (enchantmentLevel < 0) {
            return this.getInteger(config0, defaultValue0);
        }
        return switch (enchantmentLevel) {
            case 0 -> this.getInteger(config0, defaultValue0);
            case 1 -> this.getInteger(config1, defaultValue1);
            case 2 -> this.getInteger(config2, defaultValue2);
            case 3 -> this.getInteger(config3, defaultValue3);
            case 4 -> this.getInteger(config4, defaultValue4);
            default -> this.getInteger(config5, defaultValue5);
        };
    }

    private double getDouble(ForgeConfigSpec.DoubleValue config, double defaultValue) {
        try {
            return (Double)config.get();
        }
        catch (IllegalStateException ex) {
            return defaultValue;
        }
    }

    private double getEnchantmentDouble(int enchantmentLevel, ForgeConfigSpec.DoubleValue config0, double defaultValue0, ForgeConfigSpec.DoubleValue config1, double defaultValue1, ForgeConfigSpec.DoubleValue config2, double defaultValue2, ForgeConfigSpec.DoubleValue config3, double defaultValue3, ForgeConfigSpec.DoubleValue config4, double defaultValue4, ForgeConfigSpec.DoubleValue config5, double defaultValue5) {
        if (enchantmentLevel < 0) {
            return this.getDouble(config0, defaultValue0);
        }
        return switch (enchantmentLevel) {
            case 0 -> this.getDouble(config0, defaultValue0);
            case 1 -> this.getDouble(config1, defaultValue1);
            case 2 -> this.getDouble(config2, defaultValue2);
            case 3 -> this.getDouble(config3, defaultValue3);
            case 4 -> this.getDouble(config4, defaultValue4);
            default -> this.getDouble(config5, defaultValue5);
        };
    }

    @Override
    public boolean isAquanautHelmetDamageEnabled() {
        return this.getBoolean(AQUANAUT_HELMET_DAMAGE_ENABLED, true);
    }

    @Override
    public int getAquanautHelmetDurability() {
        return this.getInteger(AQUANAUT_HELMET_DURABILITY, 600);
    }

    @Override
    public int getAquanautHelmetEffectTimeWithEfficiency(int enchantmentLevel) {
        return this.getEnchantmentInteger(enchantmentLevel, AQUANAUT_HELMET_EFFECT_TIME_WITH_EFFICIENCY_0, 60, AQUANAUT_HELMET_EFFECT_TIME_WITH_EFFICIENCY_1, 120, AQUANAUT_HELMET_EFFECT_TIME_WITH_EFFICIENCY_2, 180, AQUANAUT_HELMET_EFFECT_TIME_WITH_EFFICIENCY_3, 240, AQUANAUT_HELMET_EFFECT_TIME_WITH_EFFICIENCY_3, 240, AQUANAUT_HELMET_EFFECT_TIME_WITH_EFFICIENCY_3, 240);
    }

    @Override
    public boolean isBunnyEarsDamageEnabled() {
        return this.getBoolean(BUNNY_EARS_DAMAGE_ENABLED, true);
    }

    @Override
    public int getBunnyEarsDurability() {
        return this.getInteger(BUNNY_EARS_DURABILITY, 450);
    }

    @Override
    public boolean isBunnyEarsEatBoostEnabled() {
        return this.getBoolean(BUNNY_EARS_EAT_BOOST_ENABLED, true);
    }

    @Override
    public boolean isBunnyEarsJumpBoostEnabled() {
        return this.getBoolean(BUNNY_EARS_JUMP_BOOST_ENABLED, true);
    }

    @Override
    public boolean isChoppingHatDamageEnabled() {
        return this.getBoolean(CHOPPING_HAT_DAMAGE_ENABLED, true);
    }

    @Override
    public int getChoppingHatDurability() {
        return this.getInteger(CHOPPING_HAT_DURABILITY, 300);
    }

    @Override
    public double getChoppingHatSpeedWithEfficiency(int enchantmentLevel) {
        return this.getEnchantmentDouble(enchantmentLevel, CHOPPING_HAT_SPEED_WITH_EFFICIENCY_0, 0.2, CHOPPING_HAT_SPEED_WITH_EFFICIENCY_1, 0.4, CHOPPING_HAT_SPEED_WITH_EFFICIENCY_2, 0.6, CHOPPING_HAT_SPEED_WITH_EFFICIENCY_3, 0.8, CHOPPING_HAT_SPEED_WITH_EFFICIENCY_4, 1.0, CHOPPING_HAT_SPEED_WITH_EFFICIENCY_5, 1.5);
    }

    @Override
    public boolean isEnderHelmetDamageEnabled() {
        return this.getBoolean(ENDER_HELMET_DAMAGE_ENABLED, true);
    }

    @Override
    public int getEnderHelmetDurability() {
        return this.getInteger(ENDER_HELMET_DURABILITY, 80);
    }

    @Override
    public boolean isEnderHelmetInterdimensionalEnabled() {
        return this.getBoolean(ENDER_HELMET_INTERDIMENSIONAL_ENABLED, true);
    }

    @Override
    public boolean isHaloDamageEnabled() {
        return this.getBoolean(HALO_DAMAGE_ENABLED, true);
    }

    @Override
    public int getHaloDurability() {
        return this.getInteger(HALO_DURABILITY, 600);
    }

    @Override
    public boolean isLuckyHatDamageEnabled() {
        return this.getBoolean(LUCKY_HAT_DAMAGE_ENABLED, true);
    }

    @Override
    public int getLuckyHatDurability() {
        return this.getInteger(LUCKY_HAT_DURABILITY, 300);
    }

    @Override
    public boolean isLuckyHatUnluckEnabled() {
        return this.getBoolean(LUCKY_HAT_UNLUCK_ENABLED, true);
    }

    @Override
    public boolean isMiningHatDamageEnabled() {
        return this.getBoolean(MINING_HAT_DAMAGE_ENABLED, true);
    }

    @Override
    public int getMiningHatDurability() {
        return this.getInteger(MINING_HAT_DURABILITY, 450);
    }

    @Override
    public boolean isMiningHatNightVisionEnabled() {
        return this.getBoolean(MINING_HAT_NIGHT_VISION_ENABLED, true);
    }

    @Override
    public boolean isMiningHatMakePiglinsNeutralEnabled() {
        return this.getBoolean(MINING_HAT_MAKE_PIGLINS_NEUTRAL_ENABLED, true);
    }

    @Override
    public double getMiningHatSpeedWithEfficiency(int enchantmentLevel) {
        return this.getEnchantmentDouble(enchantmentLevel, MINING_HAT_SPEED_WITH_EFFICIENCY_0, 0.2, MINING_HAT_SPEED_WITH_EFFICIENCY_1, 0.4, MINING_HAT_SPEED_WITH_EFFICIENCY_2, 0.6, MINING_HAT_SPEED_WITH_EFFICIENCY_3, 0.8, MINING_HAT_SPEED_WITH_EFFICIENCY_4, 1.0, MINING_HAT_SPEED_WITH_EFFICIENCY_5, 1.5);
    }

    @Override
    public boolean isMushroomHatDamageEnabled() {
        return this.getBoolean(MUSHROOM_HAT_DAMAGE_ENABLED, true);
    }

    @Override
    public int getMushroomHatDurability() {
        return this.getInteger(MUSHROOM_HAT_DURABILITY, 80);
    }

    @Override
    public int getMushroomHatEatInterval() {
        return this.getInteger(MUSHROOM_HAT_EAT_INTERVAL, 60);
    }

    @Override
    public boolean isPostmanHatDamageEnabled() {
        return this.getBoolean(POSTMAN_HAT_DAMAGE_ENABLED, true);
    }

    @Override
    public int getPostmanHatDurability() {
        return this.getInteger(POSTMAN_HAT_DURABILITY, 600);
    }

    @Override
    public boolean isPostmanHatHungerEnabled() {
        return this.getBoolean(POSTMAN_HAT_HUNGER_ENABLED, true);
    }

    @Override
    public boolean isShulkerHelmetDamageEnabled() {
        return this.getBoolean(SHULKER_HELMET_DAMAGE_ENABLED, true);
    }

    @Override
    public int getShulkerHelmetDurability() {
        return this.getInteger(SHULKER_HELMET_DURABILITY, 600);
    }

    @Override
    public boolean isStockingCapDamageEnabled() {
        return this.getBoolean(STOCKING_CAP_DAMAGE_ENABLED, true);
    }

    @Override
    public int getStockingCapDurability() {
        return this.getInteger(STOCKING_CAP_DURABILITY, 600);
    }

    @Override
    public boolean isStrawHatDamageEnabled() {
        return this.getBoolean(STRAW_HAT_DAMAGE_ENABLED, true);
    }

    @Override
    public int getStrawHatDurability() {
        return this.getInteger(STRAW_HAT_DURABILITY, 300);
    }

    @Override
    public double getStrawHatSpeedWithEfficiency(int enchantmentLevel) {
        return this.getEnchantmentDouble(enchantmentLevel, STRAW_HAT_SPEED_WITH_EFFICIENCY_0, 0.2, STRAW_HAT_SPEED_WITH_EFFICIENCY_1, 0.4, STRAW_HAT_SPEED_WITH_EFFICIENCY_2, 0.6, STRAW_HAT_SPEED_WITH_EFFICIENCY_3, 0.8, STRAW_HAT_SPEED_WITH_EFFICIENCY_4, 1.0, STRAW_HAT_SPEED_WITH_EFFICIENCY_5, 1.5);
    }

    @Override
    public boolean isWingHelmetDamageEnabled() {
        return this.getBoolean(WING_HELMET_DAMAGE_ENABLED, true);
    }

    @Override
    public int getWingHelmetDurability() {
        return this.getInteger(WING_HELMET_DURABILITY, 600);
    }

    @Override
    public boolean isWingHelmetLevitationEnabled() {
        return this.getBoolean(WING_HELMET_LEVITATION_ENABLED, true);
    }

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment("Various options that affect individual hats.").push("BalanceOptions");
        builder.push("AquanautHelmet");
        AQUANAUT_HELMET_DAMAGE_ENABLED = builder.comment("Whether or not damaging of Aquanaut Helmet should be enabled.").define("aquanautHelmetDamageEnabled", true);
        AQUANAUT_HELMET_DURABILITY = builder.comment("Aquanaut Helmet durability.").defineInRange("aquanautHelmetDurability", 600, 1, 10000);
        AQUANAUT_HELMET_EFFECT_TIME_WITH_EFFICIENCY_0 = builder.comment("Aquanaut Helmet effect time of Conduit Power without Efficiency enchantment. (in seconds)").defineInRange("aquanautHelmetEffectTimeWithEfficiency0", 60, 10, 120);
        AQUANAUT_HELMET_EFFECT_TIME_WITH_EFFICIENCY_1 = builder.comment("Aquanaut Helmet effect time of Conduit Power with Efficiency I. (in seconds)").defineInRange("aquanautHelmetEffectTimeWithEfficiency1", 120, 10, 180);
        AQUANAUT_HELMET_EFFECT_TIME_WITH_EFFICIENCY_2 = builder.comment("Aquanaut Helmet effect time of Conduit Power with Efficiency II. (in seconds)").defineInRange("aquanautHelmetEffectTimeWithEfficiency2", 180, 10, 240);
        AQUANAUT_HELMET_EFFECT_TIME_WITH_EFFICIENCY_3 = builder.comment("Aquanaut Helmet effect time of Conduit Power with Efficiency III. (in seconds)").defineInRange("aquanautHelmetEffectTimeWithEfficiency3", 240, 10, 300);
        AQUANAUT_HELMET_EFFECT_TIME_WITH_EFFICIENCY_4 = builder.comment("Aquanaut Helmet effect time of Conduit Power with Efficiency IV. (in seconds)").defineInRange("aquanautHelmetEffectTimeWithEfficiency4", 300, 10, 360);
        AQUANAUT_HELMET_EFFECT_TIME_WITH_EFFICIENCY_5 = builder.comment("Aquanaut Helmet effect time of Conduit Power with Efficiency V. (in seconds)").defineInRange("aquanautHelmetEffectTimeWithEfficiency5", 360, 10, 420);
        builder.pop();
        builder.push("BunnyEars");
        BUNNY_EARS_DAMAGE_ENABLED = builder.comment("Whether or not damaging of Bunny Ears should be enabled.").define("bunnyEarsDamageEnabled", true);
        BUNNY_EARS_DURABILITY = builder.comment("Bunny Ears durability.").defineInRange("bunnyEarsDurability", 450, 1, 10000);
        BUNNY_EARS_EAT_BOOST_ENABLED = builder.comment("Whether or not Eat Boost of Bunny Ears should be enabled.").define("bunnyEarsEatBoostEnabled", true);
        BUNNY_EARS_JUMP_BOOST_ENABLED = builder.comment("Whether or not Jump Boost of Bunny Ears should be enabled.").define("bunnyEarsJumpBoostEnabled", true);
        builder.pop();
        builder.push("ChoppingHat");
        CHOPPING_HAT_DAMAGE_ENABLED = builder.comment("Whether or not damaging of Chopping Hat should be enabled.").define("choppingHatDamageEnabled", true);
        CHOPPING_HAT_DURABILITY = builder.comment("Chopping Hat durability.").defineInRange("choppingHatDurability", 300, 1, 10000);
        CHOPPING_HAT_SPEED_WITH_EFFICIENCY_0 = builder.comment("Chopping Hat speed increase without Efficiency enchantment.").defineInRange("choppingHatSpeedWithEfficiency0", 0.2, 0.0, 5.0);
        CHOPPING_HAT_SPEED_WITH_EFFICIENCY_1 = builder.comment("Chopping Hat speed increase with Efficiency I.").defineInRange("choppingHatSpeedWithEfficiency1", 0.4, 0.0, 5.0);
        CHOPPING_HAT_SPEED_WITH_EFFICIENCY_2 = builder.comment("Chopping Hat speed increase with Efficiency II.").defineInRange("choppingHatSpeedWithEfficiency2", 0.6, 0.0, 5.0);
        CHOPPING_HAT_SPEED_WITH_EFFICIENCY_3 = builder.comment("Chopping Hat speed increase with Efficiency III.").defineInRange("choppingHatSpeedWithEfficiency3", 0.8, 0.0, 5.0);
        CHOPPING_HAT_SPEED_WITH_EFFICIENCY_4 = builder.comment("Chopping Hat speed increase with Efficiency IV.").defineInRange("choppingHatSpeedWithEfficiency4", 1.0, 0.0, 5.0);
        CHOPPING_HAT_SPEED_WITH_EFFICIENCY_5 = builder.comment("Chopping Hat speed increase with Efficiency V.").defineInRange("choppingHatSpeedWithEfficiency5", 1.5, 0.0, 5.0);
        builder.pop();
        builder.push("EnderHelmet");
        ENDER_HELMET_DAMAGE_ENABLED = builder.comment("Whether or not damaging of Ender Helmet should be enabled.").define("enderHelmetDamageEnabled", true);
        ENDER_HELMET_DURABILITY = builder.comment("Ender Helmet durability.").defineInRange("enderHelmetDurability", 80, 1, 10000);
        ENDER_HELMET_INTERDIMENSIONAL_ENABLED = builder.comment("Whether or not interdimensional teleporting with the Ender Helmet should be enabled.").define("enderHelmetInterdimensionalEnabled", true);
        builder.pop();
        builder.push("Halo");
        HALO_DAMAGE_ENABLED = builder.comment("Whether or not damaging of Halo should be enabled.").define("haloDamageEnabled", true);
        HALO_DURABILITY = builder.comment("Halo durability.").defineInRange("haloDurability", 600, 1, 10000);
        builder.pop();
        builder.push("LuckyHat");
        LUCKY_HAT_DAMAGE_ENABLED = builder.comment("Whether or not damaging of Lucky Hat should be enabled.").define("luckyHatDamageEnabled", true);
        LUCKY_HAT_DURABILITY = builder.comment("Lucky Hat durability.").defineInRange("luckyHatDurability", 300, 1, 10000);
        LUCKY_HAT_UNLUCK_ENABLED = builder.comment("Whether or not Unluck effect of Lucky Hat should be enabled after fishing/killing.").define("luckyHatUnluckEnabled", true);
        builder.pop();
        builder.push("MiningHat");
        MINING_HAT_DAMAGE_ENABLED = builder.comment("Whether or not damaging of Mining Hat should be enabled.").define("miningHatDamageEnabled", true);
        MINING_HAT_DURABILITY = builder.comment("Mining Hat durability.").defineInRange("miningHatDurability", 450, 1, 10000);
        MINING_HAT_NIGHT_VISION_ENABLED = builder.comment("Whether or not Night Vision effect of Mining Hat should be enabled in dark areas.").define("miningHatNightVisionEnabled", true);
        MINING_HAT_MAKE_PIGLINS_NEUTRAL_ENABLED = builder.comment("Whether or not wearing a Mining Hat should make Piglins neutral.").define("miningHatMakePiglinsNeutralEnabled", true);
        MINING_HAT_SPEED_WITH_EFFICIENCY_0 = builder.comment("Mining Hat speed increase without Efficiency enchantment.").defineInRange("miningHatSpeedWithEfficiency0", 0.2, 0.0, 5.0);
        MINING_HAT_SPEED_WITH_EFFICIENCY_1 = builder.comment("Mining Hat speed increase with Efficiency I.").defineInRange("miningHatSpeedWithEfficiency1", 0.4, 0.0, 5.0);
        MINING_HAT_SPEED_WITH_EFFICIENCY_2 = builder.comment("Mining Hat speed increase with Efficiency II.").defineInRange("miningHatSpeedWithEfficiency2", 0.6, 0.0, 5.0);
        MINING_HAT_SPEED_WITH_EFFICIENCY_3 = builder.comment("Mining Hat speed increase with Efficiency III.").defineInRange("miningHatSpeedWithEfficiency3", 0.8, 0.0, 5.0);
        MINING_HAT_SPEED_WITH_EFFICIENCY_4 = builder.comment("Mining Hat speed increase with Efficiency IV.").defineInRange("miningHatSpeedWithEfficiency4", 1.0, 0.0, 5.0);
        MINING_HAT_SPEED_WITH_EFFICIENCY_5 = builder.comment("Mining Hat speed increase with Efficiency V.").defineInRange("miningHatSpeedWithEfficiency5", 1.5, 0.0, 5.0);
        builder.pop();
        builder.push("MushroomHat");
        MUSHROOM_HAT_DAMAGE_ENABLED = builder.comment("Whether or not damaging of Mushroom Hat should be enabled.").define("mushroomHatDamageEnabled", true);
        MUSHROOM_HAT_DURABILITY = builder.comment("Mushroom Hat durability.").defineInRange("mushroomHatDurability", 80, 1, 10000);
        MUSHROOM_HAT_EAT_INTERVAL = builder.comment("Interval the Mushroom Hat is eaten by the player (in ticks). default: 60 (3 seconds)").defineInRange("mushroomHatEatInterval", 60, 1, 10000);
        builder.pop();
        builder.push("PostmanHat");
        POSTMAN_HAT_DAMAGE_ENABLED = builder.comment("Whether or not damaging of Postman Hat should be enabled.").define("postmanHatDamageEnabled", true);
        POSTMAN_HAT_DURABILITY = builder.comment("Postman Hat durability.").defineInRange("postmanHatDurability", 600, 1, 10000);
        POSTMAN_HAT_HUNGER_ENABLED = builder.comment("Whether or not Hunger effect of Postman Hat should be enabled while running.").define("postmanHatHungerEnabled", true);
        builder.pop();
        builder.push("ShulkerHelmet");
        SHULKER_HELMET_DAMAGE_ENABLED = builder.comment("Whether or not damaging of Shulker Helmet should be enabled.").define("shulkerHelmetDamageEnabled", true);
        SHULKER_HELMET_DURABILITY = builder.comment("Shulker Helmet durability.").defineInRange("shulkerHelmetDurability", 600, 1, 10000);
        builder.pop();
        builder.push("StockingCap");
        STOCKING_CAP_DAMAGE_ENABLED = builder.comment("Whether or not damaging of Stocking Cap should be enabled.").define("stockingCapDamageEnabled", true);
        STOCKING_CAP_DURABILITY = builder.comment("Stocking Cap durability.").defineInRange("stockingCapDurability", 600, 1, 10000);
        builder.pop();
        builder.push("StrawHat");
        STRAW_HAT_DAMAGE_ENABLED = builder.comment("Whether or not damaging of Straw Hat should be enabled.").define("strawHatDamageEnabled", true);
        STRAW_HAT_DURABILITY = builder.comment("Straw Hat durability.").defineInRange("strawHatDurability", 600, 1, 10000);
        STRAW_HAT_SPEED_WITH_EFFICIENCY_0 = builder.comment("Straw Hat speed increase without Efficiency enchantment.").defineInRange("strawHatSpeedWithEfficiency0", 0.2, 0.0, 5.0);
        STRAW_HAT_SPEED_WITH_EFFICIENCY_1 = builder.comment("Straw Hat speed increase with Efficiency I.").defineInRange("strawHatSpeedWithEfficiency1", 0.4, 0.0, 5.0);
        STRAW_HAT_SPEED_WITH_EFFICIENCY_2 = builder.comment("Straw Hat speed increase with Efficiency II.").defineInRange("strawHatSpeedWithEfficiency2", 0.6, 0.0, 5.0);
        STRAW_HAT_SPEED_WITH_EFFICIENCY_3 = builder.comment("Straw Hat speed increase with Efficiency III.").defineInRange("strawHatSpeedWithEfficiency3", 0.8, 0.0, 5.0);
        STRAW_HAT_SPEED_WITH_EFFICIENCY_4 = builder.comment("Straw Hat speed increase with Efficiency IV.").defineInRange("strawHatSpeedWithEfficiency4", 1.0, 0.0, 5.0);
        STRAW_HAT_SPEED_WITH_EFFICIENCY_5 = builder.comment("Straw Hat speed increase with Efficiency V.").defineInRange("strawHatSpeedWithEfficiency5", 1.5, 0.0, 5.0);
        builder.pop();
        builder.push("WingHelmet");
        WING_HELMET_DAMAGE_ENABLED = builder.comment("Whether or not damaging of Wing Helmet should be enabled.").define("wingHelmetDamageEnabled", true);
        WING_HELMET_DURABILITY = builder.comment("Wing Helmet durability.").defineInRange("wingHelmetDurability", 600, 1, 10000);
        WING_HELMET_LEVITATION_ENABLED = builder.comment("Whether or not Levitation effect of Wing Helmet should be enabled.").define("wingHelmetLevitationEnabled", true);
        builder.pop();
        builder.pop();
        SERVER_CONFIG = builder.build();
    }
}

