/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.usefulhats.item;

import de.cech12.usefulhats.UsefulHatsUtils;
import de.cech12.usefulhats.item.AbstractHatItem;
import de.cech12.usefulhats.item.HatArmorMaterials;
import de.cech12.usefulhats.item.IEquipmentChangeListener;
import de.cech12.usefulhats.item.IItemUseListener;
import de.cech12.usefulhats.item.ILivingJumpListener;
import de.cech12.usefulhats.platform.Services;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class BunnyEarsItem
extends AbstractHatItem
implements IEquipmentChangeListener,
IItemUseListener,
ILivingJumpListener {
    private static final int JUMP_BOOST_DURATION = 219;

    public BunnyEarsItem() {
        super(HatArmorMaterials.BUNNY, BunnyEarsItem.rawColorFromRGB(142, 120, 94), Services.CONFIG::getBunnyEarsDurability, Services.CONFIG::isBunnyEarsDamageEnabled);
    }

    @Override
    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        int enchantmentLevel = Services.PLATFORM.getEnchantmentLevel(stack, Enchantments.EFFICIENCY) + 1;
        if (Services.CONFIG.isBunnyEarsJumpBoostEnabled()) {
            tooltip.add((Component)Component.translatable((String)"item.usefulhats.bunny_ears.desc.jump_boost", (Object[])new Object[]{UsefulHatsUtils.getRomanNumber(enchantmentLevel, false)}).withStyle(ChatFormatting.BLUE));
        }
        if (Services.CONFIG.isBunnyEarsEatBoostEnabled()) {
            tooltip.add((Component)Component.translatable((String)"item.usefulhats.bunny_ears.desc.eating", (Object[])new Object[]{enchantmentLevel + 1}).withStyle(ChatFormatting.BLUE));
        }
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slot, boolean selectedIndex) {
        if (Services.CONFIG.isBunnyEarsJumpBoostEnabled() && !level.isClientSide && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (!Services.REGISTRY.getEquippedHatItemStacks(livingEntity).contains(stack)) {
                return;
            }
            int amplifier = Services.PLATFORM.getEnchantmentLevel(stack, Enchantments.EFFICIENCY);
            if (!(this.isEffectCausedByOtherSource(livingEntity, (Holder<MobEffect>)MobEffects.JUMP, 219, amplifier) || livingEntity.getEffect(MobEffects.JUMP) != null && livingEntity.tickCount % 19 != 0)) {
                this.addEffect(livingEntity, (Holder<MobEffect>)MobEffects.JUMP, 219, amplifier);
            }
        }
    }

    @Override
    public int onItemUseEventStart(LivingEntity entity, ItemStack usedStack, int actualDuration, ItemStack headSlotItemStack) {
        if (Services.CONFIG.isBunnyEarsEatBoostEnabled() && usedStack.has(DataComponents.FOOD)) {
            int amplifier = Services.PLATFORM.getEnchantmentLevel(headSlotItemStack, Enchantments.EFFICIENCY) + 2;
            this.damageHatItemByOne(headSlotItemStack, entity);
            return actualDuration / amplifier;
        }
        return actualDuration;
    }

    @Override
    public void onUnequippedHatItem(LivingEntity entity, ItemStack oldStack) {
        if (Services.CONFIG.isBunnyEarsJumpBoostEnabled()) {
            int amplifier = Services.PLATFORM.getEnchantmentLevel(oldStack, Enchantments.EFFICIENCY);
            this.removeEffect(entity, (Holder<MobEffect>)MobEffects.JUMP, 219, amplifier);
        }
    }

    @Override
    public void onLivingJumpEvent(LivingEntity jumpingEntity, ItemStack headSlotItemStack) {
        int amplifier;
        if (Services.CONFIG.isBunnyEarsJumpBoostEnabled() && !this.isEffectCausedByOtherSource(jumpingEntity, (Holder<MobEffect>)MobEffects.JUMP, 219, amplifier = Services.PLATFORM.getEnchantmentLevel(headSlotItemStack, Enchantments.EFFICIENCY))) {
            this.damageHatItemByOne(headSlotItemStack, jumpingEntity);
        }
    }
}

