/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.usefulhats.item;

import de.cech12.usefulhats.UsefulHatsTags;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class HatArmorMaterials {
    public static final Holder<ArmorMaterial> AQUANAUT = HatArmorMaterials.register("aquanaut_helmet", (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_TURTLE, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.TURTLE_SCUTE}));
    public static final Holder<ArmorMaterial> BUNNY = HatArmorMaterials.register("bunny_ears", (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_LEATHER, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.RABBIT_HIDE, Items.CARROT}));
    public static final Holder<ArmorMaterial> CHOPPING = HatArmorMaterials.register("chopping_hat", (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_LEATHER, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.RABBIT_HIDE}));
    public static final Holder<ArmorMaterial> ENDER = HatArmorMaterials.register("ender_helmet", (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_IRON, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.ENDER_PEARL}), false);
    public static final Holder<ArmorMaterial> HALO = HatArmorMaterials.register("halo", (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_GOLD, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.GLOWSTONE_DUST}), false);
    public static final Holder<ArmorMaterial> LUCKY = HatArmorMaterials.register("lucky_hat", (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_LEATHER, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.RABBIT_FOOT}));
    public static final Holder<ArmorMaterial> MINING = HatArmorMaterials.register("mining_hat", (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_GOLD, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLD_INGOT}));
    public static final Holder<ArmorMaterial> MUSHROOM = HatArmorMaterials.register("mushroom_hat", (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_LEATHER, () -> Ingredient.of(UsefulHatsTags.Items.MUSHROOM_CAPS));
    public static final Holder<ArmorMaterial> POSTMAN = HatArmorMaterials.register("postman_hat", (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_LEATHER, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.LAPIS_LAZULI}));
    public static final Holder<ArmorMaterial> SHULKER = HatArmorMaterials.register("shulker_helmet", (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_IRON, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.SHULKER_SHELL, Items.PHANTOM_MEMBRANE}), false);
    public static final Holder<ArmorMaterial> STOCKING = HatArmorMaterials.register("stocking_cap", (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_LEATHER, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.STRING}));
    public static final Holder<ArmorMaterial> STRAW = HatArmorMaterials.register("straw_hat", (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_LEATHER, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.WHEAT}));
    public static final Holder<ArmorMaterial> WING = HatArmorMaterials.register("wing_helmet", (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_IRON, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.FEATHER, Items.PHANTOM_MEMBRANE}));

    private static Holder<ArmorMaterial> register(String name, Holder<SoundEvent> equipSound, Supplier<Ingredient> repairIngredients) {
        return HatArmorMaterials.register(name, equipSound, repairIngredients, true);
    }

    private static Holder<ArmorMaterial> register(String name, Holder<SoundEvent> equipSound, Supplier<Ingredient> repairIngredients, boolean withOverlay) {
        EnumMap<ArmorItem.Type, Integer> defenseMap = new EnumMap<ArmorItem.Type, Integer>(ArmorItem.Type.class);
        for (ArmorItem.Type type : ArmorItem.Type.values()) {
            defenseMap.put(type, 0);
        }
        ArrayList<ArmorMaterial.Layer> layers = new ArrayList<ArmorMaterial.Layer>();
        layers.add(new ArmorMaterial.Layer(new ResourceLocation("usefulhats", name), "", true));
        if (withOverlay) {
            layers.add(new ArmorMaterial.Layer(new ResourceLocation("usefulhats", name), "_overlay", false));
        }
        return Registry.registerForHolder((Registry)BuiltInRegistries.ARMOR_MATERIAL, (ResourceLocation)new ResourceLocation("usefulhats", name), (Object)new ArmorMaterial(defenseMap, 15, equipSound, repairIngredients, layers, 0.0f, 0.0f));
    }
}

