/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.usefulhats.item;

import de.cech12.usefulhats.CommonLoader;
import de.cech12.usefulhats.Constants;
import de.cech12.usefulhats.item.AbstractHatItem;
import de.cech12.usefulhats.item.HatArmorMaterials;
import de.cech12.usefulhats.item.IEquipmentChangeListener;
import de.cech12.usefulhats.platform.Services;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class AquanautHelmetItem
extends AbstractHatItem
implements IEquipmentChangeListener {
    private static final ResourceLocation AQUANAUT_GUI_TEX_PATH = Constants.id("misc/aquanautblur");

    public AquanautHelmetItem(String name) {
        super(name, HatArmorMaterials.AQUANAUT.humanoidProperties(new Item.Properties(), ArmorType.HELMET).component(DataComponents.EQUIPPABLE, (Object)Equippable.builder((EquipmentSlot)EquipmentSlot.HEAD).setEquipSound(HatArmorMaterials.AQUANAUT.equipSound()).setModel(HatArmorMaterials.AQUANAUT.modelId()).setDamageOnHurt(false).setCameraOverlay(AQUANAUT_GUI_TEX_PATH).build()), AquanautHelmetItem.rawColorFromRGB(71, 191, 74), Services.CONFIG::getAquanautHelmetDurability, Services.CONFIG::isAquanautHelmetDamageEnabled);
    }

    private int getConduitPowerDuration(ItemStack stack) {
        return Services.CONFIG.getAquanautHelmetEffectTimeWithEfficiency(CommonLoader.getEnchantmentLevel(stack, (ResourceKey<Enchantment>)Enchantments.EFFICIENCY)) * 20;
    }

    @Override
    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        int effectTime = Services.CONFIG.getAquanautHelmetEffectTimeWithEfficiency(CommonLoader.getEnchantmentLevel(stack, (ResourceKey<Enchantment>)Enchantments.EFFICIENCY));
        tooltip.add((Component)Component.translatable((String)"item.usefulhats.aquanaut_helmet.desc.conduit_power", (Object[])new Object[]{effectTime}).withStyle(ChatFormatting.BLUE));
    }

    public void inventoryTick(@NotNull ItemStack stack, Level level, @NotNull Entity entity, int slot, boolean selectedIndex) {
        if (!level.isClientSide && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (!Services.REGISTRY.getEquippedHatItemStacks(livingEntity).contains(stack)) {
                return;
            }
            int maxDuration = this.getConduitPowerDuration(stack);
            if (this.isEffectCausedByOtherSource(livingEntity, (Holder<MobEffect>)MobEffects.CONDUIT_POWER, maxDuration, 0)) {
                return;
            }
            if (!Services.REGISTRY.areEntityEyesInDrownableFluid(livingEntity)) {
                this.addEffect(livingEntity, (Holder<MobEffect>)MobEffects.CONDUIT_POWER, maxDuration, 0);
            } else if (livingEntity.getEffect(MobEffects.CONDUIT_POWER) != null && livingEntity.tickCount % 20 == 0) {
                this.damageHatItemByOne(stack, livingEntity);
            }
        }
    }

    @Override
    public void onUnequippedHatItem(LivingEntity entity, ItemStack oldStack) {
        if (!entity.level().isClientSide) {
            if (Services.REGISTRY.getEquippedHatItemStacks(entity).stream().anyMatch(stack -> stack.getItem() == this)) {
                return;
            }
            this.removeEffect(entity, (Holder<MobEffect>)MobEffects.CONDUIT_POWER, this.getConduitPowerDuration(oldStack), 0);
        }
    }
}

