/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.usefulhats.compat;

import de.cech12.usefulhats.UsefulHatsEventUtils;
import de.cech12.usefulhats.item.AbstractHatItem;
import de.cech12.usefulhats.platform.Services;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import tld.unknown.baubles.BaublesHolderAttachment;
import tld.unknown.baubles.Registries;
import tld.unknown.baubles.api.BaubleType;
import tld.unknown.baubles.api.BaublesData;
import tld.unknown.baubles.api.IBauble;

public class Baubles2Compat {
    public static void register(RegisterCapabilitiesEvent event) {
        UsefulHatBauble usefulHatsBauble = new UsefulHatBauble();
        Services.REGISTRY.getAllHatItems().forEach(item -> event.registerItem(BaublesData.CapabilitiesAttachments.CAPABILITY_BAUBLE, (stack, ctx) -> usefulHatsBauble, new ItemLike[]{item}));
    }

    public static void addEquippedHatsToList(LivingEntity entity, List<ItemStack> stacks) {
        if (entity.hasData((Supplier)Registries.ATTACHMENT_BAUBLES)) {
            BaublesHolderAttachment holder = (BaublesHolderAttachment)entity.getData((Supplier)Registries.ATTACHMENT_BAUBLES);
            for (ItemStack stack : holder.getAllSlots()) {
                if (!(stack.getItem() instanceof AbstractHatItem) || !stacks.stream().noneMatch(s -> s.getItem() == stack.getItem())) continue;
                stacks.add(stack);
            }
        }
    }

    public static class UsefulHatBauble
    implements IBauble {
        public void onWornTick(BaubleType type, ItemStack stack, Player player) {
            stack.getItem().inventoryTick(stack, player.level(), (Entity)player, type.ordinal(), false);
        }

        public void onEquipped(BaubleType type, ItemStack stack, Player player) {
            if (!player.level().isClientSide()) {
                UsefulHatsEventUtils.onEquip((LivingEntity)player, stack);
            }
        }

        public void onUnequipped(BaubleType type, ItemStack stack, Player player) {
            if (!player.level().isClientSide()) {
                UsefulHatsEventUtils.onUnequip((LivingEntity)player, stack);
            }
        }
    }
}

