/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.usefulhats.platform;

import de.cech12.usefulhats.platform.services.IConfigHelper;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.autoconfig.serializer.Toml4jConfigSerializer;

@Config(name="usefulhats")
public class FabricConfigHelper
implements ConfigData,
IConfigHelper {
    @ConfigEntry.Gui.CollapsibleObject
    @ConfigEntry.Gui.Tooltip(count=2)
    public AquanautHelmet AQUANAUT_HELMET = new AquanautHelmet();
    @ConfigEntry.Gui.CollapsibleObject
    @ConfigEntry.Gui.Tooltip(count=2)
    public BunnyEars BUNNY_EARS = new BunnyEars();
    @ConfigEntry.Gui.CollapsibleObject
    @ConfigEntry.Gui.Tooltip(count=2)
    public ChoppingHat CHOPPING_HAT = new ChoppingHat();
    @ConfigEntry.Gui.CollapsibleObject
    @ConfigEntry.Gui.Tooltip(count=2)
    public EnderHelmet ENDER_HELMET = new EnderHelmet();
    @ConfigEntry.Gui.CollapsibleObject
    @ConfigEntry.Gui.Tooltip(count=2)
    public Halo HALO = new Halo();
    @ConfigEntry.Gui.CollapsibleObject
    @ConfigEntry.Gui.Tooltip(count=2)
    public LuckyHat LUCKY_HAT = new LuckyHat();
    @ConfigEntry.Gui.CollapsibleObject
    @ConfigEntry.Gui.Tooltip(count=2)
    public MiningHat MINING_HAT = new MiningHat();
    @ConfigEntry.Gui.CollapsibleObject
    @ConfigEntry.Gui.Tooltip(count=2)
    public MushroomHat MUSHROOM_HAT = new MushroomHat();
    @ConfigEntry.Gui.CollapsibleObject
    @ConfigEntry.Gui.Tooltip(count=2)
    public PostmanHat POSTMAN_HAT = new PostmanHat();
    @ConfigEntry.Gui.CollapsibleObject
    @ConfigEntry.Gui.Tooltip(count=2)
    public ShulkerHelmet SHULKER_HELMET = new ShulkerHelmet();
    @ConfigEntry.Gui.CollapsibleObject
    @ConfigEntry.Gui.Tooltip(count=2)
    public StockingCap STOCKING_CAP = new StockingCap();
    @ConfigEntry.Gui.CollapsibleObject
    @ConfigEntry.Gui.Tooltip(count=2)
    public StrawHat STRAW_HAT = new StrawHat();
    @ConfigEntry.Gui.CollapsibleObject
    @ConfigEntry.Gui.Tooltip(count=2)
    public WingHelmet WING_HELMET = new WingHelmet();

    @Override
    public void init() {
        AutoConfig.register(FabricConfigHelper.class, Toml4jConfigSerializer::new);
    }

    private FabricConfigHelper getConfig() {
        return (FabricConfigHelper)AutoConfig.getConfigHolder(FabricConfigHelper.class).getConfig();
    }

    private int getEnchantmentInteger(int enchantmentLevel, int config0, int config1, int config2, int config3, int config4, int config5) {
        if (enchantmentLevel < 0) {
            return config0;
        }
        return switch (enchantmentLevel) {
            case 0 -> config0;
            case 1 -> config1;
            case 2 -> config2;
            case 3 -> config3;
            case 4 -> config4;
            default -> config5;
        };
    }

    private double getDouble(int config) {
        return (double)config / 100.0;
    }

    private double getEnchantmentDouble(int enchantmentLevel, double config0, double config1, double config2, double config3, double config4, double config5) {
        if (enchantmentLevel < 0) {
            return config0;
        }
        return switch (enchantmentLevel) {
            case 0 -> config0;
            case 1 -> config1;
            case 2 -> config2;
            case 3 -> config3;
            case 4 -> config4;
            default -> config5;
        };
    }

    @Override
    public boolean isAquanautHelmetDamageEnabled() {
        return this.getConfig().AQUANAUT_HELMET.DAMAGE_ENABLED;
    }

    @Override
    public int getAquanautHelmetDurability() {
        return Math.clamp((long)this.getConfig().AQUANAUT_HELMET.DURABILITY, 1, 10000);
    }

    @Override
    public int getAquanautHelmetEffectTimeWithEfficiency(int enchantmentLevel) {
        FabricConfigHelper config = this.getConfig();
        return this.getEnchantmentInteger(enchantmentLevel, Math.clamp((long)config.AQUANAUT_HELMET.EFFECT_TIME_WITH_EFFICIENCY_0, 10, 120), Math.clamp((long)config.AQUANAUT_HELMET.EFFECT_TIME_WITH_EFFICIENCY_1, 10, 180), Math.clamp((long)config.AQUANAUT_HELMET.EFFECT_TIME_WITH_EFFICIENCY_2, 10, 240), Math.clamp((long)config.AQUANAUT_HELMET.EFFECT_TIME_WITH_EFFICIENCY_3, 10, 300), Math.clamp((long)config.AQUANAUT_HELMET.EFFECT_TIME_WITH_EFFICIENCY_4, 10, 360), Math.clamp((long)config.AQUANAUT_HELMET.EFFECT_TIME_WITH_EFFICIENCY_5, 10, 420));
    }

    @Override
    public boolean isBunnyEarsDamageEnabled() {
        return this.getConfig().BUNNY_EARS.DAMAGE_ENABLED;
    }

    @Override
    public int getBunnyEarsDurability() {
        return Math.clamp((long)this.getConfig().getConfig().BUNNY_EARS.DURABILITY, 1, 10000);
    }

    @Override
    public boolean isBunnyEarsEatBoostEnabled() {
        return this.getConfig().BUNNY_EARS.EAT_BOOST_ENABLED;
    }

    @Override
    public boolean isBunnyEarsJumpBoostEnabled() {
        return this.getConfig().BUNNY_EARS.JUMP_BOOST_ENABLED;
    }

    @Override
    public boolean isChoppingHatDamageEnabled() {
        return this.getConfig().CHOPPING_HAT.DAMAGE_ENABLED;
    }

    @Override
    public int getChoppingHatDurability() {
        return Math.clamp((long)this.getConfig().CHOPPING_HAT.DURABILITY, 1, 10000);
    }

    @Override
    public double getChoppingHatSpeedWithEfficiency(int enchantmentLevel) {
        FabricConfigHelper config = this.getConfig();
        return this.getEnchantmentDouble(enchantmentLevel, Math.clamp(this.getDouble(config.CHOPPING_HAT.SPEED_WITH_EFFICIENCY_0), 0.0, 5.0), Math.clamp(this.getDouble(config.CHOPPING_HAT.SPEED_WITH_EFFICIENCY_1), 0.0, 5.0), Math.clamp(this.getDouble(config.CHOPPING_HAT.SPEED_WITH_EFFICIENCY_2), 0.0, 5.0), Math.clamp(this.getDouble(config.CHOPPING_HAT.SPEED_WITH_EFFICIENCY_3), 0.0, 5.0), Math.clamp(this.getDouble(config.CHOPPING_HAT.SPEED_WITH_EFFICIENCY_4), 0.0, 5.0), Math.clamp(this.getDouble(config.CHOPPING_HAT.SPEED_WITH_EFFICIENCY_5), 0.0, 5.0));
    }

    @Override
    public boolean isEnderHelmetDamageEnabled() {
        return this.getConfig().ENDER_HELMET.DAMAGE_ENABLED;
    }

    @Override
    public int getEnderHelmetDurability() {
        return Math.clamp((long)this.getConfig().ENDER_HELMET.DURABILITY, 1, 10000);
    }

    @Override
    public boolean isEnderHelmetInterdimensionalEnabled() {
        return this.getConfig().ENDER_HELMET.INTERDIMENSIONAL_ENABLED;
    }

    @Override
    public boolean isHaloDamageEnabled() {
        return this.getConfig().HALO.DAMAGE_ENABLED;
    }

    @Override
    public int getHaloDurability() {
        return Math.clamp((long)this.getConfig().HALO.DURABILITY, 1, 10000);
    }

    @Override
    public boolean isLuckyHatDamageEnabled() {
        return this.getConfig().LUCKY_HAT.DAMAGE_ENABLED;
    }

    @Override
    public int getLuckyHatDurability() {
        return Math.clamp((long)this.getConfig().LUCKY_HAT.DURABILITY, 1, 10000);
    }

    @Override
    public boolean isLuckyHatUnluckEnabled() {
        return this.getConfig().LUCKY_HAT.UNLUCK_ENABLED;
    }

    @Override
    public boolean isMiningHatDamageEnabled() {
        return this.getConfig().MINING_HAT.DAMAGE_ENABLED;
    }

    @Override
    public int getMiningHatDurability() {
        return Math.clamp((long)this.getConfig().MINING_HAT.DURABILITY, 1, 10000);
    }

    @Override
    public boolean isMiningHatNightVisionEnabled() {
        return this.getConfig().MINING_HAT.NIGHT_VISION_ENABLED;
    }

    @Override
    public double getMiningHatSpeedWithEfficiency(int enchantmentLevel) {
        FabricConfigHelper config = this.getConfig();
        return this.getEnchantmentDouble(enchantmentLevel, Math.clamp(this.getDouble(config.MINING_HAT.SPEED_WITH_EFFICIENCY_0), 0.0, 5.0), Math.clamp(this.getDouble(config.MINING_HAT.SPEED_WITH_EFFICIENCY_1), 0.0, 5.0), Math.clamp(this.getDouble(config.MINING_HAT.SPEED_WITH_EFFICIENCY_2), 0.0, 5.0), Math.clamp(this.getDouble(config.MINING_HAT.SPEED_WITH_EFFICIENCY_3), 0.0, 5.0), Math.clamp(this.getDouble(config.MINING_HAT.SPEED_WITH_EFFICIENCY_4), 0.0, 5.0), Math.clamp(this.getDouble(config.MINING_HAT.SPEED_WITH_EFFICIENCY_5), 0.0, 5.0));
    }

    @Override
    public boolean isMushroomHatDamageEnabled() {
        return this.getConfig().MUSHROOM_HAT.DAMAGE_ENABLED;
    }

    @Override
    public int getMushroomHatDurability() {
        return Math.clamp((long)this.getConfig().MUSHROOM_HAT.DURABILITY, 1, 10000);
    }

    @Override
    public int getMushroomHatEatInterval() {
        return Math.clamp((long)this.getConfig().MUSHROOM_HAT.EAT_INTERVAL, 1, 10000);
    }

    @Override
    public boolean isPostmanHatDamageEnabled() {
        return this.getConfig().POSTMAN_HAT.DAMAGE_ENABLED;
    }

    @Override
    public int getPostmanHatDurability() {
        return Math.clamp((long)this.getConfig().POSTMAN_HAT.DURABILITY, 1, 10000);
    }

    @Override
    public boolean isPostmanHatHungerEnabled() {
        return this.getConfig().POSTMAN_HAT.HUNGER_ENABLED;
    }

    @Override
    public boolean isShulkerHelmetDamageEnabled() {
        return this.getConfig().SHULKER_HELMET.DAMAGE_ENABLED;
    }

    @Override
    public int getShulkerHelmetDurability() {
        return Math.clamp((long)this.getConfig().SHULKER_HELMET.DURABILITY, 1, 10000);
    }

    @Override
    public boolean isStockingCapDamageEnabled() {
        return this.getConfig().STOCKING_CAP.DAMAGE_ENABLED;
    }

    @Override
    public int getStockingCapDurability() {
        return Math.clamp((long)this.getConfig().STOCKING_CAP.DURABILITY, 1, 10000);
    }

    @Override
    public boolean isStrawHatDamageEnabled() {
        return this.getConfig().STRAW_HAT.DAMAGE_ENABLED;
    }

    @Override
    public int getStrawHatDurability() {
        return Math.clamp((long)this.getConfig().STRAW_HAT.DURABILITY, 1, 10000);
    }

    @Override
    public double getStrawHatSpeedWithEfficiency(int enchantmentLevel) {
        FabricConfigHelper config = this.getConfig();
        return this.getEnchantmentDouble(enchantmentLevel, Math.clamp(this.getDouble(config.STRAW_HAT.SPEED_WITH_EFFICIENCY_0), 0.0, 5.0), Math.clamp(this.getDouble(config.STRAW_HAT.SPEED_WITH_EFFICIENCY_1), 0.0, 5.0), Math.clamp(this.getDouble(config.STRAW_HAT.SPEED_WITH_EFFICIENCY_2), 0.0, 5.0), Math.clamp(this.getDouble(config.STRAW_HAT.SPEED_WITH_EFFICIENCY_3), 0.0, 5.0), Math.clamp(this.getDouble(config.STRAW_HAT.SPEED_WITH_EFFICIENCY_4), 0.0, 5.0), Math.clamp(this.getDouble(config.STRAW_HAT.SPEED_WITH_EFFICIENCY_5), 0.0, 5.0));
    }

    @Override
    public boolean isWingHelmetDamageEnabled() {
        return this.getConfig().WING_HELMET.DAMAGE_ENABLED;
    }

    @Override
    public int getWingHelmetDurability() {
        return Math.clamp((long)this.getConfig().WING_HELMET.DURABILITY, 1, 10000);
    }

    @Override
    public boolean isWingHelmetLevitationEnabled() {
        return this.getConfig().WING_HELMET.LEVITATION_ENABLED;
    }

    public static final class AquanautHelmet
    implements ConfigData {
        @ConfigEntry.Gui.Tooltip(count=3)
        public boolean DAMAGE_ENABLED = true;
        @ConfigEntry.Gui.Tooltip(count=2)
        public int DURABILITY = 600;
        @ConfigEntry.Gui.Tooltip(count=5)
        public int EFFECT_TIME_WITH_EFFICIENCY_0 = 60;
        @ConfigEntry.Gui.Tooltip(count=5)
        public int EFFECT_TIME_WITH_EFFICIENCY_1 = 120;
        @ConfigEntry.Gui.Tooltip(count=5)
        public int EFFECT_TIME_WITH_EFFICIENCY_2 = 180;
        @ConfigEntry.Gui.Tooltip(count=5)
        public int EFFECT_TIME_WITH_EFFICIENCY_3 = 240;
        @ConfigEntry.Gui.Tooltip(count=5)
        public int EFFECT_TIME_WITH_EFFICIENCY_4 = 300;
        @ConfigEntry.Gui.Tooltip(count=5)
        public int EFFECT_TIME_WITH_EFFICIENCY_5 = 360;

        private AquanautHelmet() {
        }
    }

    public static final class BunnyEars
    implements ConfigData {
        @ConfigEntry.Gui.Tooltip(count=3)
        public boolean DAMAGE_ENABLED = true;
        @ConfigEntry.Gui.Tooltip(count=3)
        public int DURABILITY = 450;
        @ConfigEntry.Gui.Tooltip(count=3)
        public boolean EAT_BOOST_ENABLED = true;
        @ConfigEntry.Gui.Tooltip(count=3)
        public boolean JUMP_BOOST_ENABLED = true;

        private BunnyEars() {
        }
    }

    public static final class ChoppingHat
    implements ConfigData {
        @ConfigEntry.Gui.Tooltip(count=3)
        public boolean DAMAGE_ENABLED = true;
        @ConfigEntry.Gui.Tooltip(count=3)
        public int DURABILITY = 300;
        @ConfigEntry.Gui.Tooltip(count=5)
        public int SPEED_WITH_EFFICIENCY_0 = 20;
        @ConfigEntry.Gui.Tooltip(count=5)
        public int SPEED_WITH_EFFICIENCY_1 = 40;
        @ConfigEntry.Gui.Tooltip(count=5)
        public int SPEED_WITH_EFFICIENCY_2 = 60;
        @ConfigEntry.Gui.Tooltip(count=5)
        public int SPEED_WITH_EFFICIENCY_3 = 80;
        @ConfigEntry.Gui.Tooltip(count=5)
        public int SPEED_WITH_EFFICIENCY_4 = 100;
        @ConfigEntry.Gui.Tooltip(count=5)
        public int SPEED_WITH_EFFICIENCY_5 = 150;

        private ChoppingHat() {
        }
    }

    public static final class EnderHelmet
    implements ConfigData {
        @ConfigEntry.Gui.Tooltip(count=3)
        public boolean DAMAGE_ENABLED = true;
        @ConfigEntry.Gui.Tooltip(count=3)
        public int DURABILITY = 80;
        @ConfigEntry.Gui.Tooltip(count=4)
        public boolean INTERDIMENSIONAL_ENABLED = true;

        private EnderHelmet() {
        }
    }

    public static final class Halo
    implements ConfigData {
        @ConfigEntry.Gui.Tooltip(count=3)
        public boolean DAMAGE_ENABLED = true;
        @ConfigEntry.Gui.Tooltip(count=3)
        public int DURABILITY = 600;
    }

    public static final class LuckyHat
    implements ConfigData {
        @ConfigEntry.Gui.Tooltip(count=3)
        public boolean DAMAGE_ENABLED = true;
        @ConfigEntry.Gui.Tooltip(count=3)
        public int DURABILITY = 300;
        @ConfigEntry.Gui.Tooltip(count=4)
        public boolean UNLUCK_ENABLED = true;

        private LuckyHat() {
        }
    }

    public static final class MiningHat
    implements ConfigData {
        @ConfigEntry.Gui.Tooltip(count=3)
        public boolean DAMAGE_ENABLED = true;
        @ConfigEntry.Gui.Tooltip(count=3)
        public int DURABILITY = 450;
        @ConfigEntry.Gui.Tooltip(count=4)
        public boolean NIGHT_VISION_ENABLED = true;
        @ConfigEntry.Gui.Tooltip(count=5)
        public int SPEED_WITH_EFFICIENCY_0 = 20;
        @ConfigEntry.Gui.Tooltip(count=5)
        public int SPEED_WITH_EFFICIENCY_1 = 40;
        @ConfigEntry.Gui.Tooltip(count=5)
        public int SPEED_WITH_EFFICIENCY_2 = 60;
        @ConfigEntry.Gui.Tooltip(count=5)
        public int SPEED_WITH_EFFICIENCY_3 = 80;
        @ConfigEntry.Gui.Tooltip(count=5)
        public int SPEED_WITH_EFFICIENCY_4 = 100;
        @ConfigEntry.Gui.Tooltip(count=5)
        public int SPEED_WITH_EFFICIENCY_5 = 150;

        private MiningHat() {
        }
    }

    public static final class MushroomHat
    implements ConfigData {
        @ConfigEntry.Gui.Tooltip(count=3)
        public boolean DAMAGE_ENABLED = true;
        @ConfigEntry.Gui.Tooltip(count=3)
        public int DURABILITY = 80;
        @ConfigEntry.Gui.Tooltip(count=5)
        public int EAT_INTERVAL = 60;

        private MushroomHat() {
        }
    }

    public static final class PostmanHat
    implements ConfigData {
        @ConfigEntry.Gui.Tooltip(count=3)
        public boolean DAMAGE_ENABLED = true;
        @ConfigEntry.Gui.Tooltip(count=3)
        public int DURABILITY = 600;
        @ConfigEntry.Gui.Tooltip(count=4)
        public boolean HUNGER_ENABLED = true;

        private PostmanHat() {
        }
    }

    public static final class ShulkerHelmet
    implements ConfigData {
        @ConfigEntry.Gui.Tooltip(count=3)
        public boolean DAMAGE_ENABLED = true;
        @ConfigEntry.Gui.Tooltip(count=3)
        public int DURABILITY = 600;

        private ShulkerHelmet() {
        }
    }

    public static final class StockingCap
    implements ConfigData {
        @ConfigEntry.Gui.Tooltip(count=3)
        public boolean DAMAGE_ENABLED = true;
        @ConfigEntry.Gui.Tooltip(count=3)
        public int DURABILITY = 600;

        private StockingCap() {
        }
    }

    public static final class StrawHat
    implements ConfigData {
        @ConfigEntry.Gui.Tooltip(count=3)
        public boolean DAMAGE_ENABLED = true;
        @ConfigEntry.Gui.Tooltip(count=3)
        public int DURABILITY = 300;
        @ConfigEntry.Gui.Tooltip(count=5)
        public int SPEED_WITH_EFFICIENCY_0 = 20;
        @ConfigEntry.Gui.Tooltip(count=5)
        public int SPEED_WITH_EFFICIENCY_1 = 40;
        @ConfigEntry.Gui.Tooltip(count=5)
        public int SPEED_WITH_EFFICIENCY_2 = 60;
        @ConfigEntry.Gui.Tooltip(count=5)
        public int SPEED_WITH_EFFICIENCY_3 = 80;
        @ConfigEntry.Gui.Tooltip(count=5)
        public int SPEED_WITH_EFFICIENCY_4 = 100;
        @ConfigEntry.Gui.Tooltip(count=5)
        public int SPEED_WITH_EFFICIENCY_5 = 150;

        private StrawHat() {
        }
    }

    public static final class WingHelmet
    implements ConfigData {
        @ConfigEntry.Gui.Tooltip(count=3)
        public boolean DAMAGE_ENABLED = true;
        @ConfigEntry.Gui.Tooltip(count=3)
        public int DURABILITY = 600;
        @ConfigEntry.Gui.Tooltip(count=4)
        public boolean LEVITATION_ENABLED = true;

        private WingHelmet() {
        }
    }
}

