/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.usefulhats.item;

import de.cech12.usefulhats.CommonLoader;
import de.cech12.usefulhats.UsefulHatsUtils;
import de.cech12.usefulhats.item.AbstractHatItem;
import de.cech12.usefulhats.item.HatArmorMaterials;
import de.cech12.usefulhats.item.IEquipmentChangeListener;
import de.cech12.usefulhats.item.IItemFishedListener;
import de.cech12.usefulhats.item.ILivingDropsListener;
import de.cech12.usefulhats.platform.Services;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class LuckyHatItem
extends AbstractHatItem
implements IItemFishedListener,
ILivingDropsListener,
IEquipmentChangeListener {
    private static final int LUCK_DURATION = 219;
    private static final int UNLUCK_AMPLIFIER = 0;
    private static final int UNLUCK_DURATION = 200;

    public LuckyHatItem(String name) {
        super(name, HatArmorMaterials.LUCKY, Services.CONFIG::getLuckyHatDurability, Services.CONFIG::isLuckyHatDamageEnabled);
    }

    private boolean isLuckOrUnluckCausedByOtherSource(LivingEntity entity, ItemStack stack) {
        return this.isEffectCausedByOtherSource(entity, (Holder<MobEffect>)MobEffects.LUCK, 219, this.getLuckAmplifier(stack)) || this.isEffectCausedByOtherSource(entity, (Holder<MobEffect>)MobEffects.UNLUCK, 200, 0);
    }

    private int getEffectLevel(ItemStack stack) {
        return 1 + CommonLoader.getEnchantmentLevel(stack, (ResourceKey<Enchantment>)Enchantments.EFFICIENCY);
    }

    private int getLuckAmplifier(ItemStack stack) {
        return this.getEffectLevel(stack) - 1;
    }

    @Override
    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        tooltip.add((Component)Component.translatable((String)"item.usefulhats.lucky_hat.desc.luck", (Object[])new Object[]{UsefulHatsUtils.getRomanNumber(this.getEffectLevel(stack), false)}).withStyle(ChatFormatting.BLUE));
        if (Services.CONFIG.isLuckyHatUnluckEnabled()) {
            tooltip.add((Component)Component.translatable((String)"item.usefulhats.lucky_hat.desc.unluck").withStyle(ChatFormatting.RED));
        }
    }

    public void inventoryTick(@NotNull ItemStack stack, Level level, @NotNull Entity entity, int slot, boolean selectedIndex) {
        if (!level.isClientSide && entity instanceof Player) {
            Player player = (Player)entity;
            if (!Services.REGISTRY.getEquippedHatItemStacks((LivingEntity)player).contains(stack)) {
                return;
            }
            if (this.isLuckOrUnluckCausedByOtherSource((LivingEntity)player, stack)) {
                return;
            }
            int luckAmplifier = this.getLuckAmplifier(stack);
            if (player.getEffect(MobEffects.UNLUCK) == null) {
                if (player.getEffect(MobEffects.LUCK) == null || player.tickCount % 19 == 0) {
                    this.addEffect((LivingEntity)player, (Holder<MobEffect>)MobEffects.LUCK, 219, luckAmplifier);
                }
            } else {
                this.removeEffect((LivingEntity)player, (Holder<MobEffect>)MobEffects.LUCK, 219, luckAmplifier);
            }
        }
    }

    @Override
    public void onItemFishedListener(Player player, ItemStack headSlotItemStack) {
        if (this.isLuckOrUnluckCausedByOtherSource((LivingEntity)player, headSlotItemStack)) {
            return;
        }
        this.damageHatItemByOne(headSlotItemStack, (LivingEntity)player);
        if (Services.CONFIG.isLuckyHatUnluckEnabled()) {
            this.removeEffect((LivingEntity)player, (Holder<MobEffect>)MobEffects.LUCK, 219, this.getLuckAmplifier(headSlotItemStack));
            this.addEffect((LivingEntity)player, (Holder<MobEffect>)MobEffects.UNLUCK, 200, 0);
        }
    }

    @Override
    public void onLivingDropsEvent(LivingEntity dropReason, ItemStack headSlotItemStack) {
        if (this.isLuckOrUnluckCausedByOtherSource(dropReason, headSlotItemStack)) {
            return;
        }
        this.damageHatItemByOne(headSlotItemStack, dropReason);
        if (Services.CONFIG.isLuckyHatUnluckEnabled()) {
            this.removeEffect(dropReason, (Holder<MobEffect>)MobEffects.LUCK, 219, this.getLuckAmplifier(headSlotItemStack));
            this.addEffect(dropReason, (Holder<MobEffect>)MobEffects.UNLUCK, 200, 0);
        }
    }

    @Override
    public void onUnequippedHatItem(LivingEntity entity, ItemStack oldStack) {
        this.removeEffect(entity, (Holder<MobEffect>)MobEffects.LUCK, 219, this.getLuckAmplifier(oldStack));
    }
}

