/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.usefulhats.item;

import de.cech12.usefulhats.item.AbstractMiningHatItem;
import de.cech12.usefulhats.item.HatArmorMaterials;
import de.cech12.usefulhats.item.IEquipmentChangeListener;
import de.cech12.usefulhats.platform.Services;
import java.util.List;
import java.util.stream.StreamSupport;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class MiningHatItem
extends AbstractMiningHatItem
implements IEquipmentChangeListener {
    private static final int NIGHT_VISION_DURATION = 239;
    private static final int NIGHT_VISION_AMPLIFIER = 0;

    public MiningHatItem(String name) {
        super(name, HatArmorMaterials.MINING, Services.CONFIG::getMiningHatDurability, Services.CONFIG::isMiningHatDamageEnabled);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isLightEnabled(LivingEntity entity) {
        if (!Services.CONFIG.isMiningHatNightVisionEnabled()) return false;
        if (!Services.REGISTRY.getEquippedHatItemStacks(entity).stream().anyMatch(stack -> stack.getItem() instanceof MiningHatItem)) return false;
        if (!StreamSupport.stream(entity.getHandSlots().spliterator(), false).anyMatch(Services.REGISTRY::isAxe)) return false;
        if (entity.getEffect(MobEffects.NIGHT_VISION) != null) return false;
        if (entity.level().getMaxLocalRawBrightness(entity.blockPosition()) >= 8) return false;
        return true;
    }

    @Override
    protected double getSpeedConfig(int enchantmentLevel) {
        return Services.CONFIG.getMiningHatSpeedWithEfficiency(enchantmentLevel);
    }

    @Override
    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        int value = (int)(this.getEnchantmentDoubleValue(stack) * 100.0);
        tooltip.add((Component)Component.translatable((String)"item.usefulhats.mining_hat.desc.mining_speed", (Object[])new Object[]{value}).withStyle(ChatFormatting.BLUE));
        if (Services.CONFIG.isMiningHatNightVisionEnabled()) {
            if (Services.PLATFORM.isModLoaded("lucent")) {
                tooltip.add((Component)Component.translatable((String)"item.usefulhats.mining_hat.desc.lucent").withStyle(ChatFormatting.BLUE));
            } else {
                tooltip.add((Component)Component.translatable((String)"item.usefulhats.mining_hat.desc.night_vision").withStyle(ChatFormatting.BLUE));
            }
        }
    }

    public void inventoryTick(@NotNull ItemStack stack, Level level, @NotNull Entity entity, int slot, boolean selectedIndex) {
        if (!level.isClientSide && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (!Services.REGISTRY.getEquippedHatItemStacks(livingEntity).contains(stack)) {
                return;
            }
            if (!Services.CONFIG.isMiningHatNightVisionEnabled()) {
                return;
            }
            if (Services.PLATFORM.isModLoaded("lucent")) {
                if (MiningHatItem.isLightEnabled(livingEntity) && livingEntity.tickCount % 20 == 0) {
                    this.damageHatItemByOne(stack, livingEntity);
                }
                return;
            }
            if (this.isEffectCausedByOtherSource(livingEntity, (Holder<MobEffect>)MobEffects.NIGHT_VISION, 239, 0)) {
                return;
            }
            if (StreamSupport.stream(livingEntity.getHandSlots().spliterator(), false).anyMatch(Services.REGISTRY::isPickaxe) && livingEntity.level().getMaxLocalRawBrightness(livingEntity.blockPosition()) < 8) {
                if (livingEntity.getEffect(MobEffects.NIGHT_VISION) == null || livingEntity.tickCount % 19 == 0) {
                    this.addEffect(livingEntity, (Holder<MobEffect>)MobEffects.NIGHT_VISION, 239, 0);
                }
                if (livingEntity.tickCount % 20 == 0) {
                    this.damageHatItemByOne(stack, livingEntity);
                }
            } else {
                livingEntity.removeEffect(MobEffects.NIGHT_VISION);
            }
        }
    }

    @Override
    protected boolean isToolEffective(ItemStack tool, BlockState state) {
        return Services.REGISTRY.isPickaxe(tool) && state.is(BlockTags.MINEABLE_WITH_PICKAXE);
    }

    @Override
    public void onUnequippedHatItem(LivingEntity entity, ItemStack oldStack) {
        this.removeEffect(entity, (Holder<MobEffect>)MobEffects.NIGHT_VISION, 239, 0);
    }
}

