/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.usefulhats.item;

import de.cech12.usefulhats.item.AbstractHatItem;
import de.cech12.usefulhats.item.HatArmorMaterials;
import de.cech12.usefulhats.platform.Services;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class MushroomHatItem
extends AbstractHatItem {
    public MushroomHatItem(String name) {
        super(name, HatArmorMaterials.MUSHROOM, Services.CONFIG::getMushroomHatDurability, Services.CONFIG::isMushroomHatDamageEnabled);
    }

    @Override
    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        tooltip.add((Component)Component.translatable((String)"item.usefulhats.mushroom_hat.desc.feeding").withStyle(ChatFormatting.BLUE));
    }

    public void inventoryTick(@NotNull ItemStack stack, Level level, @NotNull Entity entity, int slot, boolean selectedIndex) {
        if (!level.isClientSide && entity instanceof Player) {
            Player player = (Player)entity;
            if (!Services.REGISTRY.getEquippedHatItemStacks((LivingEntity)player).contains(stack)) {
                return;
            }
            FoodData foodStats = player.getFoodData();
            if (foodStats.needsFood() && player.tickCount % Services.CONFIG.getMushroomHatEatInterval() == 0) {
                foodStats.eat(1, 0.5f);
                level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_BURP, SoundSource.PLAYERS, 0.5f, level.random.nextFloat() * 0.1f + 0.9f);
                this.damageHatItemByOne(stack, (LivingEntity)player);
            }
        }
    }
}

