/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.usefulhats.item;

import de.cech12.usefulhats.Constants;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.equipment.ArmorMaterial;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractHatItem
extends Item {
    private final Supplier<Integer> durabilityConfig;
    protected final Supplier<Boolean> enabledDamageConfig;

    public AbstractHatItem(String name, ArmorMaterial material, Supplier<Integer> durabilityConfig, Supplier<Boolean> enabledDamageConfig) {
        this(name, new Item.Properties().humanoidArmor(material, ArmorType.HELMET).component(DataComponents.EQUIPPABLE, (Object)Equippable.builder((EquipmentSlot)EquipmentSlot.HEAD).setEquipSound(material.equipSound()).setAsset(material.assetId()).setDamageOnHurt(false).build()).component(DataComponents.TOOLTIP_DISPLAY, (Object)AbstractHatItem.createTooltipDisplay()), durabilityConfig, enabledDamageConfig);
    }

    public AbstractHatItem(String name, Item.Properties properties, Supplier<Integer> durabilityConfig, Supplier<Boolean> enabledDamageConfig) {
        super(properties.setId(ResourceKey.create((ResourceKey)BuiltInRegistries.ITEM.key(), (ResourceLocation)Constants.id(name))));
        this.durabilityConfig = durabilityConfig;
        this.enabledDamageConfig = enabledDamageConfig;
    }

    public int getDurabilityFromConfig() {
        return this.durabilityConfig.get();
    }

    protected static TooltipDisplay createTooltipDisplay() {
        return TooltipDisplay.DEFAULT.withHidden(DataComponents.ATTRIBUTE_MODIFIERS, true);
    }

    protected boolean isEffectCausedByOtherSource(LivingEntity entity, Holder<MobEffect> effect, int maxDuration, int amplifier) {
        MobEffectInstance effectInstance = entity.getEffect(effect);
        return effectInstance != null && (effectInstance.isAmbient() || effectInstance.getDuration() >= maxDuration || effectInstance.getAmplifier() != amplifier);
    }

    protected void addEffect(LivingEntity entity, Holder<MobEffect> effect, int duration, int amplifier) {
        this.addEffect(entity, effect, duration, amplifier, false);
    }

    protected void addEffect(LivingEntity entity, Holder<MobEffect> effect, int duration, int amplifier, boolean showParticles) {
        entity.addEffect(new MobEffectInstance(effect, duration, amplifier, false, showParticles, true));
    }

    protected void removeEffect(LivingEntity entity, Holder<MobEffect> effect, int maxDuration, int amplifier) {
        MobEffectInstance effectInstance = entity.getEffect(effect);
        if (effectInstance != null && !effectInstance.isAmbient() && effectInstance.getDuration() <= maxDuration && effectInstance.getAmplifier() == amplifier) {
            entity.removeEffect(effect);
        }
    }

    protected void damageHatItemByOne(ItemStack stack, LivingEntity entity) {
        block5: {
            ServerLevel serverLevel;
            block6: {
                Level level;
                if (!this.enabledDamageConfig.get().booleanValue()) {
                    return;
                }
                if (entity.level().isClientSide() || !((level = entity.level()) instanceof ServerLevel)) break block5;
                serverLevel = (ServerLevel)level;
                if (!(entity instanceof ServerPlayer)) break block6;
                ServerPlayer player = (ServerPlayer)entity;
                if (player.getAbilities().instabuild) break block5;
            }
            if (stack.isDamageableItem()) {
                stack.hurtAndBreak(1, serverLevel, entity instanceof ServerPlayer ? (ServerPlayer)entity : null, item -> {
                    entity.onEquippedItemBroken(item, EquipmentSlot.HEAD);
                    stack.shrink(1);
                    if (entity instanceof ServerPlayer) {
                        ServerPlayer player = (ServerPlayer)entity;
                        player.awardStat(Stats.ITEM_BROKEN.get((Object)this));
                    }
                    stack.setDamageValue(0);
                });
            }
        }
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull TooltipDisplay display, @NotNull Consumer<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, display, tooltip, flagIn);
        tooltip.accept((Component)Component.empty());
        tooltip.accept((Component)Component.translatable((String)("item.modifiers." + EquipmentSlot.HEAD.getName())).withStyle(ChatFormatting.GRAY));
    }

    public int getMaxDamage(ItemStack stack) {
        return this.getDurabilityFromConfig();
    }
}

