/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.usefulhats.item;

import de.cech12.usefulhats.CommonLoader;
import de.cech12.usefulhats.UsefulHatsUtils;
import de.cech12.usefulhats.item.AbstractHatItem;
import de.cech12.usefulhats.item.HatArmorMaterials;
import de.cech12.usefulhats.item.IEquipmentChangeListener;
import de.cech12.usefulhats.item.IItemUseListener;
import de.cech12.usefulhats.item.ILivingJumpListener;
import de.cech12.usefulhats.platform.Services;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import org.jetbrains.annotations.NotNull;

public class BunnyEarsItem
extends AbstractHatItem
implements IEquipmentChangeListener,
IItemUseListener,
ILivingJumpListener {
    private static final int JUMP_BOOST_DURATION = 219;

    public BunnyEarsItem(String name) {
        super(name, HatArmorMaterials.BUNNY, Services.CONFIG::getBunnyEarsDurability, Services.CONFIG::isBunnyEarsDamageEnabled);
    }

    @Override
    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull TooltipDisplay display, @NotNull Consumer<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, display, tooltip, flagIn);
        int enchantmentLevel = CommonLoader.getEnchantmentLevel(stack, (ResourceKey<Enchantment>)Enchantments.EFFICIENCY) + 1;
        if (Services.CONFIG.isBunnyEarsJumpBoostEnabled()) {
            tooltip.accept((Component)Component.translatable((String)"item.usefulhats.bunny_ears.desc.jump_boost", (Object[])new Object[]{UsefulHatsUtils.getRomanNumber(enchantmentLevel, false)}).withStyle(ChatFormatting.BLUE));
        }
        if (Services.CONFIG.isBunnyEarsEatBoostEnabled()) {
            tooltip.accept((Component)Component.translatable((String)"item.usefulhats.bunny_ears.desc.eating", (Object[])new Object[]{enchantmentLevel + 1}).withStyle(ChatFormatting.BLUE));
        }
    }

    public void inventoryTick(@NotNull ItemStack stack, ServerLevel level, @NotNull Entity entity, EquipmentSlot slot) {
        if (Services.CONFIG.isBunnyEarsJumpBoostEnabled() && !level.isClientSide() && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (!Services.REGISTRY.getEquippedHatItemStacks(livingEntity).contains(stack)) {
                return;
            }
            int amplifier = CommonLoader.getEnchantmentLevel(stack, (ResourceKey<Enchantment>)Enchantments.EFFICIENCY);
            if (!(this.isEffectCausedByOtherSource(livingEntity, (Holder<MobEffect>)MobEffects.JUMP_BOOST, 219, amplifier) || livingEntity.getEffect(MobEffects.JUMP_BOOST) != null && livingEntity.tickCount % 19 != 0)) {
                this.addEffect(livingEntity, (Holder<MobEffect>)MobEffects.JUMP_BOOST, 219, amplifier);
            }
        }
    }

    @Override
    public int onItemUseEventStart(LivingEntity entity, ItemStack usedStack, int actualDuration, ItemStack headSlotItemStack) {
        if (Services.CONFIG.isBunnyEarsEatBoostEnabled() && usedStack.has(DataComponents.FOOD)) {
            int amplifier = CommonLoader.getEnchantmentLevel(headSlotItemStack, (ResourceKey<Enchantment>)Enchantments.EFFICIENCY) + 2;
            this.damageHatItemByOne(headSlotItemStack, entity);
            return actualDuration / amplifier;
        }
        return actualDuration;
    }

    @Override
    public void onUnequippedHatItem(LivingEntity entity, ItemStack oldStack) {
        if (Services.CONFIG.isBunnyEarsJumpBoostEnabled()) {
            int amplifier = CommonLoader.getEnchantmentLevel(oldStack, (ResourceKey<Enchantment>)Enchantments.EFFICIENCY);
            this.removeEffect(entity, (Holder<MobEffect>)MobEffects.JUMP_BOOST, 219, amplifier);
        }
    }

    @Override
    public void onLivingJumpEvent(LivingEntity jumpingEntity, ItemStack headSlotItemStack) {
        int amplifier;
        if (Services.CONFIG.isBunnyEarsJumpBoostEnabled() && !this.isEffectCausedByOtherSource(jumpingEntity, (Holder<MobEffect>)MobEffects.JUMP_BOOST, 219, amplifier = CommonLoader.getEnchantmentLevel(headSlotItemStack, (ResourceKey<Enchantment>)Enchantments.EFFICIENCY))) {
            this.damageHatItemByOne(headSlotItemStack, jumpingEntity);
        }
    }
}

