/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.usefulhats.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cech12.usefulhats.Constants;
import de.cech12.usefulhats.item.AbstractHatItem;
import de.cech12.usefulhats.item.HatArmorMaterials;
import de.cech12.usefulhats.item.IRightClickListener;
import de.cech12.usefulhats.platform.Services;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class EnderHelmetItem
extends AbstractHatItem
implements IRightClickListener {
    public EnderHelmetItem(String name) {
        super(name, HatArmorMaterials.ENDER, Services.CONFIG::getEnderHelmetDurability, Services.CONFIG::isEnderHelmetDamageEnabled);
    }

    @Override
    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull TooltipDisplay display, @NotNull Consumer<Component> tooltip, @NotNull TooltipFlag flagIn) {
        tooltip.accept((Component)Component.translatable((String)"item.usefulhats.ender_helmet.desc.define_teleport").withStyle(ChatFormatting.BLUE));
        Position position = EnderHelmetItem.getPosition(stack);
        if (position != null) {
            super.appendHoverText(stack, context, display, tooltip, flagIn);
            tooltip.accept((Component)Component.translatable((String)"item.usefulhats.ender_helmet.desc.teleport").withStyle(ChatFormatting.BLUE));
            tooltip.accept((Component)Component.translatable((String)"item.usefulhats.ender_helmet.desc.teleport_position", (Object[])new Object[]{position.pos.getX(), position.pos.getY(), position.pos.getZ()}).withStyle(ChatFormatting.BLUE));
            tooltip.accept((Component)Component.literal((String)position.dimName.toString()).withStyle(ChatFormatting.BLUE));
        }
    }

    private static void setPosition(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity entity) {
        stack.set(Constants.ENDER_HELMET_POSITION.get(), (Object)new Position(level.dimension().registry(), level.dimension().location(), entity.blockPosition()));
    }

    private static boolean hasPosition(@NotNull ItemStack stack) {
        return stack.has(Constants.ENDER_HELMET_POSITION.get());
    }

    private static Position getPosition(@NotNull ItemStack stack) {
        if (EnderHelmetItem.hasPosition(stack)) {
            return (Position)stack.get(Constants.ENDER_HELMET_POSITION.get());
        }
        return null;
    }

    private static boolean levelEqualsPosition(Level level, Position position) {
        return level.dimension().registry().equals((Object)position.dimKey) && level.dimension().location().equals((Object)position.dimName);
    }

    private ServerLevel getLevel(@NotNull MinecraftServer server, @NotNull ItemStack stack) {
        Position position = EnderHelmetItem.getPosition(stack);
        if (position != null) {
            for (ServerLevel world : server.getAllLevels()) {
                if (!EnderHelmetItem.levelEqualsPosition((Level)world, position)) continue;
                return world;
            }
        }
        return null;
    }

    private static boolean canTeleportToPosition(@NotNull Level level, @NotNull BlockPos pos) {
        return !level.getBlockState(pos).canOcclude() && !level.getBlockState(pos.above()).canOcclude();
    }

    @NotNull
    public InteractionResult use(@NotNull Level worldIn, @NotNull Player playerIn, @NotNull InteractionHand handIn) {
        ItemStack stack = playerIn.getItemInHand(handIn);
        if (playerIn.isShiftKeyDown() && !stack.isEmpty()) {
            if (!worldIn.isClientSide()) {
                EnderHelmetItem.setPosition(stack, worldIn, (LivingEntity)playerIn);
                playerIn.setItemInHand(handIn, stack);
                ((ServerPlayer)playerIn).connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"item.usefulhats.ender_helmet.message.position_saved")));
            }
            return InteractionResult.SUCCESS;
        }
        return super.use(worldIn, playerIn, handIn);
    }

    @Override
    public boolean onRightClickItemEvent(Level level, Player player, ItemStack usedStack, InteractionHand hand, ItemStack headSlotItemStack) {
        if (!Services.REGISTRY.getEquippedHatItemStacks((LivingEntity)player).contains(headSlotItemStack)) {
            return false;
        }
        if (usedStack.getItem() != Items.ENDER_PEARL || !EnderHelmetItem.hasPosition(headSlotItemStack)) {
            return false;
        }
        player.swing(hand);
        if (!level.isClientSide()) {
            Position position = EnderHelmetItem.getPosition(headSlotItemStack);
            if (position != null && (Services.CONFIG.isEnderHelmetInterdimensionalEnabled() || EnderHelmetItem.levelEqualsPosition(level, position))) {
                ServerLevel destinationWorld = this.getLevel(player.level().getServer(), headSlotItemStack);
                BlockPos destinationPos = position.pos;
                if (destinationPos != null && destinationWorld != null && EnderHelmetItem.canTeleportToPosition((Level)destinationWorld, destinationPos)) {
                    player.getCooldowns().addCooldown(usedStack, 20);
                    player.fallDistance = 0.0;
                    player.playNotifySound(SoundEvents.ENDERMAN_TELEPORT, SoundSource.PLAYERS, 1.0f, 1.0f);
                    if (player.level() != destinationWorld) {
                        player.teleport(new TeleportTransition(destinationWorld, new Vec3((double)destinationPos.getX() + 0.5, (double)destinationPos.getY(), (double)destinationPos.getZ() + 0.5), Vec3.ZERO, player.yRotO, player.xRotO, Relative.union((Set[])new Set[]{Relative.ROTATION, Relative.DELTA}), TeleportTransition.DO_NOTHING));
                    } else {
                        player.teleportTo((double)destinationPos.getX() + 0.5, (double)destinationPos.getY(), (double)destinationPos.getZ() + 0.5);
                    }
                    player.playNotifySound(SoundEvents.ENDERMAN_TELEPORT, SoundSource.PLAYERS, 1.0f, 1.0f);
                    player.awardStat(Stats.ITEM_USED.get((Object)usedStack.getItem()));
                    if (!player.getAbilities().instabuild) {
                        usedStack.shrink(1);
                    }
                    this.damageHatItemByOne(headSlotItemStack, (LivingEntity)player);
                } else {
                    ((ServerPlayer)player).connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"item.usefulhats.ender_helmet.message.position_obstructed")));
                }
            } else {
                ((ServerPlayer)player).connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"item.usefulhats.ender_helmet.message.wrong_dimension")));
            }
        }
        return true;
    }

    public record Position(ResourceLocation dimKey, ResourceLocation dimName, BlockPos pos) {
        public static final Codec<Position> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("dimKey").forGetter(Position::dimKey), (App)ResourceLocation.CODEC.fieldOf("dimName").forGetter(Position::dimName), (App)BlockPos.CODEC.fieldOf("pos").forGetter(Position::pos)).apply((Applicative)instance, Position::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, Position> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, Position::dimKey, (StreamCodec)ResourceLocation.STREAM_CODEC, Position::dimName, (StreamCodec)BlockPos.STREAM_CODEC, Position::pos, Position::new);
    }
}

