/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.usefulhats.item;

import de.cech12.usefulhats.item.AbstractMiningHatItem;
import de.cech12.usefulhats.item.HatArmorMaterials;
import de.cech12.usefulhats.item.IBreakSpeedChanger;
import de.cech12.usefulhats.platform.Services;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class StrawHatItem
extends AbstractMiningHatItem
implements IBreakSpeedChanger {
    public StrawHatItem(String name) {
        super(name, HatArmorMaterials.STRAW, Services.CONFIG::getStrawHatDurability, Services.CONFIG::isStrawHatDamageEnabled);
    }

    @Override
    protected double getSpeedConfig(int enchantmentLevel) {
        return Services.CONFIG.getStrawHatSpeedWithEfficiency(enchantmentLevel);
    }

    @Override
    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull TooltipDisplay display, @NotNull Consumer<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, display, tooltip, flagIn);
        int value = (int)(this.getEnchantmentDoubleValue(stack) * 100.0);
        tooltip.accept((Component)Component.translatable((String)"item.usefulhats.straw_hat.desc.digging_speed", (Object[])new Object[]{value}).withStyle(ChatFormatting.BLUE));
    }

    @Override
    protected boolean isToolEffective(ItemStack tool, BlockState state) {
        return Services.REGISTRY.isShovel(tool) && state.is(BlockTags.MINEABLE_WITH_SHOVEL) || Services.REGISTRY.isHoe(tool) && state.is(BlockTags.MINEABLE_WITH_HOE);
    }
}

