/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.usefulhats.item;

import de.cech12.usefulhats.item.AbstractHatItem;
import de.cech12.usefulhats.item.HatArmorMaterials;
import de.cech12.usefulhats.item.IEquipmentChangeListener;
import de.cech12.usefulhats.platform.Services;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import org.jetbrains.annotations.NotNull;

public class WingHelmetItem
extends AbstractHatItem
implements IEquipmentChangeListener {
    private static final int SLOW_FALLING_AMPLIFIER = 0;
    private static final int SLOW_FALLING_DURATION = 219;
    private static final int LEVITATION_AMPLIFIER = 2;
    private static final int LEVITATION_DURATION = 200;

    public WingHelmetItem(String name) {
        super(name, HatArmorMaterials.WING, Services.CONFIG::getWingHelmetDurability, Services.CONFIG::isWingHelmetDamageEnabled);
    }

    @Override
    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull TooltipDisplay display, @NotNull Consumer<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, display, tooltip, flagIn);
        tooltip.accept((Component)Component.translatable((String)"item.usefulhats.wing_helmet.desc.slow_falling").withStyle(ChatFormatting.BLUE));
        if (Services.CONFIG.isWingHelmetLevitationEnabled()) {
            tooltip.accept((Component)Component.translatable((String)"item.usefulhats.wing_helmet.desc.scared").withStyle(ChatFormatting.RED));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isPlayerFalling(LivingEntity entity) {
        if (entity.onGround()) return false;
        if (!(entity.getDeltaMovement().y() < 0.0)) return false;
        if (!(entity instanceof Player)) return false;
        Player player = (Player)entity;
        if (player.getAbilities().flying) return false;
        if (entity.isFallFlying()) return false;
        if (Services.REGISTRY.isEntityInFluid(entity)) return false;
        return true;
    }

    public void inventoryTick(@NotNull ItemStack stack, ServerLevel level, @NotNull Entity entity, EquipmentSlot slot) {
        if (!level.isClientSide() && entity instanceof LivingEntity) {
            boolean isSlowFallingEffectActive;
            boolean isLevitationEffectActive;
            LivingEntity livingEntity = (LivingEntity)entity;
            if (!Services.REGISTRY.getEquippedHatItemStacks(livingEntity).contains(stack)) {
                return;
            }
            boolean isLevitationFromOtherSource = this.isEffectCausedByOtherSource(livingEntity, (Holder<MobEffect>)MobEffects.LEVITATION, 200, 2);
            boolean bl = isLevitationEffectActive = livingEntity.getEffect(MobEffects.LEVITATION) != null;
            if (!isLevitationEffectActive && Services.CONFIG.isWingHelmetLevitationEnabled() && livingEntity.getLastDamageSource() != null && livingEntity.getLastDamageSource().getEntity() instanceof LivingEntity && level.random.nextInt(100) == 0) {
                this.removeEffect(livingEntity, (Holder<MobEffect>)MobEffects.SLOW_FALLING, 219, 0);
                this.addEffect(livingEntity, (Holder<MobEffect>)MobEffects.LEVITATION, 200, 2, true);
                isLevitationEffectActive = true;
            }
            boolean isSlowFallingFromOtherSource = this.isEffectCausedByOtherSource(livingEntity, (Holder<MobEffect>)MobEffects.SLOW_FALLING, 219, 0);
            boolean bl2 = isSlowFallingEffectActive = livingEntity.getEffect(MobEffects.SLOW_FALLING) != null;
            if (this.isPlayerFalling(livingEntity)) {
                if (!(isLevitationEffectActive || isSlowFallingFromOtherSource || isSlowFallingEffectActive && livingEntity.tickCount % 19 != 0)) {
                    this.addEffect(livingEntity, (Holder<MobEffect>)MobEffects.SLOW_FALLING, 219, 0);
                    isSlowFallingEffectActive = true;
                }
            } else {
                this.removeEffect(livingEntity, (Holder<MobEffect>)MobEffects.SLOW_FALLING, 219, 0);
            }
            if ((isSlowFallingEffectActive && !isSlowFallingFromOtherSource || isLevitationEffectActive && !isLevitationFromOtherSource && Services.CONFIG.isWingHelmetLevitationEnabled()) && livingEntity.tickCount % 20 == 0) {
                this.damageHatItemByOne(stack, livingEntity);
            }
        }
    }

    @Override
    public void onUnequippedHatItem(LivingEntity entity, ItemStack oldStack) {
        this.removeEffect(entity, (Holder<MobEffect>)MobEffects.SLOW_FALLING, 219, 0);
        if (Services.CONFIG.isWingHelmetLevitationEnabled()) {
            this.removeEffect(entity, (Holder<MobEffect>)MobEffects.LEVITATION, 200, 2);
        }
    }
}

