/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.usefulhats.item;

import com.mojang.blaze3d.systems.RenderSystem;
import de.cech12.usefulhats.CommonLoader;
import de.cech12.usefulhats.Constants;
import de.cech12.usefulhats.item.AbstractHatItem;
import de.cech12.usefulhats.item.HatArmorMaterials;
import de.cech12.usefulhats.item.IEquipmentChangeListener;
import de.cech12.usefulhats.item.IGameOverlayRenderer;
import de.cech12.usefulhats.platform.Services;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_9779;
import org.jetbrains.annotations.NotNull;

public class AquanautHelmetItem
extends AbstractHatItem
implements IEquipmentChangeListener,
IGameOverlayRenderer {
    private static final class_2960 AQUANAUT_GUI_TEX_PATH = Constants.id("textures/misc/aquanautblur.png");

    public AquanautHelmetItem() {
        super(HatArmorMaterials.AQUANAUT, AquanautHelmetItem.rawColorFromRGB(71, 191, 74), Services.CONFIG::getAquanautHelmetDurability, Services.CONFIG::isAquanautHelmetDamageEnabled);
    }

    private int getConduitPowerDuration(class_1799 stack) {
        return Services.CONFIG.getAquanautHelmetEffectTimeWithEfficiency(CommonLoader.getEnchantmentLevel(stack, (class_5321<class_1887>)class_1893.field_9131)) * 20;
    }

    @Override
    public void method_7851(@NotNull class_1799 stack, @NotNull class_1792.class_9635 context, @NotNull List<class_2561> tooltip, @NotNull class_1836 flagIn) {
        super.method_7851(stack, context, tooltip, flagIn);
        int effectTime = Services.CONFIG.getAquanautHelmetEffectTimeWithEfficiency(CommonLoader.getEnchantmentLevel(stack, (class_5321<class_1887>)class_1893.field_9131));
        tooltip.add((class_2561)class_2561.method_43469((String)"item.usefulhats.aquanaut_helmet.desc.conduit_power", (Object[])new Object[]{effectTime}).method_27692(class_124.field_1078));
    }

    public void method_7888(@NotNull class_1799 stack, class_1937 level, @NotNull class_1297 entity, int slot, boolean selectedIndex) {
        if (!level.field_9236 && entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            if (!Services.REGISTRY.getEquippedHatItemStacks(livingEntity).contains(stack)) {
                return;
            }
            int maxDuration = this.getConduitPowerDuration(stack);
            if (this.isEffectCausedByOtherSource(livingEntity, (class_6880<class_1291>)class_1294.field_5927, maxDuration, 0)) {
                return;
            }
            if (!Services.REGISTRY.areEntityEyesInDrownableFluid(livingEntity)) {
                this.addEffect(livingEntity, (class_6880<class_1291>)class_1294.field_5927, maxDuration, 0);
            } else if (livingEntity.method_6112(class_1294.field_5927) != null && livingEntity.field_6012 % 20 == 0) {
                this.damageHatItemByOne(stack, livingEntity);
            }
        }
    }

    @Override
    public void onUnequippedHatItem(class_1309 entity, class_1799 oldStack) {
        if (!entity.method_37908().field_9236) {
            if (Services.REGISTRY.getEquippedHatItemStacks(entity).stream().anyMatch(stack -> stack.method_7909() == this)) {
                return;
            }
            this.removeEffect(entity, (class_6880<class_1291>)class_1294.field_5927, this.getConduitPowerDuration(oldStack), 0);
        }
    }

    @Override
    public void onRenderGameOverlay(class_332 guiGraphics, class_9779 deltaTracker) {
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        guiGraphics.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        guiGraphics.method_25291(AQUANAUT_GUI_TEX_PATH, 0, 0, -90, 0.0f, 0.0f, guiGraphics.method_51421(), guiGraphics.method_51443(), guiGraphics.method_51421(), guiGraphics.method_51443());
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        guiGraphics.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
    }
}

