/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.usefulhats.item;

import de.cech12.usefulhats.item.AbstractHatItem;
import de.cech12.usefulhats.item.HatArmorMaterials;
import de.cech12.usefulhats.platform.Services;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import org.jetbrains.annotations.NotNull;

public class StockingCapItem
extends AbstractHatItem {
    public StockingCapItem(String name) {
        super(name, HatArmorMaterials.STOCKING, Services.CONFIG::getStockingCapDurability, Services.CONFIG::isStockingCapDamageEnabled);
    }

    @Override
    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull TooltipDisplay display, @NotNull Consumer<Component> tooltip, @NotNull TooltipFlag flagIn) {
    }

    public void inventoryTick(@NotNull ItemStack stack, ServerLevel level, @NotNull Entity entity, EquipmentSlot slot) {
        if (!level.isClientSide && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (level.random.nextInt(1000) == 0) {
                if (!Services.REGISTRY.getEquippedHatItemStacks(livingEntity).contains(stack)) {
                    return;
                }
                this.damageHatItemByOne(stack, livingEntity);
            }
        }
    }
}

